/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rpta;

public class SvgProducer {
    public static void main(String[] args) {
        System.out.println(SvgProducer.SimpleBarChart("40|110", 100.0, 120.0, 50.0, "#cccccc", "steelblue", true));
    }

    public static String SimpleBarChart(String barValueStr, double totalValue, double totalWidth, double height, String bgColor, String fgColor, boolean alignLeft) {
        double barValue = 0.0;
        int delim = barValueStr.indexOf("|");
        if (delim != 0) {
            barValue = Double.valueOf(barValueStr.substring(0, delim));
            totalValue = Double.valueOf(barValueStr.substring(delim + 1));
        } else {
            barValue = Double.valueOf(barValueStr);
        }
        if (Double.valueOf(totalValue) == null) {
            totalValue = 100.0;
        }
        String ret = SvgProducer.generateSvg(totalValue, totalWidth, height, bgColor, fgColor, alignLeft, barValue);
        return ret;
    }

    public static String SimpleBarChart(double barValue, double totalValue, double totalWidth, double height, String bgColor, String fgColor, boolean alignLeft) {
        if (Double.valueOf(totalValue) == null) {
            totalValue = 100.0;
        }
        String ret = SvgProducer.generateSvg(totalValue, totalWidth, height, bgColor, fgColor, alignLeft, barValue);
        return ret;
    }

    private static String generateSvg(double totalValue, double totalWidth, double height, String bgColor, String fgColor, boolean alignLeft, double barValue) {
        double barWidth = totalWidth * (barValue / totalValue);
        double x = 0.0;
        if (!alignLeft) {
            x = totalWidth - barWidth;
        }
        String ret = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"" + totalWidth + "px\" height=\"" + height + "px\">";
        ret = ret + "<g><rect x=\"0\" y=\"0\" width=\"" + totalWidth + "px\" height=\"" + height + "px\" fill=\"" + bgColor + "\"><title>" + totalValue + "</title></rect>";
        ret = ret + "<rect class=\"chartBar\" width=\"" + barWidth + "\" height=\"" + (height - 1.0) + "\" x=\"" + x + "\" y=\"0\" rx=\"5\" ry=\"5\" fill=\"" + fgColor + "\"><title>" + barValue + "</title></rect>";
        ret = ret + "</g></svg>";
        return ret;
    }
}

