/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.db.NichtAngemeldetException;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.CryptUtils;
import de.memtext.util.DateUtils;
import de.memtext.util.ServletHelper;
import de.superx.common.AbstractSicht;
import de.superx.common.DBServletException;
import de.superx.common.Sichten;
import de.superx.common.SxFinRechte;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.SxUser;
import de.superx.servlet.FieldElementCache;
import de.superx.servlet.LdapPasswordChecker;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SichtServlet;
import de.superx.servlet.SichtartRechteDefinition;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxPools;
import de.superx.servlet.Themenbaum;
import de.superx.servlet.TokenChecker;
import de.superx.util.SqlStringUtils;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class UserInitializer {
    public static final String MAXIMALE_LOGIN_VERSUCHE_\u00dcBERSCHRITTEN = "Maximale Login-Versuche \u00fcberschritten";
    private boolean isFromApplet = false;
    private SxUser user;
    private boolean isPasswordChangeDemanded = false;
    private Integer userid = new Integer(-1);
    private String username = "";
    private Short adminUser;
    protected HttpServletRequest request;
    private String mandantenID = "default";
    private String oldsha;

    public UserInitializer(HttpServletRequest request, boolean isFromApplet) throws IOException {
        this.request = request;
        this.isFromApplet = isFromApplet;
    }

    public void perform() throws NichtAngemeldetException, IllegalArgumentException, SecurityException, TransformerConfigurationException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, TransformerException, KeyParentEqualException, SQLException, DBServletException {
        this.mandantenID = ServletHelper.getParameter(this.request, "MandantenID");
        if (this.mandantenID == null) {
            this.mandantenID = "default";
        }
        this.perform(this.mandantenID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(String mandantenID) throws NichtAngemeldetException, IllegalArgumentException, SecurityException, TransformerConfigurationException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, TransformerException, KeyParentEqualException, SQLException, DBServletException {
        this.mandantenID = mandantenID;
        this.authenticate(mandantenID);
        UserInitializer userInitializer = this;
        synchronized (userInitializer) {
            HttpSession session = this.request.getSession(true);
            session.setAttribute("UserID", (Object)this.userid.toString());
            session.setAttribute("sessiontype", (Object)"superx");
            session.setAttribute("MandantenID", (Object)mandantenID);
            session.setAttribute("User-A", (Object)this.request.getHeader("User-Agent"));
            String desiredLocale = ServletHelper.getParameter(this.request, "locale");
            if (desiredLocale != null) {
                session.setAttribute("locale", (Object)desiredLocale);
            }
            if (SxPools.get((String)mandantenID).userpool.containsItemWithId(this.userid)) {
                this.user = (SxUser)SxPools.get((String)mandantenID).userpool.getById(this.userid);
            } else {
                try {
                    this.user = UserInitializer.initUser(mandantenID, this.username, this.userid, this.adminUser);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException(e.toString());
                }
            }
            this.initPWG\u00fcltigkeit_Oldshas();
            session.setAttribute("username", (Object)this.user.getName());
            session.setAttribute("user", (Object)this.user);
            session.setAttribute("sessiontype", (Object)"superx");
            session.setAttribute("UserIsAdmin", (Object)(this.user.isAdmin() ? "true" : "false"));
            session.setAttribute("UserMaskRights", (Object)this.user.getMaskRights());
            session.setAttribute("UserGroups", (Object)this.user.getGroups());
            session.setAttribute("UserSachgebiete", (Object)this.user.getSachgebiete());
            session.setAttribute("UserGroupnames", (Object)this.user.getGroupnames());
            if (this.isPasswordChangeDemanded()) {
                session.setAttribute("passwordchange", (Object)"true");
            }
        }
    }

    private void initPWG\u00fcltigkeit_Oldshas() {
        block7: {
            Connection con = null;
            try {
                con = SxPools.getConnection(this.mandantenID);
                Statement st = con.createStatement();
                ResultSet rs = st.executeQuery("select passwd_sha from userinfo where tid=" + this.userid);
                while (rs.next()) {
                    this.user.setCurrentSha(rs.getString(1));
                }
                rs.close();
                rs = st.executeQuery("select pw_gueltig_bis,old_sha1,old_sha2,old_sha3,old_sha4,old_sha5,old_sha6,old_sha7 from user_pw where userinfo_id=" + this.userid);
                while (rs.next()) {
                    Date gueltig_bis = rs.getDate(1);
                    java.util.Date today = new java.util.Date();
                    if (gueltig_bis != null && !DateUtils.isDateInFuture(gueltig_bis)) {
                        this.isPasswordChangeDemanded = true;
                    }
                    this.user.setOldSha(0, rs.getString(2));
                    this.user.setOldSha(1, rs.getString(3));
                    this.user.setOldSha(2, rs.getString(4));
                    this.user.setOldSha(3, rs.getString(5));
                    this.user.setOldSha(4, rs.getString(6));
                    this.user.setOldSha(5, rs.getString(7));
                    this.user.setOldSha(6, rs.getString(8));
                }
                rs.close();
                st.close();
                con.close();
            }
            catch (Exception e) {
                System.out.println(e);
                if (con == null) break block7;
                try {
                    SxPools.invalidate(this.mandantenID, con);
                }
                catch (DBServletException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private void authenticate(String mandantenID) throws DBServletException, NichtAngemeldetException {
        this.adminUser = new Short(0);
        boolean isRemotePasswordCheck = false;
        String passwort = null;
        String token = ServletHelper.getParameter(this.request, "token");
        if (token != null && !token.equals("")) {
            TokenChecker tokenChecker = new TokenChecker(token);
            tokenChecker.testAll();
            isRemotePasswordCheck = true;
            this.username = tokenChecker.getKennung();
        } else {
            HttpSession session;
            this.username = ServletHelper.getParameter(this.request, "kennung");
            passwort = ServletHelper.getParameter(this.request, "passwort");
            if (passwort == null || passwort.length() == 0) {
                passwort = "notsecret";
            }
            String login = ServletHelper.getParameter(this.request, "login");
            if (SuperXManager.isStandaloneLdapActive() && "superx".equals(login)) {
                System.out.println("LDAP aktiv aber Passwortkontrolle f\u00fcr " + this.username + " aus SuperX-Datenbank wegen Parameter login=superx");
            }
            if (SuperXManager.isStandaloneLdapActive() && !"superx".equals(login)) {
                isRemotePasswordCheck = true;
            }
            if (this.isFromApplet && (session = this.request.getSession(false)) != null) {
                session.invalidate();
            }
        }
        System.out.println("Session authenticated with user=" + this.username);
        this.checkUserInDb(this.username, isRemotePasswordCheck, passwort);
    }

    public static SxUser initUser(String mandantenID, String username, Integer userid, Object adminUser) throws IllegalArgumentException, SecurityException, TransformerConfigurationException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, TransformerException, KeyParentEqualException, SQLException, DBServletException, NichtAngemeldetException, CloneNotSupportedException, NoMainEntryException, TemplateException, IOException {
        SxUser user = new SxUser(mandantenID, username, userid);
        user.getSelectionBuffer().setActive(SuperXManager.isSessionFieldDefaultsWanted(mandantenID));
        user.setDBVersion(SxPools.get(mandantenID).getDatabaseMajorVersion(), SxPools.get(mandantenID).getDatabaseMinorVersion());
        user.setAdmin(adminUser.toString().equals("1"));
        String queryMaskenRechte = "--alle Abfragen f\u00fcr die die Gruppe \u00fcber Sachgebiete berechtigt \nselect distinct M.tid,M.name \n\t\t  from  maskeninfo M, sachgeb_maske_bez S, group_sachgeb_bez G, user_group_bez U \n\t\t where M.tid = S.maskeninfo_id \n\t\t and S.sachgebiete_id = G.sachgebiete_id \n\t\t   and G.groupinfo_id = U.groupinfo_id \n\t\t   and U.userinfo_id = " + user.getId() + " \n\t\t union  \n\t\t --alle Abfragen f\u00fcr die die Gruppe berechtigt (Einzelrechte) \n\tselect distinct M.tid,M.name \n\t\t  from  maskeninfo M, group_masken_bez G, user_group_bez U \n\t\t where  M.tid = G.maskeninfo_id \n\t\t   and G.groupinfo_id = U.groupinfo_id \n\t\t   and U.userinfo_id = " + user.getId() + " \n\t\t union  \n--alle Abfragen aus Sachgebieten f\u00fcr die der Nutzer Rechte hat \n\tselect distinct M.tid,M.name \n\t\tfrom  maskeninfo M  \n\t\twhere  \n \t\t (M.tid in (select maskeninfo_id from sachgeb_maske_bez S where S.sachgebiete_id in  \n\t\t (select sachgebiete_id from user_sachgeb_bez U where U.userinfo_id=" + user.getId() + " )))  \n\t\tunion  \n--alle Abfragen f\u00fcr die Einzelrechte in user_masken_bez angegeben \n\tselect distinct M.tid,M.name \n\t\tfrom  maskeninfo M, user_masken_bez B  \n\t\twhere \n\t\t B.userinfo_id = " + user.getId() + " \n\t\t \t and (M.tid = B.maskeninfo_id \n\t\t or B.maskeninfo_id = 0)";
        SxResultSet rs = ServletUtils.execute("Erlaubte Masken f\u00fcr User " + user.getName() + " (" + user.getId() + ")", queryMaskenRechte, user.getMandantenID());
        user.initErlaubteMasken(rs);
        rs = ServletUtils.execute("Erlaubte Sachgebiete f\u00fcr User " + user.getName() + " (" + user.getId() + ")", "select sachgebiete_id from user_sachgeb_bez where userinfo_id=" + user.getId() + " \nunion \nselect sachgebiete_id from group_sachgeb_bez where groupinfo_id in ( \nselect groupinfo_id from user_group_bez where userinfo_id=" + user.getId() + ")", user.getMandantenID());
        user.setSachgebiete(rs);
        rs = ServletUtils.execute("Einlesen von Gruppen f\u00fcr Benutzer " + user.getId(), "select tid,name from groupinfo G, user_group_bez U where G.tid=U.groupinfo_id and userinfo_id=" + user.getId(), user.getMandantenID());
        user.setGroups(rs);
        try {
            rs = ServletUtils.execute("Einlesen von versteckten Feldern f\u00fcr Benutzer " + user.getId(), "select field_id from group_field_pref where pref='hidden' and groupinfo_id in (select groupinfo_id from user_group_bez where userinfo_id=" + user.getId() + ")", user.getMandantenID());
            user.setHiddenFields(rs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (SichtartRechteDefinition sd : SxPools.get(user.getMandantenID()).getSichtartRechteDefinitionen()) {
            rs = ServletUtils.execute("Einlesen von Sichtart " + sd.getName() + " Rechten f\u00fcr Benutzer " + user.getId(), sd.getSql(userid), user.getMandantenID());
            user.getSichten().addSichtartRechte(sd.getName(), sd.isFallback_user_inst(), rs);
        }
        rs = ServletUtils.execute("Einlesen von Sichten f\u00fcr Benutzer " + user.getId(), Sichten.getReadingSql(user), user.getMandantenID());
        user.getSichten().init(user.getMandantenID(), rs, SichtServlet.class);
        for (SichtartRechteDefinition sd : SxPools.get(user.getMandantenID()).getSichtartRechteDefinitionen()) {
            if (!sd.hasAdditionalKeysSQL()) continue;
            boolean isSQLOK = true;
            String sql = sd.getAdditionalKeysSQL();
            sql = sql.replaceAll("<<UserID>>", user.getId().toString());
            for (String sichtart : user.getSichten().getSichtenArten()) {
                if (sql.indexOf("<<" + sichtart + ">>") <= -1) continue;
                String sichtartkeys = user.getSichten().getSichtartKeys(sichtart);
                if (sichtartkeys.equals("")) {
                    isSQLOK = false;
                }
                sql = sql.replaceAll("<<" + sichtart + ">>", sichtartkeys);
            }
            if (!isSQLOK) continue;
            SxResultSet rs2 = ServletUtils.execute("Einlesen erg\u00e4nzenden Rechten von Sichtart " + sd.getName() + " Rechten f\u00fcr Benutzer " + user.getId(), sql, user.getMandantenID());
            user.getSichten().addSichtartRechte(sd.getName(), sd.isFallback_user_inst(), rs2);
        }
        for (SichtartRechteDefinition sd : SxPools.get(user.getMandantenID()).getSichtartRechteDefinitionen()) {
            if (sd.isFallback_user_inst()) continue;
        }
        rs = ServletUtils.execute("Einlesen von Sichtrechten f\u00fcr Benutzer " + user.getId(), "select distinct tid,type from sichten S where " + Sichten.getErlaubteSichtenSql(user), user.getMandantenID());
        user.getSichten().setAllowedSichten(rs, user.isAdmin());
        user.initThemenbaum(Themenbaum.class);
        int finRightVariant = SxPools.get(mandantenID).getFinRightVariant();
        if (finRightVariant != 0 && !user.isAdmin()) {
            if (finRightVariant == 1) {
                rs = ServletUtils.execute("Einlesen von einfachtenFin-Rechten f\u00fcr Benutzer " + user.getId(), SxFinRechte.getReadingSqlUserKamSimple(user), user.getMandantenID());
            }
            if (finRightVariant == 2) {
                rs = ServletUtils.execute("Einlesen von erweiterten Fin-Rechten f\u00fcr Benutzer " + user.getId(), SxFinRechte.getReadingSqlUserKam(user), user.getMandantenID());
            }
            if (finRightVariant == 3) {
                rs = ServletUtils.execute("Einlesen von erweiterten Fin-Rechten inkl. ins3 f\u00fcr Benutzer " + user.getId(), SxFinRechte.getReadingSqlUserKamIns3(user, SxPools.get(mandantenID).hasFinUserKamRestrictionFields()), user.getMandantenID());
            }
            SxResultSet rs2 = ServletUtils.executeALL_el(null, null, "Einlesen von Fin-Rechten proj_to_inst  f\u00fcr Benutzer " + user.getId(), SxFinRechte.getReadingSqlProjToInst(SxPools.get(mandantenID).getDatabaseAbbr(), user), user.getMandantenID(), true).getResultSet();
            user.initFinRechte(rs, finRightVariant, rs2, SxPools.get(mandantenID).is0FINJoker(), SxPools.get(mandantenID).getRepository());
        }
        if (SxPools.get(mandantenID).hasKontierungsrechte()) {
            SxResultSet rs3 = ServletUtils.executeALL_el(null, null, "Einlesen von Kontierungsrechten  f\u00fcr Benutzer " + user.getId(), "select finanzstelle,hhprog,fonds,fipos from gxstage_user_rights where userinfo_id=" + user.getId(), user.getMandantenID(), true).getResultSet();
            user.initKontierungsrechte(rs3);
        }
        return user;
    }

    private static void initUserField1Cache(SxUser user) throws SQLException, DBServletException {
        SxResultSet rs = ServletUtils.execute("potentielle zu cachende User-Field1-quellen lesen", "select distinct relation from felderinfo where  and art=1 and tid!=23541", user.getMandantenID());
        TreeSet<String> sqls = new TreeSet<String>();
        String haushaltsjahr = DateUtils.getYear(new Date(new java.util.Date().getTime()));
        Hashtable<String, String> formular = new Hashtable<String, String>();
        formular.put("Haushaltsjahr", haushaltsjahr);
        for (SxResultRow row : rs) {
            String sql = (String)row.get(0);
            if (sql.trim().indexOf("<<SQL>>") == -1) continue;
            sql = SqlStringUtils.generateSQL("PG", formular, sql);
            try {
                HashMap map = new HashMap();
                map.putAll(user.getBasicMap());
                sql = SxPools.get(user.getMandantenID()).getTemplateProcessor().process(map, null, "user Field1 Cache", sql, null, SxPools.get(user.getMandantenID()).getRepository(), SxPools.get(user.getMandantenID()).getSqlDialect());
                if ((sql = AbstractSicht.getStrippedSQL(sql)).indexOf("<<") != -1) continue;
                sqls.add(sql);
            }
            catch (Exception e) {
                Logger.getLogger("superx_" + user.getMandantenID()).log(Level.INFO, "Problem bei Caching des User-Feld-SQLs " + sql + " " + e);
            }
        }
        FieldElementCache userFieldElementCache = (FieldElementCache)user.getFieldElementCache();
        for (String sql : sqls) {
            Logger.getLogger("superx_" + user.getMandantenID()).log(Level.FINER, " Cache User-Feld-SQL:  " + sql);
            try {
                rs = ServletUtils.executeALL_el(null, null, "Felder-SQL cachen", sql, user.getMandantenID(), true).getResultSet();
                userFieldElementCache.add(sql, rs);
            }
            catch (Exception e) {
                Logger.getLogger("superx_" + user.getMandantenID()).log(Level.INFO, "Problem bei Caching des User-Feld-SQLs " + sql + " " + e);
            }
        }
    }

    private void checkUserInDb(String user, boolean isRemotePasswortCheck, String passwort) throws DBServletException, NichtAngemeldetException {
        String password_sha = "";
        String client_ip = this.request.getRemoteAddr();
        String client_dns = this.request.getRemoteHost();
        String protend = "";
        this.userid = null;
        protend = SxPools.get(this.mandantenID).getSqlDialect().equals("Postgres") ? ", now());" : ", current);";
        Connection myConnection = null;
        try {
            myConnection = SxPools.getConnection(this.mandantenID);
            boolean isUserinfoMitGueltigkeit = this.checkUserinfoMitGueltigkeit(myConnection);
            String select = "select tid, passwd_sha, administration, kennwort,akt_versuch,max_versuch from userinfo where benutzer = ? ";
            if (isUserinfoMitGueltigkeit) {
                select = select + "and ( (gueltig_von is null or gueltig_von<=today()) and (gueltig_bis is null or gueltig_bis>=today()) )";
            }
            Statement stm = myConnection.createStatement();
            PreparedStatement pst = myConnection.prepareStatement(select);
            pst.setString(1, user);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                int max_versuch;
                this.userid = (Integer)rs.getObject(1);
                String kennwortSpalte = rs.getString(4);
                if (kennwortSpalte != null) {
                    kennwortSpalte = kennwortSpalte.trim().toLowerCase();
                }
                if (kennwortSpalte != null && (kennwortSpalte.equals("\u00e4ndern") || kennwortSpalte.equals("aendern")) && !isRemotePasswortCheck) {
                    this.isPasswordChangeDemanded = true;
                }
                this.adminUser = new Short(rs.getShort(3));
                password_sha = rs.getString(2);
                if (password_sha == null) {
                    throw new NichtAngemeldetException("Kein Passwort in DB gefunden");
                }
                this.oldsha = password_sha = password_sha.trim();
                int akt_versuch = rs.getInt(5);
                if (akt_versuch <= (max_versuch = rs.getInt(6)) && max_versuch != 0) continue;
                rs.close();
                pst.close();
                stm.close();
                myConnection.close();
                throw new NichtAngemeldetException(MAXIMALE_LOGIN_VERSUCHE_\u00dcBERSCHRITTEN);
            }
            rs.close();
            pst.close();
            System.out.println("userid: " + this.userid);
            if (this.userid == null) {
                stm.execute("insert into protokoll (proto_fkt_id, userinfo_id, ip_adresse, client_name, zeitpunkt) values (2, -1,'" + client_ip + "','" + client_dns + "'" + protend);
                stm.close();
                myConnection.close();
                throw new NichtAngemeldetException("Kein g\u00fcltiger Benutzer " + user + " in Datenbank vorhanden");
            }
            if (passwort == null) {
                passwort = "dummy";
            }
            boolean isPasswordOK = false;
            System.out.println("getAuthType: " + this.request.getAuthType());
            System.out.println("isRemotePasswortCheck: " + isRemotePasswortCheck);
            if (this.request.getAuthType().equals("shibboleth")) {
                isPasswordOK = true;
            } else if (isRemotePasswortCheck) {
                isPasswordOK = new LdapPasswordChecker().isLdapPasswordOK(false, this.mandantenID, user, passwort);
            } else {
                String encoded_sha = CryptUtils.encodeSHA(passwort);
                String encoded_sha2 = CryptUtils.encodeSHA(passwort + CryptUtils.geheimnis1);
                String encoded_sha512 = CryptUtils.encodeSHA512(passwort);
                if (password_sha.equals(encoded_sha) || password_sha.equals(encoded_sha2) || password_sha.equals(encoded_sha512)) {
                    isPasswordOK = true;
                }
            }
            System.out.println("isPasswordOK: " + isPasswordOK);
            if (isPasswordOK) {
                if (SxPools.get(this.mandantenID).isErweitertesProtokollWanted()) {
                    stm.execute("insert into protokoll (proto_fkt_id, userinfo_id, ip_adresse, client_name, zeitpunkt) values (1," + this.userid.toString() + ",'" + client_ip + "','" + client_dns + "'" + protend);
                }
            } else {
                stm.execute("insert into protokoll (proto_fkt_id, userinfo_id, ip_adresse, client_name, zeitpunkt) values (2," + this.userid.toString() + ",'" + client_ip + "','" + client_dns + "'" + protend);
                stm.close();
                UserInitializer.versuchszahlErh\u00f6hen(user, myConnection);
                myConnection.close();
                throw new NichtAngemeldetException("Falsches Passwort f\u00fcr User " + user);
            }
            PreparedStatement pst2 = myConnection.prepareStatement("update userinfo set akt_versuch=0   where benutzer = ?");
            pst2.setString(1, user);
            pst2.executeUpdate();
            pst2.close();
            this.updateLastLogin(myConnection);
            myConnection.close();
            myConnection = null;
        }
        catch (SQLException se) {
            se.printStackTrace();
            if (myConnection != null) {
                SxPools.invalidate(this.mandantenID, myConnection);
            }
            Logger.getLogger("superx_" + this.mandantenID).log(Level.SEVERE, "SQL-Fehler: " + se.toString());
            throw new DBServletException(se.getMessage());
        }
    }

    private boolean checkUserinfoMitGueltigkeit(Connection dbConnection) throws SQLException {
        boolean result = false;
        Statement stm = dbConnection.createStatement();
        DatabaseMetaData md = dbConnection.getMetaData();
        ResultSet rs = md.getColumns(null, null, "userinfo", null);
        while (rs.next()) {
            if (!rs.getString(4).equals("gueltig_von")) continue;
            result = true;
        }
        rs.close();
        return result;
    }

    private void updateLastLogin(Connection myConnection) throws SQLException {
        PreparedStatement pst3 = myConnection.prepareStatement("select count(*) from user_pw where userinfo_id=?");
        pst3.setInt(1, this.userid);
        ResultSet rs = pst3.executeQuery();
        int count = 0;
        while (rs.next()) {
            count = rs.getInt(1);
        }
        rs.close();
        pst3.close();
        if (count == 0) {
            pst3 = myConnection.prepareStatement("insert into user_pw (userinfo_id,last_login) values (?,now());");
            pst3.setInt(1, this.userid);
            pst3.executeUpdate();
            pst3.close();
        } else {
            pst3 = myConnection.prepareStatement("update user_pw set last_login=now() where userinfo_id=?");
            pst3.setInt(1, this.userid);
            pst3.executeUpdate();
            pst3.close();
        }
    }

    static void versuchszahlErh\u00f6hen(String user, Connection myConnection) throws SQLException {
        PreparedStatement pst3 = myConnection.prepareStatement("update userinfo set akt_versuch=akt_versuch+1   where benutzer = ?");
        pst3.setString(1, user);
        int rows = pst3.executeUpdate();
        pst3.close();
    }

    public String getUsername() {
        return this.username;
    }

    public SxUser getUser() {
        return this.user;
    }

    public boolean isPasswordChangeDemanded() {
        String attrib = "false";
        if (this.request.getSession() != null && (attrib = (String)this.request.getSession().getAttribute("passwordchange")) == null) {
            attrib = "false";
        }
        return this.isPasswordChangeDemanded || attrib.equals("true");
    }

    public void setPasswordChangeDemanded(boolean isPasswordChangeDemanded) {
        this.isPasswordChangeDemanded = isPasswordChangeDemanded;
    }

    public static String getPwChangeHtml(String message) {
        return SuperXManager.htmlPageHead("Passwort &auml;ndern") + "<form action=\"de.superx.servlet.SuperXmlPwChanger\" method=post>" + message + "<br>Bisheriges Passwort<br><input type=password name=\"altes_passwort\" maxlength=40 size=20><br><br>Neues Passwort<br><input type=password name=\"passwort\" maxlength=40 size=20><br>Erneut eingeben<br><input type=password name=\"passwort2\" maxlength=40 size=20><br><br><input class=\"button is-link\" type=\"submit\" value=\"Abschicken\"></form>" + SuperXManager.pageEnd;
    }

    private static boolean isGuestUser(Connection con, String kennung) throws SQLException {
        boolean result = false;
        try (PreparedStatement pst = con.prepareStatement("select name from userinfo where benutzer = ?");){
            pst.setString(1, kennung);
            try (ResultSet rs = pst.executeQuery();){
                if (rs.next()) {
                    String name = rs.getString("name");
                    result = name != null && name.trim().equals("Gastkennung");
                }
            }
        }
        return result;
    }

    public String getOldsha() {
        return this.oldsha;
    }
}

