/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.db.NichtAngemeldetException;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.DateUtils;
import de.memtext.util.ServletHelper;
import de.memtext.util.StringUtils;
import de.superx.common.DBServletException;
import de.superx.common.InvalidDataTypeException;
import de.superx.common.InvalidKeyException;
import de.superx.common.SichtException;
import de.superx.common.UngueltigeEingabeException;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SuperXManager;
import de.superx.util.SqlStringUtils;
import freemarker.template.TemplateException;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.JEditorPane;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

public abstract class SuperXServletHelper
extends ServletHelper {
    protected String userid;
    private boolean isAjaxResponder = false;
    protected String currentXml;

    public SuperXServletHelper(HttpServletRequest request, HttpServletResponse response) throws IOException {
        super(request, response, "superx");
    }

    public static void removeCookie(HttpServletRequest request, HttpServletResponse response) {
        try {
            Cookie[] cookies = request.getCookies();
            if (cookies.length > 0) {
                for (int i = 0; i < cookies.length; ++i) {
                    String host;
                    Cookie c = cookies[i];
                    if (!c.getName().equals("JSESSIONID") && !c.getName().equals("JSESSIONIDSSO")) continue;
                    Cookie c2 = new Cookie(c.getName(), "1234567890");
                    c2.setMaxAge(0);
                    if (c.getName().equals("JSESSIONID")) {
                        c2.setPath("/superx");
                    }
                    if (c.getName().equals("JSESSIONIDSSO")) {
                        c2.setPath("/");
                    }
                    if ((host = request.getHeader("host")) != null && host.startsWith(".")) {
                        host = host.substring(1);
                    }
                    c2.setDomain(host);
                    if (request.getScheme().equals("https")) {
                        c2.setSecure(true);
                    }
                    response.addCookie(c2);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void checkSessionType() throws NichtAngemeldetException {
        super.checkSessionType();
        if (!(SuperXManager.refererstart == null || SuperXManager.refererstart.equals("null") || this.request.getHeader("Referer") != null && this.request.getHeader("Referer").startsWith(SuperXManager.refererstart))) {
            System.out.println("Falscher Referer: " + this.request.getHeader("Referer") + " erwartet:" + SuperXManager.refererstart);
            throw new NichtAngemeldetException("False Referer");
        }
    }

    @Override
    public void run(boolean isAuthentificationCheckWanted) throws IOException, ServletException {
        try {
            if (isAuthentificationCheckWanted) {
                this.checkSessionType();
            }
            this.perform();
        }
        catch (NichtAngemeldetException e) {
            e.printStackTrace();
            this.sendNotAuthorized(e.getMessage());
        }
        catch (DBServletException e) {
            this.writeExceptionText("conn", e, null);
        }
        catch (TransformerException e) {
            Logger.getLogger("superx_" + this.getMandantenID()).log(Level.SEVERE, e.toString());
            this.response.reset();
            this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
            this.response.getWriter().println(ServletUtils.getXmlErrorText(e.toString(), this.currentXml, this.getDesiredLocale()));
        }
        catch (KeyParentEqualException | NoMainEntryException | SichtException | TemplateException | IOException | CloneNotSupportedException | IllegalAccessException | InstantiationException | NoSuchMethodException | RuntimeException | InvocationTargetException | SQLException | ParseException | FactoryConfigurationError | ParserConfigurationException | DocumentException | SAXException e) {
            e.printStackTrace();
            PrintWriter output = this.response.getWriter();
            Date timestamp = new Date();
            String msg = "<b> Es ist ein Fehler aufgetreten. </b><br> Bitte kontaktieren Sie Ihre Administratoren/innen. <br> ";
            String eMessage = new String();
            eMessage = e.toString();
            StringUtils.replace(eMessage, "<", "&lt;");
            StringUtils.replace(eMessage, ">", "&gt;");
            String eStackTrace = new String();
            StringWriter outstr = new StringWriter();
            e.printStackTrace(new PrintWriter(outstr));
            eStackTrace = outstr.toString();
            StringUtils.replace(eStackTrace, "<", "&lt;");
            StringUtils.replace(eStackTrace, ">", "&gt;");
            boolean isAdmin = false;
            if (this.request.getSession(false) != null) {
                boolean bl = isAdmin = this.request.getSession().getAttribute("UserIsAdmin") != null && this.request.getSession().getAttribute("UserIsAdmin").equals("true");
            }
            if (isAdmin) {
                output.println(SuperXManager.htmlPageHead("Problem") + "<p class='errmsg'><b> Es ist ein Fehler bei der Report-Erzeugung aufgetreten. </b><br>  <b> Hinweis zur Fehlerursache:  </b> <br>" + eMessage + "<br>  <b> Stacktrace </b> <br> " + eStackTrace + "<br> Timestamp des Servers: " + timestamp.toString() + "</p></body></html>");
            } else {
                output.println(SuperXManager.htmlPageHead("Problem") + "<p class='errmsg'>" + msg + " <b> Hinweis zur Fehlerursache:  </b> <br> " + e.toString() + "<br> Timestamp des Servers: " + timestamp.toString() + "</p></body></html>");
            }
        }
        catch (InvalidDataTypeException | InvalidKeyException | UngueltigeEingabeException e) {
            e.printStackTrace();
            this.writeResponse(e);
        }
    }

    protected void writeResponse(Exception e) {
        this.response.reset();
        String contenttype = this.request.getParameter("contenttype");
        try {
            String html = SuperXManager.htmlPageHead("Achtung") + "<h1>Achtung</h1><p>" + e.getMessage();
            if (contenttype != null && contenttype.startsWith("image/")) {
                this.returnHtmlAsImage(html, contenttype);
            } else {
                this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
                PrintWriter output = this.response.getWriter();
                output.write(html + "</p><p><a href='javascript:history.go(-1)'>Zur&uuml;ck</a></p></body></html>");
                output.close();
            }
            this.turnCacheOff();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    protected void returnHtmlAsImage(String html, String contenttype) throws IOException {
        this.response.setContentType(contenttype);
        BufferedImage bi = new BufferedImage(400, 400, 1);
        Graphics2D g = bi.createGraphics();
        JEditorPane jep = new JEditorPane("text/html", html);
        jep.setSize(new Dimension(400, 400));
        jep.print(g);
        ServletOutputStream sos = this.response.getOutputStream();
        ImageIO.write((RenderedImage)bi, contenttype.substring(contenttype.indexOf(47) + 1), (OutputStream)sos);
    }

    public void sendNotAuthorized(String message) throws IOException {
        this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
        String mand = null;
        try {
            mand = this.getMandantenID();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        PrintWriter p = this.response.getWriter();
        p.print(ServletUtils.getLoginFailureXml(this.userid, mand, this.getDesiredLocale()));
        p.close();
    }

    public void writeExceptionText(String loggerType, Throwable e, String task) {
        Logger.getLogger("superx_" + this.getMandantenID()).log(Level.SEVERE, e.toString());
        if (!this.isAjaxResponder()) {
            this.response.setStatus(500);
            this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
        } else {
            this.response.setContentType("text/json-comment-filtered");
        }
        PrintWriter output = null;
        try {
            output = new PrintWriter((OutputStream)this.response.getOutputStream());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.turnCacheOff();
        if (this.isAjaxResponder()) {
            String ex = "Serverfehler:" + StringUtils.jsonAdapt(e.toString(), true);
            output.println("/*({error:\"" + ex + "\"})*/");
        } else {
            String msg = "Es ist ein Fehler aufgetreten";
            boolean isAdmin = false;
            if (this.request.getSession(false) != null) {
                isAdmin = this.request.getSession().getAttribute("UserIsAdmin").equals("true");
            }
            if (task != null) {
                msg = msg + " bei: " + task;
            }
            StringBuffer info = new StringBuffer();
            System.out.println(DateUtils.getTodayString() + " " + DateUtils.getNowString() + " Error");
            e.printStackTrace();
            if (isAdmin) {
                info.append(e.toString());
                StringWriter outstr = new StringWriter();
                e.printStackTrace(new PrintWriter(outstr));
                info.append("  Stacktrace:" + outstr.toString());
                StringUtils.replace(info, "<", "&lt;");
                StringUtils.replace(info, ">", "&gt;");
            } else {
                String info2 = e.getMessage();
                if (info2.indexOf("DETAILS:") > -1) {
                    info2 = info2.substring(0, info2.indexOf("DETAILS:"));
                }
                info2 = info2 + "- bitte kontaktieren Sie Ihre Administratoren/innen und nennen Ihre Benutzerkennung, den aufgerufenen Bericht und Datum/Uhrzeit: " + DateUtils.getTodayString() + " " + DateUtils.getNowString();
                info.append(info2);
                StringUtils.replace(info, "IllegalStateException:", "");
                StringUtils.replace(info, "RuntimeException:", "");
                StringUtils.replace(info, "java.sql.SQLException:", "");
                StringUtils.replace(info, "org.postgresql.util.PSQLException:", "");
                StringUtils.replace(info, "de.superx.common.SichtException:", "");
            }
            output.println(SuperXManager.htmlPageHead("Fehler") + "<div class='error_infobox'><h1>" + msg + "</h1><p>");
            output.print(StringUtils.filterOutput(info.toString()));
            output.println("</p></div></body></html>");
        }
        output.flush();
        output.close();
    }

    @Override
    protected abstract void perform() throws SQLException, DBServletException, TransformerException, KeyParentEqualException, NichtAngemeldetException, IOException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, CloneNotSupportedException, TemplateException, InvalidKeyException, SichtException, IOException, ServletException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException;

    public String getMandantenID() {
        return ServletUtils.getMandantenID(this.request);
    }

    public boolean isAjaxResponder() {
        return this.isAjaxResponder;
    }

    public void setAjaxResponder(boolean isAjaxResponder) {
        this.isAjaxResponder = isAjaxResponder;
    }

    class DummyErrorListener
    implements ErrorListener {
        DummyErrorListener() {
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            System.out.println(exception);
        }
    }
}

