/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.ExceptionHandler;
import de.superx.bin.SxJdbcClient;
import de.superx.bin.SxTransformer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Dostmt {
    Connection myDb;
    Statement st;
    boolean done = false;
    String delim = "\n";
    String header = "false";
    String logfile = "../conf/logging.properties";
    String tabelle = "";
    String dbpropfile = "../conf/db.properties";
    String outfile = "";
    String outFormat = "txt";
    Logger logger = Logger.getLogger(Dostmt.class.toString());
    private ExceptionHandler exceptionHandler = new ExceptionHandler(false);

    public Dostmt(String[] args) throws ClassNotFoundException, FileNotFoundException, IOException, SQLException {
        if (args.length > 0) {
            this.logfile = args[0].trim();
        } else {
            System.err.println("Mindestens drei Parameter (Pfad zu den logger.properties, Pfad zu den db.properties, Pfad zur SQL-Datei) erfoderlich");
            System.exit(1);
        }
        File f = new File(this.logfile);
        if (!f.exists()) {
            throw new IOException("Datei nicht gefunden: " + this.logfile);
        }
        FileInputStream ins = new FileInputStream(this.logfile);
        LogManager MyLogManager = LogManager.getLogManager();
        MyLogManager.readConfiguration(ins);
        this.logfile = MyLogManager.getProperty(".level");
        this.logger.info("Using Loggging-Level " + this.logfile);
        String _dateiPfad = "";
        if (args.length > 1) {
            this.dbpropfile = args[1].trim();
        } else {
            this.logger.severe("Mindestens drei Parameter (Pfad zu den logger.properties, Pfad zu den db.properties, Pfad zur SQL-Datei) erfoderlich");
            System.exit(1);
        }
        if (args.length > 2) {
            _dateiPfad = args[2].trim();
        } else {
            this.logger.severe("Mindestens drei Parameter (Pfad zu den logger.properties, Pfad zu den db.properties, Pfad zur SQL-Datei) erfoderlich");
            System.exit(1);
        }
        f = new File(_dateiPfad);
        if (!f.exists()) {
            throw new IOException("Datei nicht gefunden: " + _dateiPfad);
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
        String sql = "";
        String text = "";
        while ((text = in.readLine()) != null) {
            if (text.length() <= 1) continue;
            sql = sql + System.getProperty("line.separator") + text.trim();
        }
        in.close();
        this.logger.config("Inhalt von sql-Datei: \n" + sql);
        SxJdbcClient myClient = new SxJdbcClient(this.logger, this.dbpropfile, sql);
        try {
            SxTransformer myTransformer = null;
            myClient.execute();
            ResultSet myrs = myClient.getRs();
            if (myrs != null) {
                myTransformer = this.outfile.equals("") ? new SxTransformer(this.logger, System.out) : new SxTransformer(this.logger, new FileWriter(this.outfile));
                myTransformer.setDelim(this.delim);
                myTransformer.setHeader(this.header);
                myTransformer.setOutrs(myrs);
                myTransformer.setOutrsmd(myClient.getRsmd());
                myTransformer.printResult(this.outFormat);
            } else {
                this.logger.info("Keine R\u00fcckgabewerte aus SQL-Script");
            }
            myClient.close();
        }
        catch (SQLException e) {
            this.logger.severe("Fehler beim sql-Script: " + e.toString());
            this.exceptionHandler.handle(e);
        }
        this.logger.info("dosql erfolgreich beendet");
    }

    public static void instructions() {
        System.out.println("\nDieses Javaprogramm f\u00fchrt ein beliebiges sql-Script mit einer oder mehr sql-Anweisungen aus");
        System.out.println("Im Classpath muss superx-db.jar sowie der zugeh\u00f6rige jdbc-Treiber sein.");
        System.out.println("Befehl:\n java dosql <Dateipfad sql-Script> <delimiter>(optional) <Ausgabe der Feld\u00fcberschriften (optional, true oder false).");
        System.out.println("Default:\n java dosql <Dateipfad sql-Script> <TAB> true");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            Dostmt dostmt = new Dostmt(args);
        }
        catch (Exception ex) {
            System.err.println("Exception caught.\n" + ex);
            ex.printStackTrace();
        }
    }
}

