/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.parser.SDFParserContext;
import de.statspez.sdf.generator.util.DateTime;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DateTimeParser
extends SubParser {
    private String dateTag;
    private DateTime dateTime;

    public DateTimeParser(SuperParser superParser, ResolverInterface resolver, String dateTag) {
        super(superParser, resolver);
        this.dateTag = dateTag;
        this.dateTime = null;
    }

    public DateTime getDateTime() {
        return this.dateTime;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if ("year".equalsIgnoreCase(localName)) {
            try {
                if (chars.length() <= 0) return handled;
                this.dateTime.setYear(Integer.parseInt(chars));
                return handled;
            }
            catch (NumberFormatException e) {
                throw new MetaParseException("Fehlerhafte Jahresangabe!", (Exception)e);
            }
        } else if ("halfOfYear".equalsIgnoreCase(localName)) {
            try {
                if (chars.length() <= 0) return handled;
                int halfOfYear = Integer.parseInt(chars);
                if (halfOfYear < 1) throw new MetaParseException("Fehlerhafte Halbjahresangabe!");
                if (halfOfYear > 2) {
                    throw new MetaParseException("Fehlerhafte Halbjahresangabe!");
                }
                this.dateTime.setHalfOfYear(halfOfYear);
                return handled;
            }
            catch (NumberFormatException e) {
                throw new MetaParseException("Fehlerhafte Halbjahresangabe!", (Exception)e);
            }
        } else if ("semester".equalsIgnoreCase(localName)) {
            try {
                if (chars.length() <= 0) return handled;
                int semester = Integer.parseInt(chars);
                if (semester < 1) throw new MetaParseException("Fehlerhafte Semsterangabe!");
                if (semester > 2) {
                    throw new MetaParseException("Fehlerhafte Semsterangabe!");
                }
                this.dateTime.setSemester(semester);
                return handled;
            }
            catch (NumberFormatException e) {
                throw new MetaParseException("Fehlerhafte Semsterangabe!", (Exception)e);
            }
        } else if ("quarterOfYear".equalsIgnoreCase(localName)) {
            try {
                if (chars.length() <= 0) return handled;
                int quarterOfYear = Integer.parseInt(chars);
                if (quarterOfYear < 1) throw new MetaParseException("Fehlerhafte Quartalsangabe!");
                if (quarterOfYear > 4) {
                    throw new MetaParseException("Fehlerhafte Quartalsangabe!");
                }
                this.dateTime.setQuarterOfYear(quarterOfYear);
                return handled;
            }
            catch (NumberFormatException e) {
                throw new MetaParseException("Fehlerhafte Quartalsangabe!", (Exception)e);
            }
        } else if ("month".equalsIgnoreCase(localName)) {
            try {
                if (chars.length() <= 0) return handled;
                int month = Integer.parseInt(chars);
                if (month < 1) throw new MetaParseException("Fehlerhafte Monatangabe!");
                if (month > 12) {
                    throw new MetaParseException("Fehlerhafte Monatangabe!");
                }
                this.dateTime.setMonth(month);
                return handled;
            }
            catch (NumberFormatException e) {
                throw new MetaParseException("Fehlerhafte Monatangabe!", (Exception)e);
            }
        } else if ("day".equalsIgnoreCase(localName)) {
            try {
                if (chars.length() <= 0) return handled;
                int day = Integer.parseInt(chars);
                if (day < 1) throw new MetaParseException("Fehlerhafte Tagangabe!");
                if (day > 31) {
                    throw new MetaParseException("Fehlerhafte Tagangabe!");
                }
                this.dateTime.setDay(day);
                return handled;
            }
            catch (NumberFormatException e) {
                throw new MetaParseException("Fehlerhafte Tagangabe!", (Exception)e);
            }
        } else if ("weekOfYear".equalsIgnoreCase(localName)) {
            try {
                if (chars.length() <= 0) return handled;
                int weekOfYear = Integer.parseInt(chars);
                if (weekOfYear < 1) throw new MetaParseException("Fehlerhafte Wochenangabe!");
                if (weekOfYear > 53) {
                    throw new MetaParseException("Fehlerhafte Wochenangabe!");
                }
                this.dateTime.setWeekOfYear(weekOfYear);
                return handled;
            }
            catch (NumberFormatException e) {
                throw new MetaParseException("Fehlerhafte Wochenangabe!", (Exception)e);
            }
        } else {
            if ("time".equalsIgnoreCase(localName)) return handled;
            if ("UTCTime".equalsIgnoreCase(localName)) return handled;
            if ("hours".equalsIgnoreCase(localName)) return handled;
            if ("minutes".equalsIgnoreCase(localName)) return handled;
            if ("seconds".equalsIgnoreCase(localName)) return handled;
            if ("fractionSeconds".equalsIgnoreCase(localName)) return handled;
            if ("timeZoneName".equalsIgnoreCase(localName)) return handled;
            if ("timeZoneOffset".equalsIgnoreCase(localName)) return handled;
            return false;
        }
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if (this.dateTag.equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.dateTag.equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            this.dateTime = new DateTime();
            this.enable();
        } else if ("year".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("halfOfYear".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("semester".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("quarterOfYear".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("month".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("day".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("weekOfYear".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if (!("time".equalsIgnoreCase(localName) || "UTCTime".equalsIgnoreCase(localName) || "hours".equalsIgnoreCase(localName) || "minutes".equalsIgnoreCase(localName) || "seconds".equalsIgnoreCase(localName) || "fractionSeconds".equalsIgnoreCase(localName) || "timeZoneName".equalsIgnoreCase(localName) || "timeZoneOffset".equalsIgnoreCase(localName))) {
            throw MetaParseException.unknownTagException((String)localName);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.dateTag.equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.handleTag(namespaceURI, localName, qName)) {
            throw MetaParseException.unknownClosingTagException((String)localName);
        }
    }

    public MetaElementInterface object() {
        return null;
    }
}

