/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.meta.util;

import de.statspez.sdf.generator.meta.MetaCustomSDFFeldReferenz;
import de.statspez.sdf.generator.meta.generated.MetaErhebungsbeschreibung;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabegruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabesatz;
import de.statspez.sdf.generator.meta.util.FeatureGroupSearch;
import de.statspez.sdf.generator.meta.util.FeatureSearch;
import de.statspez.sdf.generator.meta.util.HelpFeatureSearch;
import java.util.Iterator;
import java.util.Map;

public class SDFStructureHelper {
    public static MetaCustomSDFFeldReferenz findHelpFeature(MetaErhebungsbeschreibung erhebungsbeschreibung, String helpFeatureName) {
        return new HelpFeatureSearch().find(erhebungsbeschreibung, helpFeatureName);
    }

    public static boolean hasManyDataGroups(MetaSDFAusgabesatz outputDataModel) {
        int dataGroups = 0;
        if (outputDataModel != null) {
            Iterator iter = outputDataModel.getAusgabegruppen();
            while (iter != null && iter.hasNext()) {
                MetaSDFAusgabegruppe dataGroup = (MetaSDFAusgabegruppe)iter.next();
                if (1 != dataGroup.getAttributDaten()) continue;
                ++dataGroups;
            }
        }
        return dataGroups > 1;
    }

    public static MetaSDFAusgabegruppe getDeafaultDataGroup(MetaSDFAusgabesatz outputDataModel) {
        MetaSDFAusgabegruppe defaultDataGroup = null;
        if (outputDataModel != null) {
            Iterator iter = outputDataModel.getAusgabegruppen();
            while (iter != null && iter.hasNext()) {
                MetaSDFAusgabegruppe dataGroup = (MetaSDFAusgabegruppe)iter.next();
                if (1 != dataGroup.getAttributDaten()) continue;
                defaultDataGroup = dataGroup;
                break;
            }
        }
        return defaultDataGroup;
    }

    public static MetaSDFAusgabegruppe findDataGroup(MetaErhebungsbeschreibung erhebungsbeschreibung, Map recordValues) {
        MetaSDFAusgabegruppe dataGroup = null;
        MetaSDFAusgabesatz outputDataModel = erhebungsbeschreibung.getAusgabesatz();
        if (outputDataModel != null) {
            if (SDFStructureHelper.hasManyDataGroups(outputDataModel)) {
                Iterator iter = outputDataModel.getAusgabegruppen();
                while (iter != null && iter.hasNext()) {
                    MetaSDFAusgabegruppe currentDataGroup = (MetaSDFAusgabegruppe)iter.next();
                    if (1 != currentDataGroup.getAttributDaten()) continue;
                    boolean selected = true;
                    Iterator references = currentDataGroup.getSDFFeldReferenzen();
                    while (references != null && references.hasNext()) {
                        MetaCustomSDFFeldReferenz reference = (MetaCustomSDFFeldReferenz)references.next();
                        if (!reference.isIstSelektor()) continue;
                        Object value = recordValues.get(reference.getReferenceName());
                        if (reference.getVorgabeWert() == null || reference.getVorgabeWert().equals("")) {
                            if (value != null && !value.equals("")) {
                                selected = false;
                            }
                        } else if (value == null || value.equals("")) {
                            selected = false;
                        } else if (!reference.getVorgabeWert().equals(value)) {
                            selected = false;
                        }
                        if (!selected) break;
                    }
                    if (!selected) continue;
                    dataGroup = currentDataGroup;
                    break;
                }
            } else {
                dataGroup = SDFStructureHelper.getDeafaultDataGroup(outputDataModel);
            }
        }
        return dataGroup;
    }

    public static MetaCustomSDFFeldReferenz findFeatureGroup(MetaSDFAusgabegruppe dataGroup, String featureGroupName) {
        return new FeatureGroupSearch().find(dataGroup, featureGroupName);
    }

    public static MetaCustomSDFFeldReferenz findFeature(MetaSDFAusgabegruppe dataGroup, String featureName) {
        return new FeatureSearch().find(dataGroup, featureName);
    }

    private SDFStructureHelper() {
    }
}

