/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.masken;

import de.statspez.pleditor.generator.masken.AbstractMaske;
import de.statspez.pleditor.generator.masken.AbstractMaskenParser;
import de.statspez.pleditor.generator.masken.DatumAusdruckList;
import de.statspez.pleditor.generator.masken.DatumMaske;
import de.statspez.pleditor.generator.masken.MaskeException;

public class DatumMaskenParser
extends AbstractMaskenParser {
    @Override
    public AbstractMaske parse(String maske) throws MaskeException {
        StringBuffer message = new StringBuffer();
        try {
            DatumReader reader;
            DatumAusdruckList list;
            DatumMaske dateMaske = new DatumMaske();
            if (maske == null || maske.length() == 0) {
                throw new MaskeException("Maske soll angegeben werden");
            }
            if (this.isSegmentGueltig(maske, message)) {
                maske = this.parseAusrichtung(dateMaske, maske);
                list = new DatumAusdruckList();
                reader = new DatumReader(list);
                int i = 0;
                while (i < maske.length()) {
                    reader.add(maske.charAt(i), i == maske.length() - 1);
                    ++i;
                }
            } else {
                throw new MaskeException(message.toString());
            }
            dateMaske.setzeMinLaenge(reader.laenge);
            dateMaske.setzeMaxLaenge(reader.laenge);
            String patternString = list.gibPattern(dateMaske.gibMinLaenge(), dateMaske.gibMaxLaenge());
            DatumMaske.createSimpleDateFormat(patternString);
            dateMaske.setzeMaskeAlsString(patternString);
            return dateMaske;
        }
        catch (Exception e) {
            throw new MaskeException("Die Datum-Maske ist falsch beschrieben." + (e.getMessage() != null ? " " + e.getMessage() : ""));
        }
    }

    @Override
    protected String parseAusrichtung(AbstractMaske abstractMaske, String maske) {
        if (maske != null && maske.length() > 0 && 'M' == maske.charAt(0)) {
            String MMM = new String(new char[]{'M', 'M', 'M'});
            String MM = new String(new char[]{'M', 'M'});
            if (maske.startsWith(MMM) || !maske.startsWith(MM)) {
                abstractMaske.setzeAusrichtung('M');
                maske = maske.substring(1);
            }
        } else {
            maske = super.parseAusrichtung(abstractMaske, maske);
        }
        return maske;
    }

    private char toEnglisch(char ch) {
        switch (ch) {
            case 'J': {
                return 'y';
            }
            case 'T': {
                return 'd';
            }
            case 'S': {
                return 'H';
            }
        }
        return ch;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isSegmentGueltig(String segment, StringBuffer message) {
        maskiert = false;
        ok = true;
        zaehler = new SymbolZaehler();
        anz = segment.length();
        i = 0;
        while (ok && i < anz) {
            block30: {
                block31: {
                    ch = segment.charAt(i);
                    if (!this.istSymbol(ch) || maskiert) break block31;
                    switch (ch) {
                        case 'L': 
                        case 'R': {
                            if (i != 0) {
                                ok = false;
                                if (message != null) {
                                    message.append("Ausrichtungssymbol '" + ch + "' darf nur am Anfang der Maskendefinition vorkommen.");
                                    ** break;
                                }
                            }
                            break block30;
                        }
                        case 'M': {
                            isAusrichtung = false;
                            if (i == 0) {
                                j = 0;
                                while (j < segment.length() && segment.charAt(j) == 'M') {
                                    isAusrichtung = isAusrichtung == false;
                                    ++j;
                                }
                            }
                            if (!isAusrichtung) {
                                try {
                                    SymbolZaehler.access$2(zaehler, ch, null);
                                }
                                catch (MaskeException e) {
                                    ok = false;
                                    if (message != null) {
                                        message.append(e.getMessage());
                                    }
                                }
                            }
                            break block30;
                        }
                        case '\\': {
                            try {
                                SymbolZaehler.access$1(zaehler, null);
                                maskiert = true;
                            }
                            catch (MaskeException e1) {
                                ok = false;
                                if (message != null) {
                                    message.append(e1.getMessage());
                                }
                                break block30;
                            }
                        }
                        case '@': {
                            try {
                                SymbolZaehler.access$1(zaehler, null);
                            }
                            catch (MaskeException e1) {
                                ok = false;
                                if (message != null) {
                                    message.append(e1.getMessage());
                                }
                                break block30;
                            }
                        }
                        default: {
                            try {
                                SymbolZaehler.access$2(zaehler, ch, null);
                            }
                            catch (MaskeException e) {
                                ok = false;
                                if (message == null) break block30;
                                message.append(e.getMessage());
lbl67:
                                // 2 sources

                                break block30;
                            }
                        }
                    }
                }
                if (ch == ' ') {
                    ok = false;
                    if (message != null) {
                        message.append("Kein Leerzeichen in der Maskendefinition erlaubt.");
                    }
                } else {
                    if (maskiert) {
                        maskiert = false;
                    }
                    try {
                        SymbolZaehler.access$1(zaehler, null);
                    }
                    catch (MaskeException e) {
                        ok = false;
                        if (message == null) break block30;
                        message.append(e.getMessage());
                    }
                }
            }
            ++i;
        }
        return ok;
    }

    @Override
    public boolean isSegmentGueltig(String segment) {
        return this.isSegmentGueltig(segment, null);
    }

    @Override
    protected void initSymbole() {
        this.symbole = new char[]{'L', 'M', 'R', 'J', 'M', 'T', 'S', 'm', 's', '\\', '@'};
    }

    private class DatumReader {
        private StringBuffer text;
        private boolean negation;
        private SymbolZaehler zaehler;
        private DatumAusdruckList list;
        private int laenge;

        private DatumReader(DatumAusdruckList list) {
            this.zaehler = new SymbolZaehler();
            this.list = list;
            this.text = new StringBuffer();
            this.negation = false;
            this.zaehler = new SymbolZaehler();
            this.laenge = 0;
        }

        public void add(char ch, boolean last) throws MaskeException {
            if ('@' == ch) {
                if (this.negation) {
                    this.addToText(ch);
                } else {
                    this.addToText(' ');
                }
            } else if ('\\' == ch) {
                if (this.negation) {
                    this.addToText(ch);
                } else {
                    this.negation = true;
                }
            } else if (DatumMaskenParser.this.istSymbol(ch) && !this.negation) {
                this.addToSymbol(ch);
            } else {
                this.addToText(ch);
            }
            if (last) {
                if (this.text.length() > 0) {
                    this.list.fuegeAusdruckHinzu(this.text.toString());
                } else {
                    this.zaehler.print(this.list);
                }
            }
        }

        private void addToText(char ch) throws MaskeException {
            ++this.laenge;
            if (this.zaehler.anz > 0) {
                this.zaehler.print(this.list);
            }
            if (this.negation) {
                this.negation = false;
            }
            this.text.append(ch);
        }

        private void addToSymbol(char ch) throws MaskeException {
            ++this.laenge;
            this.printText();
            this.zaehler.add(ch, this.list);
        }

        private void printText() {
            if (this.text.length() > 0) {
                this.list.fuegeAusdruckHinzu(this.text.toString());
                this.text.setLength(0);
            }
        }
    }

    private class SymbolZaehler {
        private char symbol;
        int anz = 0;

        private SymbolZaehler() {
        }

        private void add(char ch, DatumAusdruckList list) throws MaskeException {
            if (this.symbol != ch) {
                this.print(list);
                this.symbol = ch;
                ++this.anz;
            } else {
                ++this.anz;
                if (this.symbol == 'J' && this.anz > 4 || this.symbol != 'J' && this.anz > 2) {
                    this.formatException(this.symbol);
                }
            }
        }

        private void print(DatumAusdruckList list) throws MaskeException {
            if (this.anz == 0) {
                return;
            }
            if (this.anz == 2 || this.anz == 4 && this.symbol == 'J') {
                if (list != null) {
                    StringBuffer buf = new StringBuffer();
                    char ch = DatumMaskenParser.this.toEnglisch(this.symbol);
                    int i = 0;
                    while (i < this.anz) {
                        buf.append(ch);
                        ++i;
                    }
                    list.fuegeAusdruckHinzu(buf.toString());
                }
                this.anz = 0;
                return;
            }
            this.formatException(this.symbol);
        }

        private void formatException(char ch) throws MaskeException {
            StringBuffer buf = new StringBuffer();
            switch (ch) {
                case 'J': {
                    buf.append("Jahresangabe ");
                    break;
                }
                case 'M': {
                    buf.append("Monatsangabe ");
                    break;
                }
                case 'T': {
                    buf.append("Tagesangabe ");
                    break;
                }
                case 'S': {
                    buf.append("Stundenangabe ");
                    break;
                }
                case 'm': {
                    buf.append("Minutenangabe ");
                    break;
                }
                case 's': {
                    buf.append("Sekundenangabe ");
                }
            }
            buf.append("ist falsch.");
            throw new MaskeException(buf.toString());
        }
    }
}

