/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.common;

import de.statspez.pleditor.generator.common.DefaultMessageContext;
import de.statspez.pleditor.generator.common.MessageContextInterface;
import java.io.Serializable;

public abstract class AbstractMessage
implements Serializable {
    private static final String DEFAULT_CONTEXT = "Keine Informationen ueber den Kontext verfuegbar";
    private MessageContextInterface context = null;
    private String message = null;
    private int line = -1;
    private int column = -1;

    public AbstractMessage(String message, int line, int column) {
        if (message == null) {
            throw new IllegalArgumentException("Die Nachricht darf nicht null sein!");
        }
        this.context = new DefaultMessageContext(DEFAULT_CONTEXT);
        this.message = message;
        this.line = line;
        this.column = column;
    }

    public AbstractMessage(MessageContextInterface context, String message, int line, int column) {
        if (message == null) {
            throw new IllegalArgumentException("Die Nachricht darf nicht null sein!");
        }
        this.context = context;
        this.message = message;
        this.line = line;
        this.column = column;
    }

    public abstract String messageType();

    public String message() {
        return this.message;
    }

    public int line() {
        return this.line;
    }

    public int column() {
        return this.column;
    }

    public MessageContextInterface context() {
        return this.context;
    }

    public String toString() {
        String erg = "";
        erg = this.context != null ? this.context.toString(this) : this.message();
        return erg;
    }

    public String toStringHTML() {
        String erg = "";
        erg = this.context != null ? this.context.toStringHTML(this) : this.message();
        return erg;
    }
}

