/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.olap4j.Axis;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.CellSetAxisMetaData;
import org.olap4j.CellSetMetaData;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.Position;
import org.olap4j.driver.xmla.MetadataReader;
import org.olap4j.driver.xmla.XmlaHelper;
import org.olap4j.driver.xmla.XmlaOlap4jCatalog;
import org.olap4j.driver.xmla.XmlaOlap4jCell;
import org.olap4j.driver.xmla.XmlaOlap4jCellProperty;
import org.olap4j.driver.xmla.XmlaOlap4jCellSetAxis;
import org.olap4j.driver.xmla.XmlaOlap4jCellSetAxisMetaData;
import org.olap4j.driver.xmla.XmlaOlap4jCellSetMemberProperty;
import org.olap4j.driver.xmla.XmlaOlap4jCellSetMetaData;
import org.olap4j.driver.xmla.XmlaOlap4jConnection;
import org.olap4j.driver.xmla.XmlaOlap4jCube;
import org.olap4j.driver.xmla.XmlaOlap4jDatabaseMetaData;
import org.olap4j.driver.xmla.XmlaOlap4jMember;
import org.olap4j.driver.xmla.XmlaOlap4jMemberBase;
import org.olap4j.driver.xmla.XmlaOlap4jPosition;
import org.olap4j.driver.xmla.XmlaOlap4jPositionMember;
import org.olap4j.driver.xmla.XmlaOlap4jPreparedStatement;
import org.olap4j.driver.xmla.XmlaOlap4jStatement;
import org.olap4j.driver.xmla.XmlaOlap4jUtil;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.Property;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class XmlaOlap4jCellSet
implements CellSet {
    private static final String VALUE_TAG = "Value";
    final XmlaOlap4jStatement olap4jStatement;
    protected boolean closed;
    private XmlaOlap4jCellSetMetaData metaData;
    private final Map<Integer, Cell> cellMap = new HashMap<Integer, Cell>();
    private final List<XmlaOlap4jCellSetAxis> axisList = new ArrayList<XmlaOlap4jCellSetAxis>();
    private final List<CellSetAxis> immutableAxisList = Olap4jUtil.cast(Collections.unmodifiableList(this.axisList));
    private XmlaOlap4jCellSetAxis filterAxis;
    private static final boolean DEBUG = false;
    private static final List<String> standardProperties = Arrays.asList("UName", "Caption", "LName", "LNum", "DisplayInfo");

    XmlaOlap4jCellSet(XmlaOlap4jStatement olap4jStatement) {
        assert (olap4jStatement != null);
        this.olap4jStatement = olap4jStatement;
        this.closed = false;
    }

    private XmlaHelper getHelper() {
        return this.olap4jStatement.olap4jConnection.helper;
    }

    void populate() throws OlapException {
        Document doc;
        byte[] bytes = this.olap4jStatement.getBytes();
        try {
            doc = XmlaOlap4jUtil.parse(bytes);
        }
        catch (IOException e) {
            throw this.getHelper().createException("error creating CellSet", e);
        }
        catch (SAXException e) {
            throw this.getHelper().createException("error creating CellSet", e);
        }
        Element envelope = doc.getDocumentElement();
        assert (envelope.getLocalName().equals("Envelope"));
        assert (envelope.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/"));
        Element body = XmlaOlap4jUtil.findChild(envelope, "http://schemas.xmlsoap.org/soap/envelope/", "Body");
        Element fault = XmlaOlap4jUtil.findChild(body, "http://schemas.xmlsoap.org/soap/envelope/", "Fault");
        if (fault != null) {
            throw this.getHelper().createException("XMLA provider gave exception: " + XmlaOlap4jUtil.prettyPrint(fault));
        }
        Element executeResponse = XmlaOlap4jUtil.findChild(body, "urn:schemas-microsoft-com:xml-analysis", "ExecuteResponse");
        Element returnElement = XmlaOlap4jUtil.findChild(executeResponse, "urn:schemas-microsoft-com:xml-analysis", "return");
        Element root = XmlaOlap4jUtil.findChild(returnElement, "urn:schemas-microsoft-com:xml-analysis:mddataset", "root");
        this.metaData = this.olap4jStatement instanceof XmlaOlap4jPreparedStatement ? ((XmlaOlap4jPreparedStatement)this.olap4jStatement).cellSetMetaData : this.createMetaData(root);
        Element axesNode = XmlaOlap4jUtil.findChild(root, "urn:schemas-microsoft-com:xml-analysis:mddataset", "Axes");
        MetadataReader metadataReader = this.metaData.cube.getMetadataReader();
        HashMap<String, XmlaOlap4jMember> memberMap = new HashMap<String, XmlaOlap4jMember>();
        ArrayList<String> uniqueNames = new ArrayList<String>();
        for (Element axisNode : XmlaOlap4jUtil.findChildren(axesNode, "urn:schemas-microsoft-com:xml-analysis:mddataset", "Axis")) {
            Element tuplesNode = XmlaOlap4jUtil.findChild(axisNode, "urn:schemas-microsoft-com:xml-analysis:mddataset", "Tuples");
            for (Element tupleNode : XmlaOlap4jUtil.findChildren(tuplesNode, "urn:schemas-microsoft-com:xml-analysis:mddataset", "Tuple")) {
                for (Element memberNode : XmlaOlap4jUtil.findChildren(tupleNode, "urn:schemas-microsoft-com:xml-analysis:mddataset", "Member")) {
                    String uname = XmlaOlap4jUtil.stringElement(memberNode, "UName");
                    uniqueNames.add(uname);
                }
            }
        }
        metadataReader.lookupMembersByUniqueName(uniqueNames, memberMap);
        HashMap<Property, Object> propertyValues = new HashMap<Property, Object>();
        for (Element axisNode : XmlaOlap4jUtil.findChildren(axesNode, "urn:schemas-microsoft-com:xml-analysis:mddataset", "Axis")) {
            String axisName = axisNode.getAttribute("name");
            Axis axis = this.lookupAxis(axisName);
            ArrayList<XmlaOlap4jPosition> positions = new ArrayList<XmlaOlap4jPosition>();
            XmlaOlap4jCellSetAxis cellSetAxis = new XmlaOlap4jCellSetAxis(this, axis, Collections.unmodifiableList(positions));
            if (axis.isFilter()) {
                this.filterAxis = cellSetAxis;
            } else {
                this.axisList.add(cellSetAxis);
            }
            Element tuplesNode = XmlaOlap4jUtil.findChild(axisNode, "urn:schemas-microsoft-com:xml-analysis:mddataset", "Tuples");
            for (Element tupleNode : XmlaOlap4jUtil.findChildren(tuplesNode, "urn:schemas-microsoft-com:xml-analysis:mddataset", "Tuple")) {
                ArrayList<Member> members = new ArrayList<Member>();
                for (Element memberNode : XmlaOlap4jUtil.findChildren(tupleNode, "urn:schemas-microsoft-com:xml-analysis:mddataset", "Member")) {
                    String hierarchyName = memberNode.getAttribute("Hierarchy");
                    String uname = XmlaOlap4jUtil.stringElement(memberNode, "UName");
                    XmlaOlap4jMemberBase member = (XmlaOlap4jMemberBase)memberMap.get(uname);
                    if (member == null) {
                        String caption = XmlaOlap4jUtil.stringElement(memberNode, "Caption");
                        int lnum = XmlaOlap4jUtil.integerElement(memberNode, "LNum");
                        Hierarchy hierarchy = this.lookupHierarchy(this.metaData.cube, hierarchyName);
                        Level level = (Level)hierarchy.getLevels().get(lnum);
                        member = new XmlaOlap4jSurpriseMember(this, level, hierarchy, lnum, caption, uname);
                    }
                    propertyValues.clear();
                    for (Element childNode : XmlaOlap4jUtil.childElements(memberNode)) {
                        XmlaOlap4jCellSetMemberProperty property = ((XmlaOlap4jCellSetAxisMetaData)cellSetAxis.getAxisMetaData()).lookupProperty(hierarchyName, childNode.getLocalName());
                        if (property == null) continue;
                        String value = childNode.getTextContent();
                        propertyValues.put(property, value);
                    }
                    if (!propertyValues.isEmpty()) {
                        member = new XmlaOlap4jPositionMember(member, propertyValues);
                    }
                    members.add(member);
                }
                positions.add(new XmlaOlap4jPosition(members, positions.size()));
            }
        }
        if (this.filterAxis == null) {
            this.filterAxis = new XmlaOlap4jCellSetAxis(this, (Axis)Axis.FILTER, Collections.singletonList(new XmlaOlap4jPosition(Collections.<Member>emptyList(), 0)));
        }
        Element cellDataNode = XmlaOlap4jUtil.findChild(root, "urn:schemas-microsoft-com:xml-analysis:mddataset", "CellData");
        for (Element cell : XmlaOlap4jUtil.findChildren(cellDataNode, "urn:schemas-microsoft-com:xml-analysis:mddataset", "Cell")) {
            propertyValues.clear();
            int cellOrdinal = Integer.valueOf(cell.getAttribute("CellOrdinal"));
            Object value = this.getTypedValue(cell);
            String formattedValue = XmlaOlap4jUtil.stringElement(cell, "FmtValue");
            String formatString = XmlaOlap4jUtil.stringElement(cell, "FormatString");
            Olap4jUtil.discard((Object)formatString);
            for (Element element : XmlaOlap4jUtil.childElements(cell)) {
                String tag = element.getLocalName();
                Property property = this.metaData.propertiesByTag.get(tag);
                if (property == null) continue;
                propertyValues.put(property, element.getTextContent());
            }
            this.cellMap.put(cellOrdinal, new XmlaOlap4jCell(this, cellOrdinal, value, formattedValue, propertyValues));
        }
    }

    private Object getTypedValue(Element cell) throws OlapException {
        Element elm = XmlaOlap4jUtil.findChild(cell, "urn:schemas-microsoft-com:xml-analysis:mddataset", VALUE_TAG);
        if (elm == null) {
            return null;
        }
        String type = elm.getAttribute("xsi:type");
        XsdTypes xsdType = XsdTypes.fromString(elm.getAttribute("xsi:type"));
        try {
            switch (xsdType) {
                case XSD_BOOLEAN: {
                    return XmlaOlap4jUtil.booleanElement(cell, VALUE_TAG);
                }
                case XSD_INT: {
                    return XmlaOlap4jUtil.intElement(cell, VALUE_TAG);
                }
                case XSD_INTEGER: {
                    return XmlaOlap4jUtil.bigIntegerElement(cell, VALUE_TAG);
                }
                case XSD_DOUBLE: {
                    return XmlaOlap4jUtil.doubleElement(cell, VALUE_TAG);
                }
                case XSD_POSITIVEINTEGER: {
                    return XmlaOlap4jUtil.bigIntegerElement(cell, VALUE_TAG);
                }
                case XSD_DECIMAL: {
                    return XmlaOlap4jUtil.bigDecimalElement(cell, VALUE_TAG);
                }
                case XSD_SHORT: {
                    return XmlaOlap4jUtil.shortElement(cell, VALUE_TAG);
                }
                case XSD_FLOAT: {
                    return XmlaOlap4jUtil.floatElement(cell, VALUE_TAG);
                }
                case XSD_LONG: {
                    return XmlaOlap4jUtil.longElement(cell, VALUE_TAG);
                }
                case XSD_BYTE: {
                    return XmlaOlap4jUtil.byteElement(cell, VALUE_TAG);
                }
                case XSD_UNSIGNEDBYTE: {
                    return XmlaOlap4jUtil.shortElement(cell, VALUE_TAG);
                }
                case XSD_UNSIGNEDSHORT: {
                    return XmlaOlap4jUtil.intElement(cell, VALUE_TAG);
                }
                case XSD_UNSIGNEDLONG: {
                    return XmlaOlap4jUtil.bigDecimalElement(cell, VALUE_TAG);
                }
                case XSD_UNSIGNEDINT: {
                    return XmlaOlap4jUtil.longElement(cell, VALUE_TAG);
                }
            }
            return XmlaOlap4jUtil.stringElement(cell, VALUE_TAG);
        }
        catch (Exception e) {
            throw this.getHelper().createException("Error while casting a cell value to the correct java type for its XSD type " + type, e);
        }
    }

    private XmlaOlap4jCellSetMetaData createMetaData(Element root) throws OlapException {
        Element olapInfo = XmlaOlap4jUtil.findChild(root, "urn:schemas-microsoft-com:xml-analysis:mddataset", "OlapInfo");
        Element cubeInfo = XmlaOlap4jUtil.findChild(olapInfo, "urn:schemas-microsoft-com:xml-analysis:mddataset", "CubeInfo");
        Element cubeNode = XmlaOlap4jUtil.findChild(cubeInfo, "urn:schemas-microsoft-com:xml-analysis:mddataset", "Cube");
        Element cubeNameNode = XmlaOlap4jUtil.findChild(cubeNode, "urn:schemas-microsoft-com:xml-analysis:mddataset", "CubeName");
        String cubeName = XmlaOlap4jUtil.gatherText(cubeNameNode);
        XmlaOlap4jCube cube = this.lookupCube(this.olap4jStatement.olap4jConnection.olap4jDatabaseMetaData, cubeName);
        if (cube == null) {
            throw this.getHelper().createException("Internal error: cube '" + cubeName + "' not found");
        }
        Element axesInfo = XmlaOlap4jUtil.findChild(olapInfo, "urn:schemas-microsoft-com:xml-analysis:mddataset", "AxesInfo");
        List<Element> axisInfos = XmlaOlap4jUtil.findChildren(axesInfo, "urn:schemas-microsoft-com:xml-analysis:mddataset", "AxisInfo");
        ArrayList<CellSetAxisMetaData> axisMetaDataList = new ArrayList<CellSetAxisMetaData>();
        XmlaOlap4jCellSetAxisMetaData filterAxisMetaData = null;
        for (Element axisInfo : axisInfos) {
            String axisName = axisInfo.getAttribute("name");
            Axis axis = this.lookupAxis(axisName);
            List<Element> hierarchyInfos = XmlaOlap4jUtil.findChildren(axisInfo, "urn:schemas-microsoft-com:xml-analysis:mddataset", "HierarchyInfo");
            ArrayList<Hierarchy> hierarchyList = new ArrayList<Hierarchy>();
            ArrayList<XmlaOlap4jCellSetMemberProperty> propertyList = new ArrayList<XmlaOlap4jCellSetMemberProperty>();
            for (Element hierarchyInfo : hierarchyInfos) {
                String hierarchyName = hierarchyInfo.getAttribute("name");
                Hierarchy hierarchy = this.lookupHierarchy(cube, hierarchyName);
                hierarchyList.add(hierarchy);
                for (Element childNode : XmlaOlap4jUtil.childElements(hierarchyInfo)) {
                    String tag = childNode.getLocalName();
                    if (standardProperties.contains(tag)) continue;
                    String propertyUniqueName = childNode.getAttribute("name");
                    XmlaOlap4jCellSetMemberProperty property = new XmlaOlap4jCellSetMemberProperty(propertyUniqueName, hierarchy, tag);
                    propertyList.add(property);
                }
            }
            XmlaOlap4jCellSetAxisMetaData axisMetaData = new XmlaOlap4jCellSetAxisMetaData(this.olap4jStatement.olap4jConnection, axis, hierarchyList, propertyList);
            if (axis.isFilter()) {
                filterAxisMetaData = axisMetaData;
                continue;
            }
            axisMetaDataList.add(axisMetaData);
        }
        if (filterAxisMetaData == null) {
            filterAxisMetaData = new XmlaOlap4jCellSetAxisMetaData(this.olap4jStatement.olap4jConnection, (Axis)Axis.FILTER, Collections.<Hierarchy>emptyList(), Collections.<XmlaOlap4jCellSetMemberProperty>emptyList());
        }
        Element cellInfo = XmlaOlap4jUtil.findChild(olapInfo, "urn:schemas-microsoft-com:xml-analysis:mddataset", "CellInfo");
        ArrayList<XmlaOlap4jCellProperty> cellProperties = new ArrayList<XmlaOlap4jCellProperty>();
        for (Element element : XmlaOlap4jUtil.childElements(cellInfo)) {
            cellProperties.add(new XmlaOlap4jCellProperty(element.getLocalName(), element.getAttribute("name")));
        }
        return new XmlaOlap4jCellSetMetaData(this.olap4jStatement, cube, filterAxisMetaData, axisMetaDataList, cellProperties);
    }

    private XmlaOlap4jCube lookupCube(XmlaOlap4jDatabaseMetaData databaseMetaData, String cubeName) throws OlapException {
        for (Cube cube : databaseMetaData.olap4jConnection.getOlapSchema().getCubes()) {
            if (cubeName.equals(cube.getName())) {
                return (XmlaOlap4jCube)cube;
            }
            if (!cubeName.equals("[" + cube.getName() + "]")) continue;
            return (XmlaOlap4jCube)cube;
        }
        return null;
    }

    private Hierarchy lookupHierarchy(XmlaOlap4jCube cube, String hierarchyName) throws OlapException {
        Hierarchy hierarchy = (Hierarchy)cube.getHierarchies().get(hierarchyName);
        if (hierarchy == null) {
            for (Hierarchy hierarchy1 : cube.getHierarchies()) {
                if (!hierarchy1.getUniqueName().equals(hierarchyName)) continue;
                hierarchy = hierarchy1;
                break;
            }
            if (hierarchy == null) {
                throw this.getHelper().createException("Internal error: hierarchy '" + hierarchyName + "' not found in cube '" + cube.getName() + "'");
            }
        }
        return hierarchy;
    }

    private Axis lookupAxis(String axisName) {
        if (axisName.startsWith("Axis")) {
            Integer ordinal = Integer.valueOf(axisName.substring("Axis".length()));
            return Axis.Factory.forOrdinal((int)ordinal);
        }
        return Axis.FILTER;
    }

    public CellSetMetaData getMetaData() {
        return this.metaData;
    }

    public Cell getCell(List<Integer> coordinates) {
        return this.getCellInternal(this.coordinatesToOrdinal(coordinates));
    }

    public Cell getCell(int ordinal) {
        return this.getCellInternal(ordinal);
    }

    public Cell getCell(Position ... positions) {
        if (positions.length != this.getAxes().size()) {
            throw new IllegalArgumentException("cell coordinates should have dimension " + this.getAxes().size());
        }
        ArrayList<Integer> coords = new ArrayList<Integer>(positions.length);
        for (Position position : positions) {
            coords.add(position.getOrdinal());
        }
        return this.getCell(coords);
    }

    private Cell getCellInternal(int pos) {
        Cell cell = this.cellMap.get(pos);
        if (cell == null) {
            if (pos < 0 || pos >= this.maxOrdinal()) {
                throw new IndexOutOfBoundsException();
            }
            return new XmlaOlap4jCell(this, pos, null, "", Collections.<Property, Object>emptyMap());
        }
        return cell;
    }

    private String getBoundsAsString() {
        StringBuilder buf = new StringBuilder();
        int k = 0;
        for (CellSetAxis axis : this.getAxes()) {
            if (k++ > 0) {
                buf.append(", ");
            }
            buf.append(axis.getPositionCount());
        }
        return buf.toString();
    }

    public List<CellSetAxis> getAxes() {
        return this.immutableAxisList;
    }

    public CellSetAxis getFilterAxis() {
        return this.filterAxis;
    }

    private int maxOrdinal() {
        int modulo = 1;
        for (CellSetAxis cellSetAxis : this.axisList) {
            modulo *= cellSetAxis.getPositionCount();
        }
        return modulo;
    }

    public List<Integer> ordinalToCoordinates(int ordinal) {
        List<CellSetAxis> axes = this.getAxes();
        ArrayList<Integer> list = new ArrayList<Integer>(axes.size());
        int modulo = 1;
        for (CellSetAxis axis : axes) {
            int prevModulo = modulo;
            list.add(ordinal % (modulo *= axis.getPositionCount()) / prevModulo);
        }
        if (ordinal < 0 || ordinal >= modulo) {
            throw new IndexOutOfBoundsException("Cell ordinal " + ordinal + ") lies outside CellSet bounds (" + this.getBoundsAsString() + ")");
        }
        return list;
    }

    public int coordinatesToOrdinal(List<Integer> coordinates) {
        List<CellSetAxis> axes = this.getAxes();
        if (coordinates.size() != axes.size()) {
            throw new IllegalArgumentException("Coordinates have different dimension " + coordinates.size() + " than axes " + axes.size());
        }
        int modulo = 1;
        int ordinal = 0;
        int k = 0;
        for (CellSetAxis axis : axes) {
            Integer coordinate;
            if ((coordinate = coordinates.get(k++)) < 0 || coordinate >= axis.getPositionCount()) {
                throw new IndexOutOfBoundsException("Coordinate " + coordinate + " of axis " + (k - 1) + " is out of range (" + this.getBoundsAsString() + ")");
            }
            ordinal += coordinate * modulo;
            modulo *= axis.getPositionCount();
        }
        return ordinal;
    }

    public boolean next() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void close() throws SQLException {
        this.closed = true;
    }

    public boolean wasNull() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getString(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public byte getByte(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public short getShort(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getInt(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public long getLong(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public float getFloat(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public double getDouble(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getString(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public byte getByte(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public short getShort(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getInt(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public long getLong(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public float getFloat(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public double getDouble(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public byte[] getBytes(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int findColumn(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isBeforeFirst() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isAfterLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isFirst() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void beforeFirst() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void afterLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean first() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean last() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean absolute(int row) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean relative(int rows) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean previous() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setFetchDirection(int direction) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setFetchSize(int rows) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getType() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getConcurrency() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateNull(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateNull(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateString(String columnLabel, String x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public OlapStatement getStatement() {
        return this.olap4jStatement;
    }

    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Ref getRef(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Clob getClob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Array getArray(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Ref getRef(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Blob getBlob(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Clob getClob(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Array getArray(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public URL getURL(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public URL getURL(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XmlaOlap4jSurpriseMember
    implements XmlaOlap4jMemberBase {
        private final XmlaOlap4jCellSet cellSet;
        private final Level level;
        private final Hierarchy hierarchy;
        private final int lnum;
        private final String caption;
        private final String uname;
        private Member parentMember;
        private final String parentMemberUniqueName;

        XmlaOlap4jSurpriseMember(XmlaOlap4jCellSet cellSet, Level level, Hierarchy hierarchy, int lnum, String caption, String uname) {
            this.cellSet = cellSet;
            this.level = level;
            this.hierarchy = hierarchy;
            this.lnum = lnum;
            this.caption = caption;
            this.uname = uname;
            this.parentMemberUniqueName = this.getParentUniqueName();
        }

        private String getParentUniqueName() {
            List segments = IdentifierNode.parseIdentifier((String)this.getUniqueName()).getSegmentList();
            IdentifierNode parentIdentifier = new IdentifierNode(segments.subList(0, segments.size() - 1));
            return parentIdentifier.toString();
        }

        @Override
        public final XmlaOlap4jCube getCube() {
            return ((XmlaOlap4jCellSet)this.cellSet).metaData.cube;
        }

        @Override
        public final XmlaOlap4jConnection getConnection() {
            return this.getCatalog().olap4jDatabaseMetaData.olap4jConnection;
        }

        @Override
        public final XmlaOlap4jCatalog getCatalog() {
            return this.getCube().olap4jSchema.olap4jCatalog;
        }

        @Override
        public Map<Property, Object> getPropertyValueMap() {
            return Collections.emptyMap();
        }

        public NamedList<? extends Member> getChildMembers() {
            return Olap4jUtil.emptyNamedList();
        }

        public int getChildMemberCount() {
            return 0;
        }

        public Member getParentMember() {
            if (this.getLevel().getDepth() == 0 || this.parentMemberUniqueName == null) {
                return null;
            }
            if (this.parentMember == null) {
                try {
                    this.parentMember = this.getCube().getMetadataReader().lookupMemberByUniqueName(this.parentMemberUniqueName);
                    if (this.parentMember == null && this.getLevel().getDepth() == 1 && this.getHierarchy().hasAll()) {
                        this.parentMember = this.getAllMember();
                    }
                }
                catch (OlapException e) {
                    throw new RuntimeException("Failed to retrieve parent of " + this.getName(), e);
                }
            }
            return this.parentMember;
        }

        private Member getAllMember() throws OlapException {
            if (!this.getHierarchy().hasAll()) {
                return null;
            }
            NamedList roots = this.getHierarchy().getRootMembers();
            assert (roots.size() == 1);
            return (Member)roots.get(0);
        }

        public Level getLevel() {
            return this.level;
        }

        public Hierarchy getHierarchy() {
            return this.hierarchy;
        }

        public Dimension getDimension() {
            return this.hierarchy.getDimension();
        }

        public Member.Type getMemberType() {
            return Member.Type.UNKNOWN;
        }

        public boolean isAll() {
            return false;
        }

        public boolean isChildOrEqualTo(Member member) {
            return false;
        }

        public boolean isCalculated() {
            return false;
        }

        public int getSolveOrder() {
            return 0;
        }

        public ParseTreeNode getExpression() {
            return null;
        }

        public List<Member> getAncestorMembers() {
            return Collections.emptyList();
        }

        public boolean isCalculatedInQuery() {
            return true;
        }

        public Object getPropertyValue(Property property) {
            return null;
        }

        public String getPropertyFormattedValue(Property property) {
            return null;
        }

        public void setProperty(Property property, Object value) {
            throw new UnsupportedOperationException();
        }

        public NamedList<Property> getProperties() {
            return Olap4jUtil.emptyNamedList();
        }

        public int getOrdinal() {
            return -1;
        }

        public boolean isHidden() {
            return false;
        }

        public int getDepth() {
            return this.lnum;
        }

        public Member getDataMember() {
            return null;
        }

        public String getName() {
            return this.caption;
        }

        public String getUniqueName() {
            return this.uname;
        }

        public String getCaption() {
            return this.caption;
        }

        public String getDescription() {
            return null;
        }

        public boolean isVisible() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum XsdTypes {
        XSD_INT("xsd:int"),
        XSD_INTEGER("xsd:integer"),
        XSD_DOUBLE("xsd:double"),
        XSD_POSITIVEINTEGER("xsd:positiveInteger"),
        XSD_DECIMAL("xsd:decimal"),
        XSD_SHORT("xsd:short"),
        XSD_FLOAT("xsd:float"),
        XSD_LONG("xsd:long"),
        XSD_BOOLEAN("xsd:boolean"),
        XSD_BYTE("xsd:byte"),
        XSD_UNSIGNEDBYTE("xsd:unsignedByte"),
        XSD_UNSIGNEDSHORT("xsd:unsignedShort"),
        XSD_UNSIGNEDLONG("xsd:unsignedLong"),
        XSD_UNSIGNEDINT("xsd:unsignedInt"),
        XSD_STRING("xsd:string");

        private final String name;
        private static final Map<String, XsdTypes> TYPES;

        private XsdTypes(String name) {
            this.name = name;
        }

        public static XsdTypes fromString(String name) {
            XsdTypes type = TYPES.get(name);
            return type == null ? XSD_STRING : type;
        }

        static {
            HashMap<String, XsdTypes> typesInitial = new HashMap<String, XsdTypes>();
            for (XsdTypes type : XsdTypes.values()) {
                typesInitial.put(type.name, type);
            }
            TYPES = Collections.unmodifiableMap(typesInitial);
        }
    }
}

