/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import mondrian.mdx.MemberExpr;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Literal;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapNativeSet;
import mondrian.rolap.RolapNativeSql;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.CrossJoinArg;
import mondrian.rolap.sql.SqlQuery;

public class RolapNativeTopCount
extends RolapNativeSet {
    public RolapNativeTopCount() {
        super.setEnabled(MondrianProperties.instance().EnableNativeTopCount.get());
    }

    @Override
    protected boolean restrictMemberTypes() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    NativeEvaluator createEvaluator(RolapEvaluator evaluator, FunDef fun, Exp[] args) {
        boolean ascending;
        if (!this.isEnabled()) {
            return null;
        }
        if (!TopCountConstraint.isValidContext(evaluator, this.restrictMemberTypes())) {
            return null;
        }
        String funName = fun.getName();
        if ("TopCount".equalsIgnoreCase(funName)) {
            ascending = false;
        } else if ("BottomCount".equalsIgnoreCase(funName)) {
            ascending = true;
        } else {
            return null;
        }
        if (args.length < 2 || args.length > 3) {
            return null;
        }
        List<CrossJoinArg[]> allArgs = this.crossJoinArgFactory().checkCrossJoinArg(evaluator, args[0]);
        if (allArgs == null || allArgs.isEmpty() || allArgs.get(0) == null) {
            return null;
        }
        CrossJoinArg[] cjArgs = allArgs.get(0);
        if (this.isPreferInterpreter(cjArgs, false)) {
            return null;
        }
        if (!(args[1] instanceof Literal)) {
            return null;
        }
        int count = ((Literal)args[1]).getIntValue();
        SchemaReader schemaReader = evaluator.getSchemaReader();
        DataSource ds = schemaReader.getDataSource();
        SqlQuery sqlQuery = SqlQuery.newQuery(ds, "NativeTopCount");
        RolapNativeSql sql = new RolapNativeSql(sqlQuery, null, evaluator, null);
        Exp orderByExpr = null;
        if (args.length == 3) {
            orderByExpr = args[2];
            String orderBySQL = sql.generateTopCountOrderBy(args[2]);
            if (orderBySQL == null) {
                return null;
            }
        }
        LOGGER.debug((Object)"using native topcount");
        int savepoint = evaluator.savepoint();
        try {
            this.overrideContext(evaluator, cjArgs, sql.getStoredMeasure());
            CrossJoinArg[] predicateArgs = null;
            if (allArgs.size() == 2) {
                predicateArgs = allArgs.get(1);
            }
            CrossJoinArg[] combinedArgs = predicateArgs != null ? Util.appendArrays(cjArgs, new CrossJoinArg[][]{predicateArgs}) : cjArgs;
            TopCountConstraint constraint = new TopCountConstraint(count, combinedArgs, evaluator, orderByExpr, ascending);
            RolapNativeSet.SetEvaluator sev = new RolapNativeSet.SetEvaluator(this, cjArgs, schemaReader, constraint);
            sev.setMaxRows(count);
            RolapNativeSet.SetEvaluator setEvaluator = sev;
            return setEvaluator;
        }
        finally {
            evaluator.restore(savepoint);
        }
    }

    static class TopCountConstraint
    extends RolapNativeSet.SetConstraint {
        Exp orderByExpr;
        boolean ascending;
        Integer topCount;

        public TopCountConstraint(int count, CrossJoinArg[] args, RolapEvaluator evaluator, Exp orderByExpr, boolean ascending) {
            super(args, evaluator, true);
            this.orderByExpr = orderByExpr;
            this.ascending = ascending;
            this.topCount = new Integer(count);
        }

        @Override
        protected boolean isJoinRequired() {
            return true;
        }

        @Override
        public void addConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar) {
            if (this.orderByExpr != null) {
                RolapNativeSql sql = new RolapNativeSql(sqlQuery, aggStar, this.getEvaluator(), null);
                String orderBySql = sql.generateTopCountOrderBy(this.orderByExpr);
                boolean nullable = this.deduceNullability(this.orderByExpr);
                String orderByAlias = sqlQuery.addSelect(orderBySql, null);
                sqlQuery.addOrderBy(orderBySql, orderByAlias, this.ascending, true, nullable, true);
            }
            super.addConstraint(sqlQuery, baseCube, aggStar);
        }

        private boolean deduceNullability(Exp expr) {
            if (!(expr instanceof MemberExpr)) {
                return true;
            }
            MemberExpr memberExpr = (MemberExpr)expr;
            if (!(memberExpr.getMember() instanceof RolapStoredMeasure)) {
                return true;
            }
            RolapStoredMeasure measure = (RolapStoredMeasure)memberExpr.getMember();
            return measure.getAggregator() != RolapAggregator.DistinctCount;
        }

        @Override
        public Object getCacheKey() {
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(super.getCacheKey());
            if (this.orderByExpr != null) {
                key.add(this.orderByExpr.toString());
            }
            key.add(this.ascending);
            key.add(this.topCount);
            if (this.getEvaluator() instanceof RolapEvaluator) {
                key.add(((RolapEvaluator)this.getEvaluator()).getSlicerMembers());
            }
            return key;
        }
    }
}

