/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr.delegates;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleDependencyException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleObjectExistsException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryBaseDelegate;

public class KettleDatabaseRepositoryPartitionSchemaDelegate
extends KettleDatabaseRepositoryBaseDelegate {
    public KettleDatabaseRepositoryPartitionSchemaDelegate(KettleDatabaseRepository repository) {
        super(repository);
    }

    public RowMetaAndData getPartitionSchema(ObjectId id_partition_schema) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_PARTITION_SCHEMA"), this.quote("ID_PARTITION_SCHEMA"), id_partition_schema);
    }

    public RowMetaAndData getPartition(ObjectId id_partition) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_PARTITION"), this.quote("ID_PARTITION"), id_partition);
    }

    public synchronized ObjectId getPartitionSchemaID(String name) throws KettleException {
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_PARTITION_SCHEMA"), this.quote("ID_PARTITION_SCHEMA"), this.quote("NAME"), name);
    }

    public void savePartitionSchema(PartitionSchema partitionSchema) throws KettleException {
        this.savePartitionSchema(partitionSchema, null, false);
    }

    public void savePartitionSchema(PartitionSchema partitionSchema, ObjectId id_transformation, boolean isUsedByTransformation) throws KettleException {
        try {
            this.savePartitionSchema(partitionSchema, id_transformation, isUsedByTransformation, false);
        }
        catch (KettleObjectExistsException e) {
            this.log.logBasic(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void savePartitionSchema(PartitionSchema partitionSchema, ObjectId id_transformation, boolean isUsedByTransformation, boolean overwrite) throws KettleException {
        if (partitionSchema.getObjectId() == null) {
            partitionSchema.setObjectId(this.getPartitionSchemaID(partitionSchema.getName()));
        }
        if (partitionSchema.getObjectId() == null) {
            partitionSchema.setObjectId(this.insertPartitionSchema(partitionSchema));
        } else {
            ObjectId existingPartitionSchemaId = partitionSchema.getObjectId();
            if (existingPartitionSchemaId != null && !partitionSchema.getObjectId().equals(existingPartitionSchemaId)) {
                if (!overwrite) throw new KettleObjectExistsException("Failed to save object to repository. Object [" + partitionSchema.getName() + "] already exists.");
                this.repository.deletePartitionSchema(existingPartitionSchemaId);
                this.updatePartitionSchema(partitionSchema);
                this.repository.delPartitions(partitionSchema.getObjectId());
            } else {
                this.updatePartitionSchema(partitionSchema);
                this.repository.delPartitions(partitionSchema.getObjectId());
            }
        }
        for (int i = 0; i < partitionSchema.getPartitionIDs().size(); ++i) {
            this.insertPartition(partitionSchema.getObjectId(), partitionSchema.getPartitionIDs().get(i));
        }
        if (!isUsedByTransformation) return;
        this.repository.insertTransformationPartitionSchema(id_transformation, partitionSchema.getObjectId());
    }

    public PartitionSchema loadPartitionSchema(ObjectId id_partition_schema) throws KettleException {
        PartitionSchema partitionSchema = new PartitionSchema();
        partitionSchema.setObjectId(id_partition_schema);
        RowMetaAndData row = this.getPartitionSchema(id_partition_schema);
        partitionSchema.setName(row.getString("NAME", null));
        ObjectId[] pids = this.repository.getPartitionIDs(id_partition_schema);
        for (int i = 0; i < pids.length; ++i) {
            partitionSchema.getPartitionIDs().add(this.getPartition(pids[i]).getString("PARTITION_ID", null));
        }
        partitionSchema.setDynamicallyDefined(row.getBoolean("DYNAMIC_DEFINITION", false));
        partitionSchema.setNumberOfPartitionsPerSlave(row.getString("PARTITIONS_PER_SLAVE", null));
        return partitionSchema;
    }

    public synchronized ObjectId insertPartitionSchema(PartitionSchema partitionSchema) throws KettleException {
        if (this.getPartitionSchemaID(partitionSchema.getName()) != null) {
            throw new KettleObjectExistsException("Failed to create object in repository. Object [" + partitionSchema.getName() + "] already exists.");
        }
        ObjectId id = this.repository.connectionDelegate.getNextPartitionSchemaID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMeta("ID_PARTITION_SCHEMA", 5), (Object)id);
        table.addValue((ValueMetaInterface)new ValueMeta("NAME", 2), (Object)partitionSchema.getName());
        table.addValue((ValueMetaInterface)new ValueMeta("DYNAMIC_DEFINITION", 4), (Object)partitionSchema.isDynamicallyDefined());
        table.addValue((ValueMetaInterface)new ValueMeta("PARTITIONS_PER_SLAVE", 2), (Object)partitionSchema.getNumberOfPartitionsPerSlave());
        this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), "R_PARTITION_SCHEMA");
        this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
        this.repository.connectionDelegate.getDatabase().insertRow();
        this.repository.connectionDelegate.getDatabase().closeInsert();
        return id;
    }

    public synchronized void updatePartitionSchema(PartitionSchema partitionSchema) throws KettleException {
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMeta("NAME", 2), (Object)partitionSchema.getName());
        table.addValue((ValueMetaInterface)new ValueMeta("DYNAMIC_DEFINITION", 4), (Object)partitionSchema.isDynamicallyDefined());
        table.addValue((ValueMetaInterface)new ValueMeta("PARTITIONS_PER_SLAVE", 2), (Object)partitionSchema.getNumberOfPartitionsPerSlave());
        this.repository.connectionDelegate.updateTableRow("R_PARTITION_SCHEMA", "ID_PARTITION_SCHEMA", table, partitionSchema.getObjectId());
    }

    public synchronized ObjectId insertPartition(ObjectId id_partition_schema, String partition_id) throws KettleException {
        ObjectId id = this.repository.connectionDelegate.getNextPartitionID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMeta("ID_PARTITION", 5), (Object)id);
        table.addValue((ValueMetaInterface)new ValueMeta("ID_PARTITION_SCHEMA", 5), (Object)id_partition_schema);
        table.addValue((ValueMetaInterface)new ValueMeta("PARTITION_ID", 2), (Object)partition_id);
        this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), "R_PARTITION");
        this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
        this.repository.connectionDelegate.getDatabase().insertRow();
        this.repository.connectionDelegate.getDatabase().closeInsert();
        return id;
    }

    public synchronized void delPartitionSchema(ObjectId id_partition_schema) throws KettleException {
        String[] transList = this.repository.getTransformationsUsingPartitionSchema(id_partition_schema);
        if (transList.length != 0) {
            StringBuffer message = new StringBuffer();
            message.append("The partition schema is used by the following transformations:").append(Const.CR);
            for (int i = 0; i < transList.length; ++i) {
                message.append("  ").append(transList[i]).append(Const.CR);
            }
            message.append(Const.CR);
            KettleDependencyException e = new KettleDependencyException(message.toString());
            throw new KettleDependencyException("This partition schema is still in use by one or more transformations (" + transList.length + ") :", (Throwable)e);
        }
        this.repository.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_PARTITION") + " WHERE " + this.quote("ID_PARTITION_SCHEMA") + " = ? ", id_partition_schema);
        this.repository.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_PARTITION_SCHEMA") + " WHERE " + this.quote("ID_PARTITION_SCHEMA") + " = ? ", id_partition_schema);
    }
}

