/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.pentaho.di.cluster.SlaveConnectionManager;
import org.pentaho.di.core.Const;

public class HTTPProtocol {
    private static final String[] requestHeaders = new String[]{"accept", "accept-charset", "cache-control", "content-type"};

    public static String[] getRequestHeaders() {
        return requestHeaders;
    }

    public String get(String urlAsString, String username, String password) throws MalformedURLException, IOException, AuthenticationException {
        HttpClient httpClient = SlaveConnectionManager.getInstance().createHttpClient();
        GetMethod getMethod = new GetMethod(urlAsString);
        if (!Const.isEmpty((String)username)) {
            httpClient.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(username, password);
            httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
        }
        int statusCode = httpClient.executeMethod((HttpMethod)getMethod);
        StringBuffer bodyBuffer = new StringBuffer();
        if (statusCode != -1) {
            if (statusCode != 401) {
                int c;
                InputStreamReader inputStreamReader = new InputStreamReader(getMethod.getResponseBodyAsStream());
                while ((c = inputStreamReader.read()) != -1) {
                    bodyBuffer.append((char)c);
                }
                inputStreamReader.close();
            } else {
                throw new AuthenticationException();
            }
        }
        return bodyBuffer.toString();
    }
}

