/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.jfor.jfor.interfaces.ITableColumnsInfo;
import org.jfor.jfor.rtflib.rtfdoc.BorderAttributesConverter;
import org.jfor.jfor.rtflib.rtfdoc.IRtfExternalGraphicContainer;
import org.jfor.jfor.rtflib.rtfdoc.IRtfListContainer;
import org.jfor.jfor.rtflib.rtfdoc.IRtfParagraphContainer;
import org.jfor.jfor.rtflib.rtfdoc.IRtfTableContainer;
import org.jfor.jfor.rtflib.rtfdoc.ITableAttributes;
import org.jfor.jfor.rtflib.rtfdoc.RtfAttributes;
import org.jfor.jfor.rtflib.rtfdoc.RtfContainer;
import org.jfor.jfor.rtflib.rtfdoc.RtfElement;
import org.jfor.jfor.rtflib.rtfdoc.RtfExternalGraphic;
import org.jfor.jfor.rtflib.rtfdoc.RtfList;
import org.jfor.jfor.rtflib.rtfdoc.RtfParagraph;
import org.jfor.jfor.rtflib.rtfdoc.RtfTable;
import org.jfor.jfor.rtflib.rtfdoc.RtfTableRow;

public class RtfTableCell
extends RtfContainer
implements IRtfParagraphContainer,
IRtfListContainer,
IRtfTableContainer,
IRtfExternalGraphicContainer {
    private RtfParagraph m_paragraph;
    private RtfList m_list;
    private RtfTable m_table;
    private RtfExternalGraphic m_externalGraphic;
    private final RtfTableRow m_parentRow;
    private boolean set_center;
    private boolean set_right;
    private int id;
    public static final int DEFAULT_CELL_WIDTH = 2000;
    private int m_cellWidth;
    private int m_widthOffset;
    private int m_vMerge = 0;
    private int m_hMerge = 0;
    public static final int NO_MERGE = 0;
    public static final int MERGE_START = 1;
    public static final int MERGE_WITH_PREVIOUS = 2;

    RtfTableCell(RtfTableRow rtfTableRow, Writer writer, int n, int n2) throws IOException {
        super(rtfTableRow, writer);
        this.id = n2;
        this.m_parentRow = rtfTableRow;
        this.m_cellWidth = n;
        this.set_right = false;
        this.set_center = false;
    }

    RtfTableCell(RtfTableRow rtfTableRow, Writer writer, int n, RtfAttributes rtfAttributes, int n2) throws IOException {
        super(rtfTableRow, writer, rtfAttributes);
        this.id = n2;
        this.m_parentRow = rtfTableRow;
        this.m_cellWidth = n;
        if (rtfAttributes.getValue("number-columns-spanned") != null) {
            this.setHMerge(1);
            int n3 = (Integer)rtfAttributes.getValue("number-columns-spanned");
            if (rtfTableRow.m_parent instanceof RtfTable) {
                ITableColumnsInfo iTableColumnsInfo = ((RtfTable)rtfTableRow.m_parent).getITableColumnsInfo();
                iTableColumnsInfo.selectFirstColumn();
                while (this.id - 1 != iTableColumnsInfo.getColumnIndex()) {
                    iTableColumnsInfo.selectNextColumn();
                }
                int n4 = n3 - 1;
                while (n4 > 0) {
                    iTableColumnsInfo.selectNextColumn();
                    rtfTableRow.newTableCellMergedHorizontally((int)iTableColumnsInfo.getColumnWidth(), rtfAttributes);
                    --n4;
                }
            }
        }
    }

    public RtfParagraph newParagraph(RtfAttributes rtfAttributes) throws IOException {
        this.closeAll();
        if (rtfAttributes == null) {
            rtfAttributes = new RtfAttributes();
        }
        rtfAttributes.set("intbl");
        this.m_paragraph = new RtfParagraph(this, this.m_writer, rtfAttributes);
        if (this.m_paragraph.m_attrib.isSet("qc")) {
            this.set_center = true;
            rtfAttributes.set("qc");
        } else if (this.m_paragraph.m_attrib.isSet("qr")) {
            this.set_right = true;
            rtfAttributes.set("qr");
        } else {
            rtfAttributes.set("ql");
        }
        rtfAttributes.set("intbl");
        return this.m_paragraph;
    }

    public RtfExternalGraphic newImage() throws IOException {
        this.closeAll();
        this.m_externalGraphic = new RtfExternalGraphic(this, this.m_writer);
        return this.m_externalGraphic;
    }

    public RtfParagraph newParagraph() throws IOException {
        return this.newParagraph(null);
    }

    public RtfList newList(RtfAttributes rtfAttributes) throws IOException {
        this.closeAll();
        this.m_list = new RtfList(this, this.m_writer, rtfAttributes);
        return this.m_list;
    }

    public RtfTable newTable(ITableColumnsInfo iTableColumnsInfo) throws IOException {
        this.closeAll();
        this.m_table = new RtfTable(this, this.m_writer, iTableColumnsInfo);
        return this.m_table;
    }

    public RtfTable newTable(RtfAttributes rtfAttributes, ITableColumnsInfo iTableColumnsInfo) throws IOException {
        this.closeAll();
        this.m_table = new RtfTable(this, this.m_writer, rtfAttributes, iTableColumnsInfo);
        return this.m_table;
    }

    int writeCellDef(int n) throws IOException {
        this.m_widthOffset = n;
        if (this.m_vMerge == 1) {
            this.writeControlWord("clvmgf");
        } else if (this.m_vMerge == 2) {
            this.writeControlWord("clvmrg");
        }
        if (this.m_hMerge == 1) {
            this.writeControlWord("clmgf");
        } else if (this.m_hMerge == 2) {
            this.writeControlWord("clmrg");
        }
        this.writeAttributes(this.m_attrib, ITableAttributes.CELL_COLOR);
        this.writeAttributes(this.m_attrib, ITableAttributes.ATTRIB_CELL_PADDING);
        this.writeAttributes(this.m_attrib, ITableAttributes.CELL_BORDER);
        this.writeAttributes(this.m_attrib, BorderAttributesConverter.BORDERS);
        int n2 = n + this.m_cellWidth;
        if (this.set_center) {
            this.writeControlWord("qc");
        } else if (this.set_right) {
            this.writeControlWord("qr");
        } else {
            this.writeControlWord("ql");
        }
        this.writeControlWord("cellx" + n2);
        this.writeControlWord("ql");
        return n2;
    }

    protected void writeRtfSuffix() throws IOException {
        if (this.set_center) {
            this.writeControlWord("qc");
        } else if (this.set_right) {
            this.writeControlWord("qr");
        } else {
            this.writeControlWord("ql");
        }
        if (!this.containsText()) {
            this.writeControlWord("intbl");
        }
        this.writeControlWord("cell");
    }

    private void closeCurrentParagraph() throws IOException {
        if (this.m_paragraph != null) {
            this.m_paragraph.close();
        }
    }

    private void closeCurrentList() throws IOException {
        if (this.m_list != null) {
            this.m_list.close();
        }
    }

    private void closeCurrentTable() throws IOException {
        if (this.m_table != null) {
            this.m_table.close();
        }
    }

    private void closeCurrentExternalGraphic() throws IOException {
        if (this.m_externalGraphic != null) {
            this.m_externalGraphic.close();
        }
    }

    private void closeAll() throws IOException {
        this.closeCurrentTable();
        this.closeCurrentParagraph();
        this.closeCurrentList();
        this.closeCurrentExternalGraphic();
    }

    public void setVMerge(int n) {
        this.m_vMerge = n;
    }

    public int getVMerge() {
        return this.m_vMerge;
    }

    public void setHMerge(int n) {
        this.m_hMerge = n;
    }

    public int getHMerge() {
        return this.m_hMerge;
    }

    int getCellWidth() {
        return this.m_cellWidth;
    }

    protected void writeRtfContent() throws IOException {
        int n = 0;
        RtfContainer rtfContainer = null;
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            RtfElement rtfElement = (RtfElement)iterator.next();
            if (rtfElement instanceof RtfTable) {
                this.m_parentRow.getExtraRowSet().setParentITableColumnsInfo(((RtfTable)this.getParentOfClass(rtfElement.getClass())).getITableColumnsInfo());
                n = this.m_parentRow.getExtraRowSet().addTable((RtfTable)rtfElement, n, this.m_widthOffset);
                rtfContainer = this.m_parentRow.getExtraRowSet().createExtraCell(n, this.m_widthOffset, this.getCellWidth(), this.m_attrib);
                ++n;
                continue;
            }
            if (rtfContainer != null) {
                rtfContainer.addChild(rtfElement);
                continue;
            }
            rtfElement.writeRtf();
        }
    }

    public boolean isEmpty() {
        return false;
    }

    boolean paragraphNeedsPar(RtfParagraph rtfParagraph) {
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!bl) {
                bl = e == rtfParagraph;
                continue;
            }
            if (e instanceof RtfParagraph) {
                RtfParagraph rtfParagraph2 = (RtfParagraph)e;
                if (rtfParagraph2.isEmpty()) continue;
                bl2 = true;
                break;
            }
            if (e instanceof RtfTable) break;
        }
        return bl2;
    }
}

