/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.rtflib.rtfdoc;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.jfor.jfor.rtflib.rtfdoc.RtfHeader;

public class RtfColorTable {
    private static int RED = 16;
    private static int GREEN = 8;
    private static int BLUE = 0;
    private static RtfColorTable instance = null;
    private Hashtable colorIndex = null;
    private Vector colorTable = new Vector();
    private Hashtable namedColors = null;

    private RtfColorTable() {
        this.colorIndex = new Hashtable();
        this.namedColors = new Hashtable();
        this.init();
    }

    public static RtfColorTable getInstance() {
        if (instance == null) {
            instance = new RtfColorTable();
        }
        return instance;
    }

    private void init() {
        this.addNamedColor("black", this.getColorNumber(0, 0, 0));
        this.addNamedColor("white", this.getColorNumber(255, 255, 255));
        this.addNamedColor("red", this.getColorNumber(255, 0, 0));
        this.addNamedColor("green", this.getColorNumber(0, 255, 0));
        this.addNamedColor("blue", this.getColorNumber(0, 0, 255));
        this.addNamedColor("cyan", this.getColorNumber(0, 255, 255));
        this.addNamedColor("magenta", this.getColorNumber(255, 0, 255));
        this.addNamedColor("yellow", this.getColorNumber(255, 255, 0));
        this.getColorNumber(0, 0, 128);
        this.getColorNumber(0, 128, 128);
        this.getColorNumber(0, 128, 0);
        this.getColorNumber(128, 0, 128);
        this.getColorNumber(128, 0, 0);
        this.getColorNumber(128, 128, 0);
        this.getColorNumber(128, 128, 128);
        this.addNamedColor("gray", this.getColorNumber(128, 128, 128));
        this.getColorNumber(192, 192, 192);
    }

    private void addNamedColor(String string, int n) {
        this.namedColors.put(string.toLowerCase(), new Integer(n));
    }

    public Integer getColorNumber(String string) {
        return (Integer)this.namedColors.get(string.toLowerCase());
    }

    public int getColorNumber(int n, int n2, int n3) {
        int n4;
        Integer n5 = new Integer(this.determineIdentifier(n, n2, n3));
        Object v = this.colorIndex.get(n5);
        if (v == null) {
            this.addColor(n5);
            n4 = this.colorTable.size();
        } else {
            n4 = (Integer)v;
        }
        return n4 + 1;
    }

    public void writeColors(RtfHeader rtfHeader) throws IOException {
        if (this.colorTable == null || this.colorTable.size() == 0) {
            return;
        }
        rtfHeader.writeGroupMark(true);
        rtfHeader.writeControlWord("colortbl;");
        int n = this.colorTable.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = (Integer)this.colorTable.get(n2);
            rtfHeader.write("\\red" + this.determineColorLevel(n3, RED));
            rtfHeader.write("\\green" + this.determineColorLevel(n3, GREEN));
            rtfHeader.write("\\blue" + this.determineColorLevel(n3, BLUE) + ";");
            ++n2;
        }
        rtfHeader.writeGroupMark(false);
    }

    private void addColor(Integer n) {
        this.colorIndex.put(n, new Integer(this.colorTable.size() + 1));
        this.colorTable.addElement(n);
    }

    private int determineIdentifier(int n, int n2, int n3) {
        int n4 = n << RED;
        n4 += n2 << GREEN;
        return n4 += n3 << BLUE;
    }

    private int determineColorLevel(int n, int n2) {
        int n3 = n >> n2;
        return n3 < 0 ? n3 + 256 : n3;
    }
}

