/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.PrintPart;
import net.sf.jasperreports.engine.PrintParts;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.ReadOnlyPartJasperPrint;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInputItem;

public class PrintPartUnrollExporterInput
implements ExporterInput {
    private List<ExporterInputItem> partItems = new ArrayList<ExporterInputItem>();

    public PrintPartUnrollExporterInput(ExporterInput exporterInput) {
        for (ExporterInputItem item : exporterInput.getItems()) {
            JasperPrint jasperPrint = item.getJasperPrint();
            ReportExportConfiguration configuration = item.getConfiguration();
            if (jasperPrint.hasParts()) {
                PrintParts parts = jasperPrint.getParts();
                Iterator<Map.Entry<Integer, PrintPart>> it = parts.partsIterator();
                int startPageIndex = 0;
                Integer partPageIndex = null;
                PrintPart part = null;
                while (it.hasNext()) {
                    Map.Entry<Integer, PrintPart> entry = it.next();
                    partPageIndex = entry.getKey();
                    this.partItems.add(new SimpleExporterInputItem(new ReadOnlyPartJasperPrint(jasperPrint, part, startPageIndex, partPageIndex), configuration));
                    part = entry.getValue();
                    startPageIndex = partPageIndex;
                }
                this.partItems.add(new SimpleExporterInputItem(new ReadOnlyPartJasperPrint(jasperPrint, part, startPageIndex, jasperPrint.getPages().size()), configuration));
                continue;
            }
            this.partItems.add(item);
        }
    }

    @Override
    public List<ExporterInputItem> getItems() {
        return this.partItems;
    }
}

