/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.virtualization;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.base.VirtualElementsData;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.fill.JRRecordedValues;
import net.sf.jasperreports.engine.fill.JRRecordedValuesGenericPrintElement;
import net.sf.jasperreports.engine.fill.JRRecordedValuesPrintImage;
import net.sf.jasperreports.engine.fill.JRRecordedValuesPrintText;
import net.sf.jasperreports.engine.fill.JRTemplateGenericPrintElement;
import net.sf.jasperreports.engine.fill.JRTemplatePrintElement;
import net.sf.jasperreports.engine.fill.JRTemplatePrintEllipse;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import net.sf.jasperreports.engine.fill.JRTemplatePrintGraphicElement;
import net.sf.jasperreports.engine.fill.JRTemplatePrintImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintLine;
import net.sf.jasperreports.engine.fill.JRTemplatePrintRectangle;
import net.sf.jasperreports.engine.fill.JRTemplatePrintText;
import net.sf.jasperreports.engine.virtualization.BigDecimalSerializer;
import net.sf.jasperreports.engine.virtualization.BigIntegerSerializer;
import net.sf.jasperreports.engine.virtualization.BooleanSerializer;
import net.sf.jasperreports.engine.virtualization.ByteSerializer;
import net.sf.jasperreports.engine.virtualization.DateSerializer;
import net.sf.jasperreports.engine.virtualization.DoubleSerializer;
import net.sf.jasperreports.engine.virtualization.EvaluationTimeSerializer;
import net.sf.jasperreports.engine.virtualization.FloatSerializer;
import net.sf.jasperreports.engine.virtualization.IntegerSerializer;
import net.sf.jasperreports.engine.virtualization.LongSerializer;
import net.sf.jasperreports.engine.virtualization.ObjectSerializer;
import net.sf.jasperreports.engine.virtualization.RecordedValuesSerializer;
import net.sf.jasperreports.engine.virtualization.SerializableSerializer;
import net.sf.jasperreports.engine.virtualization.SerializerRegistry;
import net.sf.jasperreports.engine.virtualization.ShortSerializer;
import net.sf.jasperreports.engine.virtualization.SqlDateSerializer;
import net.sf.jasperreports.engine.virtualization.StringSerializer;
import net.sf.jasperreports.engine.virtualization.TimeSerializer;
import net.sf.jasperreports.engine.virtualization.TimestampSerializer;
import net.sf.jasperreports.engine.virtualization.UUIDSerializer;
import net.sf.jasperreports.engine.virtualization.VirtualizationSerializable;

public class DefaultSerializerRegistry
implements SerializerRegistry {
    private static final DefaultSerializerRegistry INSTANCE = new DefaultSerializerRegistry();
    private Map<Class<?>, ObjectSerializer<?>> classSerializers = new HashMap();
    private Map<Integer, ObjectSerializer<?>> typeSerializers = new HashMap();

    public static SerializerRegistry getInstance() {
        return INSTANCE;
    }

    public DefaultSerializerRegistry() {
        this.addSerializer(String.class, new StringSerializer());
        this.addSerializer(UUID.class, new UUIDSerializer());
        this.addSerializer(Byte.class, new ByteSerializer());
        this.addSerializer(Short.class, new ShortSerializer());
        this.addSerializer(Integer.class, new IntegerSerializer());
        this.addSerializer(Long.class, new LongSerializer());
        this.addSerializer(Boolean.class, new BooleanSerializer());
        this.addSerializer(Float.class, new FloatSerializer());
        this.addSerializer(Double.class, new DoubleSerializer());
        this.addSerializer(BigInteger.class, new BigIntegerSerializer());
        this.addSerializer(BigDecimal.class, new BigDecimalSerializer(new BigIntegerSerializer()));
        this.addSerializer(java.util.Date.class, new DateSerializer());
        this.addSerializer(Date.class, new SqlDateSerializer());
        this.addSerializer(Time.class, new TimeSerializer());
        this.addSerializer(Timestamp.class, new TimestampSerializer());
        this.addSerializableType(VirtualElementsData.class, 48);
        this.addSerializableType(JRTemplatePrintElement.class, 49);
        this.addSerializableType(JRTemplatePrintFrame.class, 50);
        this.addSerializableType(JRTemplatePrintText.class, 51);
        this.addSerializableType(JRRecordedValuesPrintText.class, 52);
        this.addSerializableType(JRTemplatePrintGraphicElement.class, 60);
        this.addSerializableType(JRTemplatePrintImage.class, 53);
        this.addSerializableType(JRRecordedValuesPrintImage.class, 54);
        this.addSerializableType(JRTemplatePrintLine.class, 55);
        this.addSerializableType(JRTemplatePrintRectangle.class, 56);
        this.addSerializableType(JRTemplatePrintEllipse.class, 57);
        this.addSerializableType(JRTemplateGenericPrintElement.class, 58);
        this.addSerializableType(JRRecordedValuesGenericPrintElement.class, 59);
        this.addSerializableType(JRPrintHyperlinkParameters.class, 60);
        this.addSerializableType(JRPrintHyperlinkParameter.class, 61);
        this.addSerializer(JREvaluationTime.class, new EvaluationTimeSerializer());
        this.addSerializer(JRRecordedValues.class, new RecordedValuesSerializer());
    }

    private <T> void addSerializer(Class<T> type, ObjectSerializer<T> serializer) {
        this.classSerializers.put(type, serializer);
        this.typeSerializers.put(serializer.typeValue(), serializer);
    }

    private <T extends VirtualizationSerializable> void addSerializableType(Class<T> type, int typeValue) {
        this.addSerializer(type, new SerializableSerializer<T>(typeValue, type));
    }

    @Override
    public <T> ObjectSerializer<T> getSerializer(Class<T> objectClass) {
        return this.classSerializers.get(objectClass);
    }

    @Override
    public ObjectSerializer<?> getSerializer(int typeValue) {
        return this.typeSerializers.get(typeValue);
    }
}

