/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.functions.standard;

import java.text.DateFormat;
import java.text.ParseException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.zone.ZoneRules;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import net.sf.jasperreports.functions.AbstractFunctionSupport;
import net.sf.jasperreports.functions.annotations.Function;
import net.sf.jasperreports.functions.annotations.FunctionCategories;
import net.sf.jasperreports.functions.annotations.FunctionParameter;
import net.sf.jasperreports.functions.annotations.FunctionParameters;
import net.sf.jasperreports.functions.standard.DateTimeCategory;
import net.sf.jasperreports.types.date.DateRange;
import net.sf.jasperreports.types.date.DateRangeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@FunctionCategories(value={DateTimeCategory.class})
public final class DateTimeFunctions
extends AbstractFunctionSupport {
    private static final Log log = LogFactory.getLog(DateTimeFunctions.class);

    @Function(value="TODAY")
    public Date TODAY() {
        return Calendar.getInstance(this.getReportTimeZone(), this.getReportLocale()).getTime();
    }

    @Function(value="NOW")
    public Date NOW() {
        return this.TODAY();
    }

    @Function(value="YEAR")
    @FunctionParameters(value={@FunctionParameter(value="dateObject")})
    public Integer YEAR(Object dateObject) {
        return this.getCalendarFieldFromDate(dateObject, 1);
    }

    @Function(value="MONTH")
    @FunctionParameters(value={@FunctionParameter(value="dateObject")})
    public Integer MONTH(Object dateObject) {
        return this.getCalendarFieldFromDate(dateObject, 2) + 1;
    }

    @Function(value="DAY")
    @FunctionParameters(value={@FunctionParameter(value="dateObject")})
    public Integer DAY(Object dateObject) {
        return this.getCalendarFieldFromDate(dateObject, 5);
    }

    @Function(value="WEEKDAY")
    @FunctionParameters(value={@FunctionParameter(value="dateObject"), @FunctionParameter(value="isSundayFirstDay")})
    public Integer WEEKDAY(Object dateObject) {
        return this.WEEKDAY(dateObject, false);
    }

    public Integer WEEKDAY(Object dateObject, Boolean isSundayFirstDay) {
        Integer dayOfWeek = this.getCalendarFieldFromDate(dateObject, 7);
        if (dayOfWeek == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to get the correct day of the week.");
            }
            return null;
        }
        if (isSundayFirstDay.booleanValue()) {
            return dayOfWeek;
        }
        if (dayOfWeek == 1) {
            return 7;
        }
        return dayOfWeek - 1;
    }

    @Function(value="HOUR")
    @FunctionParameters(value={@FunctionParameter(value="dateObject")})
    public Integer HOUR(Object dateObject) {
        return this.getCalendarFieldFromDate(dateObject, 11);
    }

    @Function(value="MINUTE")
    @FunctionParameters(value={@FunctionParameter(value="dateObject")})
    public Integer MINUTE(Object dateObject) {
        return this.getCalendarFieldFromDate(dateObject, 12);
    }

    @Function(value="SECOND")
    @FunctionParameters(value={@FunctionParameter(value="dateObject")})
    public Integer SECOND(Object dateObject) {
        return this.getCalendarFieldFromDate(dateObject, 13);
    }

    @Function(value="DATE")
    @FunctionParameters(value={@FunctionParameter(value="year"), @FunctionParameter(value="month"), @FunctionParameter(value="dayOfMonth")})
    public Date DATE(Integer year, Integer month, Integer dayOfMonth) {
        if (year == null || month == null || dayOfMonth == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"None of the arguments can be null.");
            }
            return null;
        }
        LocalDateTime ldt = LocalDateTime.of((int)year, month, (int)dayOfMonth, 0, 0);
        ZonedDateTime zdt = ZonedDateTime.of(ldt, this.getReportTimeZone().toZoneId());
        return Date.from(zdt.toInstant());
    }

    @Function(value="DATEVALUE")
    @FunctionParameters(value={@FunctionParameter(value="dateObject")})
    public Long DATEVALUE(Object dateObject) {
        Date convertedDate = this.convertDateObject(dateObject);
        if (convertedDate != null) {
            return convertedDate.getTime();
        }
        DateTimeFunctions.logCannotConvertToDate();
        return null;
    }

    @Function(value="TIME")
    @FunctionParameters(value={@FunctionParameter(value="hours"), @FunctionParameter(value="minutes"), @FunctionParameter(value="seconds"), @FunctionParameter(value="timePattern")})
    public String TIME(Integer hours, Integer minutes, Integer seconds) {
        return this.TIME(hours, minutes, seconds, null);
    }

    public String TIME(Integer hours, Integer minutes, Integer seconds, String timePattern) {
        if (hours == null || minutes == null || seconds == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"None of the arguments can be null.");
            }
            return null;
        }
        LocalTime lt = LocalTime.of(hours, minutes, seconds);
        DateTimeFormatter fallbackFormatter = DateTimeFormatter.ofLocalizedTime(FormatStyle.LONG).withLocale(this.getReportLocale()).withZone(this.getReportTimeZone().toZoneId());
        if (timePattern == null) {
            return fallbackFormatter.format(lt);
        }
        try {
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern(timePattern, this.getReportLocale()).withZone(this.getReportTimeZone().toZoneId());
            return dtf.format(lt);
        }
        catch (IllegalArgumentException e) {
            return fallbackFormatter.format(lt);
        }
    }

    @Function(value="EDATE")
    @FunctionParameters(value={@FunctionParameter(value="dateObject"), @FunctionParameter(value="months")})
    public Date EDATE(Object dateObject, Integer months) {
        Date convertedDate = this.convertDateObject(dateObject);
        if (convertedDate == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        Instant instant = Instant.ofEpochMilli(convertedDate.getTime());
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, this.getReportTimeZone().toZoneId());
        ZonedDateTime newZdt = zdt.plusMonths(months.intValue());
        return Date.from(newZdt.toInstant());
    }

    @Function(value="WORKDAY")
    @FunctionParameters(value={@FunctionParameter(value="dateObject"), @FunctionParameter(value="workdays")})
    public Date WORKDAY(Object dateObject, Integer workdays) {
        Date convertedDate = this.convertDateObject(dateObject);
        if (convertedDate == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(convertedDate.getTime()), this.getReportTimeZone().toZoneId());
        boolean lookBack = workdays < 0;
        int remainingDays = Math.abs(workdays);
        while (remainingDays > 0) {
            DayOfWeek dayOfWeek = zdt.getDayOfWeek();
            if (dayOfWeek != DayOfWeek.SATURDAY && dayOfWeek != DayOfWeek.SUNDAY) {
                --remainingDays;
            }
            if (!lookBack) {
                zdt = dayOfWeek == DayOfWeek.FRIDAY ? zdt.plusDays(3L) : zdt.plusDays(1L);
                continue;
            }
            zdt = dayOfWeek == DayOfWeek.MONDAY ? zdt.minusDays(3L) : zdt.minusDays(1L);
        }
        return Date.from(zdt.toInstant());
    }

    @Function(value="NETWORKDAYS")
    @FunctionParameters(value={@FunctionParameter(value="startDate"), @FunctionParameter(value="endDate")})
    public Integer NETWORKDAYS(Object startDate, Object endDate) {
        Date startDateObj = this.convertDateObject(startDate);
        if (startDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        Date endDateObj = this.convertDateObject(endDate);
        if (endDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        ZoneId reportZoneID = this.getReportTimeZone().toZoneId();
        ZonedDateTime zdtCursor = ZonedDateTime.ofInstant(Instant.ofEpochMilli(startDateObj.getTime()), reportZoneID);
        ZonedDateTime zdtEnd = ZonedDateTime.ofInstant(Instant.ofEpochMilli(endDateObj.getTime()), reportZoneID);
        int workingDays = 0;
        if (zdtCursor.isAfter(zdtEnd)) {
            ZonedDateTime tmp = zdtCursor;
            zdtCursor = zdtEnd;
            zdtEnd = tmp;
        }
        LocalDate cursorLocalDate = zdtCursor.toLocalDate();
        LocalDate endLocalDate = zdtEnd.toLocalDate();
        while (ChronoUnit.DAYS.between(cursorLocalDate, endLocalDate) > 0L) {
            DayOfWeek dayOfWeek = cursorLocalDate.getDayOfWeek();
            if (!DateTimeFunctions.isWeekendDay(dayOfWeek)) {
                ++workingDays;
            }
            cursorLocalDate = cursorLocalDate.plusDays(1L);
        }
        return workingDays;
    }

    @Function(value="DAYS")
    @FunctionParameters(value={@FunctionParameter(value="startDate"), @FunctionParameter(value="endDate")})
    public Integer DAYS(Object startDate, Object endDate) {
        Date startDateObj = this.convertDateObject(startDate);
        if (startDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        Date endDateObj = this.convertDateObject(endDate);
        if (endDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        ZoneId reportZoneID = this.getReportTimeZone().toZoneId();
        LocalDate startLocalDate = DateTimeFunctions.ofInstant(Instant.ofEpochMilli(startDateObj.getTime()), reportZoneID);
        LocalDate endLocalDate = DateTimeFunctions.ofInstant(Instant.ofEpochMilli(endDateObj.getTime()), reportZoneID);
        return (int)ChronoUnit.DAYS.between(startLocalDate, endLocalDate);
    }

    @Function(value="DAYSINMONTH")
    @FunctionParameters(value={@FunctionParameter(value="dateObj")})
    public Integer DAYSINMONTH(Object dateObj) {
        Date date = this.convertDateObject(dateObj);
        if (date == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        LocalDate ld = DateTimeFunctions.ofInstant(Instant.ofEpochMilli(date.getTime()), this.getReportTimeZone().toZoneId());
        return YearMonth.from(ld).lengthOfMonth();
    }

    @Function(value="DAYSINYEAR")
    @FunctionParameters(value={@FunctionParameter(value="dateObj")})
    public Integer DAYSINYEAR(Object dateObj) {
        Date date = this.convertDateObject(dateObj);
        if (date == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        LocalDate ld = DateTimeFunctions.ofInstant(Instant.ofEpochMilli(date.getTime()), this.getReportTimeZone().toZoneId());
        return YearMonth.from(ld).lengthOfYear();
    }

    @Function(value="WEEKS")
    @FunctionParameters(value={@FunctionParameter(value="startDate"), @FunctionParameter(value="endDate")})
    public Integer WEEKS(Object startDate, Object endDate) {
        Date startDateObj = this.convertDateObject(startDate);
        if (startDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        Date endDateObj = this.convertDateObject(endDate);
        if (endDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        ZoneId reportZoneID = this.getReportTimeZone().toZoneId();
        LocalDate startLocalDate = DateTimeFunctions.ofInstant(Instant.ofEpochMilli(startDateObj.getTime()), reportZoneID);
        LocalDate endLocalDate = DateTimeFunctions.ofInstant(Instant.ofEpochMilli(endDateObj.getTime()), reportZoneID);
        return (int)ChronoUnit.WEEKS.between(startLocalDate, endLocalDate);
    }

    @Function(value="WEEKSINYEAR")
    @FunctionParameters(value={@FunctionParameter(value="dateObj")})
    public Integer WEEKSINYEAR(Object dateObj) {
        Date date = this.convertDateObject(dateObj);
        if (date == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        LocalDate ld = DateTimeFunctions.ofInstant(Instant.ofEpochMilli(date.getTime()), this.getReportTimeZone().toZoneId());
        LocalDate firstDayOfYear = LocalDate.of(ld.getYear(), 1, 1);
        if (firstDayOfYear.getDayOfWeek() == DayOfWeek.THURSDAY || firstDayOfYear.getDayOfWeek() == DayOfWeek.WEDNESDAY && firstDayOfYear.isLeapYear()) {
            return 53;
        }
        return 52;
    }

    @Function(value="WEEKNUM")
    @FunctionParameters(value={@FunctionParameter(value="dateObj")})
    public Integer WEEKNUM(Object dateObj) {
        Date date = this.convertDateObject(dateObj);
        if (date == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        LocalDate ld = DateTimeFunctions.ofInstant(Instant.ofEpochMilli(date.getTime()), this.getReportTimeZone().toZoneId());
        return ld.get(ChronoField.ALIGNED_WEEK_OF_YEAR);
    }

    @Function(value="MONTHS")
    @FunctionParameters(value={@FunctionParameter(value="startDate"), @FunctionParameter(value="endDate")})
    public Integer MONTHS(Object startDate, Object endDate) {
        Date startDateObj = this.convertDateObject(startDate);
        if (startDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        Date endDateObj = this.convertDateObject(endDate);
        if (endDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        ZoneId reportZoneID = this.getReportTimeZone().toZoneId();
        LocalDate startLocalDate = DateTimeFunctions.ofInstant(Instant.ofEpochMilli(startDateObj.getTime()), reportZoneID);
        LocalDate endLocalDate = DateTimeFunctions.ofInstant(Instant.ofEpochMilli(endDateObj.getTime()), reportZoneID);
        return (int)ChronoUnit.MONTHS.between(startLocalDate, endLocalDate);
    }

    @Function(value="YEARS")
    @FunctionParameters(value={@FunctionParameter(value="startDate"), @FunctionParameter(value="endDate")})
    public Integer YEARS(Object startDate, Object endDate) {
        Date startDateObj = this.convertDateObject(startDate);
        if (startDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        Date endDateObj = this.convertDateObject(endDate);
        if (endDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        ZoneId reportZoneID = this.getReportTimeZone().toZoneId();
        LocalDate startLocalDate = DateTimeFunctions.ofInstant(Instant.ofEpochMilli(startDateObj.getTime()), reportZoneID);
        LocalDate endLocalDate = DateTimeFunctions.ofInstant(Instant.ofEpochMilli(endDateObj.getTime()), reportZoneID);
        return (int)ChronoUnit.YEARS.between(startLocalDate, endLocalDate);
    }

    @Function(value="ISLEAPYEAR")
    @FunctionParameters(value={@FunctionParameter(value="dateObj")})
    public Boolean ISLEAPYEAR(Object dateObj) {
        Date date = this.convertDateObject(dateObj);
        if (date == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        LocalDate ld = DateTimeFunctions.ofInstant(Instant.ofEpochMilli(date.getTime()), this.getReportTimeZone().toZoneId());
        return ld.isLeapYear();
    }

    @Function(value="DATEFORMAT")
    @FunctionParameters(value={@FunctionParameter(value="dateObj"), @FunctionParameter(value="formatPattern")})
    public String DATEFORMAT(Date dateObj, String formatPattern) {
        if (dateObj == null) {
            return null;
        }
        ZoneId zoneId = this.getReportTimeZone().toZoneId();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(formatPattern, this.getReportLocale()).withZone(zoneId);
        ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(dateObj.getTime()), zoneId);
        return formatter.format(zdt);
    }

    @Function(value="DATERANGE")
    @FunctionParameters(value={@FunctionParameter(value="dateExprObj")})
    public DateRange DATERANGE(Object dateExprObj) {
        DateRangeBuilder dateRangeBuilder = null;
        if (dateExprObj instanceof String) {
            dateRangeBuilder = new DateRangeBuilder((String)dateExprObj);
        } else if (dateExprObj instanceof Date) {
            dateRangeBuilder = new DateRangeBuilder((Date)dateExprObj);
        } else {
            throw new IllegalArgumentException("The input parameter for DATERANGE function can be only a String or a Date object");
        }
        dateRangeBuilder.set(this.getReportLocale());
        dateRangeBuilder.set(this.getReportTimeZone());
        return dateRangeBuilder.toDateRange();
    }

    private Date convertDateObject(Object dateObject) {
        if (dateObject == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The date object can not be null.");
            }
            return null;
        }
        if (dateObject instanceof String) {
            int[] formatTypes;
            for (int formatType : formatTypes = new int[]{2, 3, 1, 0}) {
                try {
                    DateFormat df = DateFormat.getDateInstance(formatType, this.getReportLocale());
                    df.setTimeZone(this.getReportTimeZone());
                    return df.parse((String)dateObject);
                }
                catch (ParseException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Unable to parse the string as Date using the standard SimpleDateFormat.");
                }
            }
            return null;
        }
        if (dateObject instanceof Long) {
            Calendar cal = Calendar.getInstance(this.getReportTimeZone(), this.getReportLocale());
            cal.setTimeInMillis((Long)dateObject);
            return cal.getTime();
        }
        if (dateObject instanceof Date) {
            return (Date)dateObject;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"The specified object is not among the allowed types for Date conversion.");
        }
        return null;
    }

    private Integer getCalendarFieldFromDate(Object dateObject, int field) {
        Date convertedDate = this.convertDateObject(dateObject);
        if (convertedDate == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        Calendar cal = Calendar.getInstance(this.getReportTimeZone(), this.getReportLocale());
        cal.setTime(convertedDate);
        return cal.get(field);
    }

    private static void logCannotConvertToDate() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unable to convert to a valid Date instance.");
        }
    }

    private TimeZone getReportTimeZone() {
        TimeZone reportTimeZone = TimeZone.getDefault();
        if (this.getContext() != null) {
            reportTimeZone = (TimeZone)this.getContext().getParameterValue("REPORT_TIME_ZONE");
        }
        return reportTimeZone;
    }

    private Locale getReportLocale() {
        Locale reportLocale = Locale.getDefault();
        if (this.getContext() != null) {
            reportLocale = (Locale)this.getContext().getParameterValue("REPORT_LOCALE");
        }
        return reportLocale;
    }

    private static boolean isWeekendDay(DayOfWeek day) {
        return DayOfWeek.SATURDAY.equals(day) || DayOfWeek.SUNDAY.equals(day);
    }

    private static LocalDate ofInstant(Instant instant, ZoneId zone) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(zone, "zone");
        ZoneRules rules = zone.getRules();
        ZoneOffset offset = rules.getOffset(instant);
        long localSecond = instant.getEpochSecond() + (long)offset.getTotalSeconds();
        long localEpochDay = Math.floorDiv(localSecond, 86400);
        return LocalDate.ofEpochDay(localEpochDay);
    }
}

