/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizationHelper;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.ClassLoaderResource;
import net.sf.jasperreports.engine.util.ContextClassLoaderObjectInputStream;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JRLoader {
    private static final Log log = LogFactory.getLog(JRLoader.class);
    public static final String EXCEPTION_MESSAGE_KEY_BYTE_DATA_FROM_INPUT_STREAM_ERROR = "util.loader.byte.data.from.input.stream.error";
    public static final String EXCEPTION_MESSAGE_KEY_BYTE_DATA_LOADING_ERROR = "util.loader.byte.data.loading.error";
    public static final String EXCEPTION_MESSAGE_KEY_CLASS_NOT_FOUND_FROM_FILE = "util.loader.class.not.found.from.file";
    public static final String EXCEPTION_MESSAGE_KEY_CLASS_NOT_FOUND_FROM_INPUT_STREAM = "util.loader.class.not.found.from.input.stream";
    public static final String EXCEPTION_MESSAGE_KEY_CLASS_NOT_FOUND_FROM_URL = "util.loader.class.not.found.from.url";
    public static final String EXCEPTION_MESSAGE_KEY_FILE_OPEN_ERROR = "util.loader.file.open.error";
    public static final String EXCEPTION_MESSAGE_KEY_INPUT_STREAM_FROM_FILE_OPEN_ERROR = "util.loader.input.stream.from.file.open.error";
    public static final String EXCEPTION_MESSAGE_KEY_INPUT_STREAM_FROM_URL_OPEN_ERROR = "util.loader.input.stream.from.url.open.error";
    public static final String EXCEPTION_MESSAGE_KEY_OBJECT_FROM_FILE_LOADING_ERROR = "util.loader.object.from.file.loading.error";
    public static final String EXCEPTION_MESSAGE_KEY_OBJECT_FROM_INPUT_STREAM_LOADING_ERROR = "util.loader.object.from.input.stream.loading.error";
    public static final String EXCEPTION_MESSAGE_KEY_OBJECT_FROM_URL_LOADING_ERROR = "util.loader.object.from.url.loading.error";
    public static final String EXCEPTION_MESSAGE_KEY_RESOURCE_NOT_FOUND = "util.loader.resource.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_URL_OPEN_ERROR = "util.loader.url.open.error";

    public static Object loadObjectFromFile(String fileName) throws JRException {
        return JRLoader.loadObject(new File(fileName));
    }

    public static Object loadObject(File file) throws JRException {
        return JRLoader.loadObject((JasperReportsContext)DefaultJasperReportsContext.getInstance(), file);
    }

    public static Object loadObject(JasperReportsContext jasperReportsContext, File file) throws JRException {
        if (!file.exists() || !file.isFile()) {
            throw new JRException(new FileNotFoundException(String.valueOf(file)));
        }
        Object obj = null;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
             ContextClassLoaderObjectInputStream ois = new ContextClassLoaderObjectInputStream(jasperReportsContext, is);){
            obj = ois.readObject();
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_OBJECT_FROM_FILE_LOADING_ERROR, new Object[]{file}, e);
        }
        catch (ClassNotFoundException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_CLASS_NOT_FOUND_FROM_FILE, new Object[]{file}, e);
        }
        return obj;
    }

    public static Object loadObject(URL url) throws JRException {
        return JRLoader.loadObject((JasperReportsContext)DefaultJasperReportsContext.getInstance(), url);
    }

    public static Object loadObject(JasperReportsContext jasperReportsContext, URL url) throws JRException {
        Object obj = null;
        try (InputStream is = url.openStream();
             ContextClassLoaderObjectInputStream ois = new ContextClassLoaderObjectInputStream(jasperReportsContext, is);){
            obj = ois.readObject();
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_OBJECT_FROM_URL_LOADING_ERROR, new Object[]{url}, e);
        }
        catch (ClassNotFoundException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_CLASS_NOT_FOUND_FROM_URL, new Object[]{url}, e);
        }
        return obj;
    }

    public static Object loadObject(InputStream is) throws JRException {
        return JRLoader.loadObject((JasperReportsContext)DefaultJasperReportsContext.getInstance(), is);
    }

    public static Object loadObject(JasperReportsContext jasperReportsContext, InputStream is) throws JRException {
        Object obj = null;
        ContextClassLoaderObjectInputStream ois = null;
        try {
            ois = new ContextClassLoaderObjectInputStream(jasperReportsContext, is);
            obj = ois.readObject();
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_OBJECT_FROM_INPUT_STREAM_LOADING_ERROR, null, e);
        }
        catch (ClassNotFoundException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_CLASS_NOT_FOUND_FROM_INPUT_STREAM, null, e);
        }
        return obj;
    }

    public static InputStream getInputStream(File file) throws JRException {
        if (!file.exists() || !file.isFile()) {
            throw new JRException(new FileNotFoundException(String.valueOf(file)));
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_INPUT_STREAM_FROM_FILE_OPEN_ERROR, new Object[]{file}, e);
        }
        return fis;
    }

    public static InputStream getInputStream(URL url) throws JRException {
        InputStream is = null;
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_INPUT_STREAM_FROM_URL_OPEN_ERROR, new Object[]{url}, e);
        }
        return is;
    }

    public static byte[] loadBytes(File file) throws JRException {
        try {
            return Files.readAllBytes(file.toPath());
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_BYTE_DATA_LOADING_ERROR, new Object[]{file}, e);
        }
    }

    public static byte[] loadBytes(URL url) throws JRException {
        byte[] byArray;
        block8: {
            InputStream is = url.openStream();
            try {
                byArray = JRLoader.readBytes(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new JRException(EXCEPTION_MESSAGE_KEY_BYTE_DATA_LOADING_ERROR, new Object[]{url}, e);
                }
            }
            is.close();
        }
        return byArray;
    }

    public static byte[] loadBytes(InputStream is) throws JRException {
        try {
            return JRLoader.readBytes(is);
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_BYTE_DATA_FROM_INPUT_STREAM_ERROR, null, e);
        }
    }

    public static byte[] readBytes(InputStream is) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] bytes = new byte[10000];
            int ln = 0;
            while ((ln = is.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static byte[] loadBytesFromResource(String resourceName) throws JRException {
        return JRLoader.loadBytesFromResource(resourceName, null);
    }

    public static byte[] loadBytesFromResource(String resourceName, ClassLoader classLoader) throws JRException {
        URL url = JRResourcesUtil.findClassLoaderResource(resourceName, classLoader);
        if (url != null) {
            return JRLoader.loadBytes(url);
        }
        throw new JRException(EXCEPTION_MESSAGE_KEY_RESOURCE_NOT_FOUND, resourceName);
    }

    public static InputStream getLocationInputStream(String location) throws JRException {
        InputStream is = null;
        is = JRLoader.getResourceInputStream(location);
        if (is == null) {
            is = JRLoader.getFileInputStream(location);
        }
        if (is == null) {
            is = JRLoader.getURLInputStream(location);
        }
        return is;
    }

    public static InputStream getFileInputStream(String filename) throws JRException {
        FileInputStream is = null;
        File file = new File(filename);
        if (file.exists() && file.isFile()) {
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_FILE_OPEN_ERROR, new Object[]{filename}, e);
            }
        }
        return is;
    }

    public static InputStream getResourceInputStream(String resource) {
        InputStream is = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            is = classLoader.getResourceAsStream(resource);
        }
        if (is == null) {
            classLoader = JRLoader.class.getClassLoader();
            if (classLoader != null) {
                is = classLoader.getResourceAsStream(resource);
            }
            if (is == null) {
                is = JRPropertiesUtil.class.getResourceAsStream("/" + resource);
            }
        }
        return is;
    }

    public static List<URL> getResources(String resource) {
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>();
        JRLoader.collectResources(resource, JRLoader.class.getClassLoader(), resources);
        JRLoader.collectResources(resource, Thread.currentThread().getContextClassLoader(), resources);
        return new ArrayList<URL>(resources);
    }

    protected static void collectResources(String resourceName, ClassLoader classLoader, Set<URL> resources) {
        if (classLoader != null) {
            try {
                Enumeration<URL> urls = classLoader.getResources(resourceName);
                if (urls != null) {
                    while (urls.hasMoreElements()) {
                        URL url = urls.nextElement();
                        resources.add(url);
                    }
                }
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
    }

    public static List<ClassLoaderResource> getClassLoaderResources(String resource) {
        LinkedHashMap<URL, ClassLoaderResource> resources = new LinkedHashMap<URL, ClassLoaderResource>();
        JRLoader.collectResources(resource, JRLoader.class.getClassLoader(), resources);
        JRLoader.collectResources(resource, Thread.currentThread().getContextClassLoader(), resources);
        return new ArrayList<ClassLoaderResource>(resources.values());
    }

    protected static void collectResources(String resourceName, ClassLoader classLoader, Map<URL, ClassLoaderResource> resources) {
        if (classLoader == null) {
            return;
        }
        try {
            LinkedList<ClassLoader> classloaders = new LinkedList<ClassLoader>();
            ClassLoader ancestorLoader = classLoader;
            while (ancestorLoader != null) {
                classloaders.addFirst(ancestorLoader);
                try {
                    ancestorLoader = ancestorLoader.getParent();
                }
                catch (SecurityException e) {
                    ancestorLoader = null;
                }
            }
            for (ClassLoader ancestor : classloaders) {
                Enumeration<URL> urls = ancestor.getResources(resourceName);
                if (urls == null) continue;
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    if (resources.containsKey(url)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found resource " + resourceName + " at " + url + " in classloader " + ancestor));
                    }
                    ClassLoaderResource resource = new ClassLoaderResource(url, ancestor);
                    resources.put(url, resource);
                }
            }
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public static URL getResource(String resource) {
        URL location = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            location = classLoader.getResource(resource);
        }
        if (location == null) {
            classLoader = JRLoader.class.getClassLoader();
            if (classLoader != null) {
                location = classLoader.getResource(resource);
            }
            if (location == null) {
                location = JRPropertiesUtil.class.getResource("/" + resource);
            }
        }
        return location;
    }

    public static InputStream getURLInputStream(String spec) throws JRException {
        InputStream is = null;
        try {
            URL url = new URL(spec);
            is = url.openStream();
        }
        catch (MalformedURLException url) {
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_URL_OPEN_ERROR, new Object[]{spec}, e);
        }
        return is;
    }

    public static JasperPrint loadJasperPrintFromFile(String fileName, JRVirtualizer virtualizer) throws JRException {
        if (virtualizer != null) {
            JRVirtualizationHelper.setThreadVirtualizer(virtualizer);
        }
        try {
            JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObjectFromFile(fileName);
            return jasperPrint;
        }
        finally {
            if (virtualizer != null) {
                JRVirtualizationHelper.clearThreadVirtualizer();
            }
        }
    }

    public static JasperPrint loadJasperPrint(File file, JRVirtualizer virtualizer) throws JRException {
        if (virtualizer != null) {
            JRVirtualizationHelper.setThreadVirtualizer(virtualizer);
        }
        try {
            JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(file);
            return jasperPrint;
        }
        finally {
            if (virtualizer != null) {
                JRVirtualizationHelper.clearThreadVirtualizer();
            }
        }
    }

    public static JasperPrint loadJasperPrint(URL url, JRVirtualizer virtualizer) throws JRException {
        if (virtualizer != null) {
            JRVirtualizationHelper.setThreadVirtualizer(virtualizer);
        }
        try {
            JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(url);
            return jasperPrint;
        }
        finally {
            if (virtualizer != null) {
                JRVirtualizationHelper.clearThreadVirtualizer();
            }
        }
    }

    public static JasperPrint loadJasperPrint(InputStream is, JRVirtualizer virtualizer) throws JRException {
        if (virtualizer != null) {
            JRVirtualizationHelper.setThreadVirtualizer(virtualizer);
        }
        try {
            JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(is);
            return jasperPrint;
        }
        finally {
            if (virtualizer != null) {
                JRVirtualizationHelper.clearThreadVirtualizer();
            }
        }
    }

    private JRLoader() {
    }
}

