/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.FillEnum;

public abstract class JRBaseGraphicElement
extends JRBaseElement
implements JRGraphicElement {
    private static final long serialVersionUID = 10200L;
    protected JRPen linePen;
    protected FillEnum fillValue;
    private int PSEUDO_SERIAL_VERSION_UID = 30702;
    private Byte fill;

    protected JRBaseGraphicElement(JRGraphicElement graphicElement, JRBaseObjectFactory factory) {
        super(graphicElement, factory);
        this.linePen = graphicElement.getLinePen().clone(this);
        this.fillValue = graphicElement.getOwnFillValue();
    }

    @Override
    public JRPen getLinePen() {
        return this.linePen;
    }

    @Override
    public FillEnum getFillValue() {
        return this.getStyleResolver().getFillValue(this);
    }

    @Override
    public FillEnum getOwnFillValue() {
        return this.fillValue;
    }

    @Override
    public void setFill(FillEnum fillValue) {
        FillEnum old = this.fillValue;
        this.fillValue = fillValue;
        this.getEventSupport().firePropertyChange("fill", old, this.fillValue);
    }

    @Override
    public Float getDefaultLineWidth() {
        return JRPen.LINE_WIDTH_1;
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public Object clone() {
        JRBaseGraphicElement clone = (JRBaseGraphicElement)super.clone();
        clone.linePen = this.linePen.clone(clone);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.fillValue = FillEnum.getByValue(this.fill);
            this.fill = null;
        }
    }
}

