/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.taglib.DbBaseHandlerTag;
import org.dbforms.util.MessageResources;
import org.dbforms.util.ParseUtil;

public class DbSortTag
extends DbBaseHandlerTag
implements TryCatchFinally {
    private static Log logCat = LogFactory.getLog((Class)(class$org$dbforms$taglib$DbSortTag == null ? (class$org$dbforms$taglib$DbSortTag = DbSortTag.class$("org.dbforms.taglib.DbSortTag")) : class$org$dbforms$taglib$DbSortTag));
    static /* synthetic */ Class class$org$dbforms$taglib$DbSortTag;

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public int doEndTag() throws JspException {
        try {
            if (!this.getField().hasIsKeySet() && !this.getField().hasSortableSet()) {
                logCat.warn((Object)("you should declare " + this.getField().getName() + " as key or as sortable in your config file, if you use it as ordering field!"));
            }
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            String oldValue = ParseUtil.getParameter(request, this.getField().getSortFieldName());
            StringBuffer tagBuf = new StringBuffer();
            tagBuf.append("<select name=\"");
            tagBuf.append(this.getField().getSortFieldName());
            tagBuf.append("\" size=\"0\" onChange=\"javascript:document.dbform.submit()\" >");
            String strAsc = "Ascending";
            String strDesc = "Descending";
            String strNone = "None";
            if (this.getParentForm().hasCaptionResourceSet()) {
                Locale reqLocale = MessageResources.getLocale(request);
                strAsc = MessageResources.getMessage("dbforms.select.sort.ascending", reqLocale, "Ascending");
                strDesc = MessageResources.getMessage("dbforms.select.sort.descending", reqLocale, "Descending");
                strNone = MessageResources.getMessage("dbforms.select.sort.none", reqLocale, "None");
            }
            tagBuf.append("<option value=\"asc\"");
            if ("asc".equalsIgnoreCase(oldValue)) {
                tagBuf.append(" selected ");
            }
            tagBuf.append(">").append(strAsc);
            tagBuf.append("<option value=\"desc\"");
            if ("desc".equalsIgnoreCase(oldValue)) {
                tagBuf.append(" selected ");
            }
            tagBuf.append(">").append(strDesc);
            tagBuf.append("<option value=\"none\" ");
            if (oldValue == null || "none".equals(oldValue)) {
                tagBuf.append(" selected ");
            }
            tagBuf.append(">").append(strNone);
            tagBuf.append("</select>");
            this.pageContext.getOut().write(tagBuf.toString());
        }
        catch (IOException ioe) {
            throw new JspException("IO Error: " + ioe.getMessage());
        }
        return 6;
    }

    public void doFinally() {
        super.doFinally();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

