/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib.tags;

import de.laures.cewolf.CewolfException;
import de.laures.cewolf.Configuration;
import de.laures.cewolf.links.CategoryItemLinkGenerator;
import de.laures.cewolf.links.LinkGenerator;
import de.laures.cewolf.links.PieSectionLinkGenerator;
import de.laures.cewolf.links.XYItemLinkGenerator;
import de.laures.cewolf.taglib.tags.CewolfRootTag;
import de.laures.cewolf.taglib.tags.CewolfTag;
import de.laures.cewolf.taglib.tags.Mapped;
import de.laures.cewolf.taglib.util.BrowserDetection;
import de.laures.cewolf.taglib.util.PageUtils;
import de.laures.cewolf.tooltips.CategoryToolTipGenerator;
import de.laures.cewolf.tooltips.PieToolTipGenerator;
import de.laures.cewolf.tooltips.ToolTipGenerator;
import de.laures.cewolf.tooltips.XYToolTipGenerator;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.LegendItemEntity;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;

public class ChartMapTag
extends CewolfTag {
    private static final long serialVersionUID = -3742340487378471159L;
    ToolTipGenerator toolTipGenerator = null;
    LinkGenerator linkGenerator = null;
    boolean useJFreeChartLinkGenerator = false;
    boolean useJFreeChartTooltipGenerator = false;

    public int doStartTag() throws JspException {
        Mapped root = (Mapped)((Object)PageUtils.findRoot((Tag)this, this.pageContext));
        root.enableMapping();
        String chartId = ((CewolfRootTag)((Object)root)).getChartId();
        try {
            Dataset dataset = PageUtils.getDataset(chartId, this.pageContext);
            JspWriter out = this.pageContext.getOut();
            boolean isIE = BrowserDetection.isIE((HttpServletRequest)this.pageContext.getRequest());
            if (this.hasToolTips()) {
                this.enableToolTips((Writer)out, isIE);
            }
            out.write("<MAP name=\"" + chartId + "\">\n");
            ChartRenderingInfo info = (ChartRenderingInfo)root.getRenderingInfo();
            Iterator entities = info.getEntityCollection().iterator();
            while (entities.hasNext()) {
                ChartEntity ce = (ChartEntity)entities.next();
                out.write("\n<AREA shape=\"" + ce.getShapeType() + "\" ");
                out.write("COORDS=\"" + ce.getShapeCoords() + "\" ");
                if (ce instanceof XYItemEntity) {
                    dataset = ((XYItemEntity)ce).getDataset();
                }
                if (!(ce instanceof LegendItemEntity)) {
                    if (this.hasToolTips()) {
                        this.writeOutToolTip(dataset, (Writer)out, isIE, ce);
                    }
                    if (this.hasLinks()) {
                        this.writeOutLink(this.linkGenerator, dataset, (Writer)out, ce);
                    }
                }
                out.write(">");
            }
        }
        catch (IOException ioex) {
            throw new JspException(ioex.getMessage());
        }
        catch (CewolfException cwex) {
            throw new JspException(cwex.getMessage());
        }
        return 6;
    }

    public int doEndTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            out.write("</MAP>");
        }
        catch (IOException ioex) {
            throw new JspException(ioex.getMessage());
        }
        return this.doAfterEndTag(6);
    }

    public void reset() {
        this.toolTipGenerator = null;
        this.linkGenerator = null;
    }

    public void writeOutLink(Object linkGen, Dataset dataset, Writer out, ChartEntity ce) throws IOException {
        String link = this.generateLink(dataset, ce);
        if (null != link) {
            String href = ((HttpServletResponse)this.pageContext.getResponse()).encodeURL(link);
            out.write("HREF=\"" + href + "\"");
        }
    }

    private void writeOutToolTip(Dataset dataset, Writer out, boolean isIE, ChartEntity ce) throws IOException, JspException {
        String toolTip = this.generateToolTip(dataset, ce);
        if (null != toolTip) {
            if (!isIE) {
                out.write("ONMOUSEOVER=\"return overlib('" + toolTip + "', WIDTH, '20');\" ONMOUSEOUT=\"return nd();\" ");
            } else {
                out.write("ALT=\"" + toolTip + "\" ");
            }
        }
    }

    public void enableToolTips(Writer out, boolean isIE) throws IOException {
        if (!PageUtils.isToolTipsEnabled(this.pageContext) && !isIE) {
            Configuration config = Configuration.getInstance(this.pageContext.getServletContext());
            String overLibURL = config.getOverlibURL();
            out.write("<script language=\"JavaScript\" src=\"");
            out.write(overLibURL + "\"><!-- overLIB (c) Erik Bosrup --></script>\n");
            out.write("<div id=\"overDiv\" style=\"position:absolute; visibility:hidden; z-index:1000;\"></div>\n");
            PageUtils.setToolTipsEnabled(this.pageContext);
        }
    }

    private String generateLink(Dataset dataset, ChartEntity ce) {
        String link = null;
        if (this.useJFreeChartLinkGenerator) {
            link = ce.getURLText();
        } else if (this.linkGenerator instanceof CategoryItemLinkGenerator) {
            if (ce instanceof CategoryItemEntity) {
                CategoryItemEntity catEnt = (CategoryItemEntity)ce;
                link = ((CategoryItemLinkGenerator)this.linkGenerator).generateLink(dataset, catEnt.getSeries(), catEnt.getCategory());
            }
        } else if (this.linkGenerator instanceof XYItemLinkGenerator) {
            XYItemEntity xyEnt = (XYItemEntity)ce;
            link = ((XYItemLinkGenerator)this.linkGenerator).generateLink(dataset, xyEnt.getSeriesIndex(), xyEnt.getItem());
        } else if (this.linkGenerator instanceof PieSectionLinkGenerator) {
            PieSectionEntity pieEnt = (PieSectionEntity)ce;
            link = ((PieSectionLinkGenerator)this.linkGenerator).generateLink(dataset, pieEnt.getSectionKey());
        }
        return link;
    }

    private String generateToolTip(Dataset dataset, ChartEntity ce) throws JspException {
        String tooltip = null;
        if (this.useJFreeChartTooltipGenerator) {
            tooltip = ce.getToolTipText();
        } else if (this.toolTipGenerator instanceof CategoryToolTipGenerator && ce instanceof CategoryItemEntity) {
            CategoryItemEntity catEnt = (CategoryItemEntity)ce;
            tooltip = ((CategoryToolTipGenerator)this.toolTipGenerator).generateToolTip((CategoryDataset)dataset, catEnt.getSeries(), catEnt.getCategoryIndex());
        } else if (this.toolTipGenerator instanceof XYToolTipGenerator && ce instanceof XYItemEntity) {
            XYItemEntity xyEnt = (XYItemEntity)ce;
            tooltip = ((XYToolTipGenerator)this.toolTipGenerator).generateToolTip((XYDataset)dataset, xyEnt.getSeriesIndex(), xyEnt.getItem());
        } else if (this.toolTipGenerator instanceof PieToolTipGenerator && ce instanceof PieSectionEntity) {
            PieSectionEntity pieEnt = (PieSectionEntity)ce;
            PieDataset ds = (PieDataset)dataset;
            int index = pieEnt.getSectionIndex();
            tooltip = ((PieToolTipGenerator)this.toolTipGenerator).generateToolTip(ds, ds.getKey(index), index);
        }
        return tooltip;
    }

    private boolean hasToolTips() throws JspException {
        if (this.toolTipGenerator != null && this.useJFreeChartTooltipGenerator) {
            throw new JspException("Can't have both tooltipGenerator and useJFreeChartTooltipGenerator parameters specified!");
        }
        return this.toolTipGenerator != null || this.useJFreeChartTooltipGenerator;
    }

    public void setTooltipgeneratorid(String id) {
        this.toolTipGenerator = (ToolTipGenerator)this.pageContext.findAttribute(id);
    }

    private boolean hasLinks() throws JspException {
        if (this.linkGenerator != null && this.useJFreeChartLinkGenerator) {
            throw new JspException("Can't have both linkGenerator and useJFreeChartLinkGenerator parameters specified!");
        }
        return this.linkGenerator != null || this.useJFreeChartLinkGenerator;
    }

    public void setLinkgeneratorid(String id) {
        this.linkGenerator = (LinkGenerator)this.pageContext.findAttribute(id);
    }

    public void setUseJFreeChartLinkGenerator(boolean useJFreeChartLinkGenerator) {
        this.useJFreeChartLinkGenerator = useJFreeChartLinkGenerator;
    }

    public void setUseJFreeChartTooltipGenerator(boolean useJFreeChartTooltipGenerator) {
        this.useJFreeChartTooltipGenerator = useJFreeChartTooltipGenerator;
    }
}

