/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags.util;

import info.bliki.wiki.tags.util.AbstractNode;
import info.bliki.wiki.tags.util.Attribute;
import info.bliki.wiki.tags.util.NodeAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiTagNode
extends AbstractNode {
    private static final long serialVersionUID = -5135255005207719745L;
    private static final String[] NONE = new String[0];
    protected List<NodeAttribute> mAttributes;

    public WikiTagNode() {
        this(-1, -1, new ArrayList<NodeAttribute>());
    }

    public WikiTagNode(int start, int end, ArrayList<NodeAttribute> attributes) {
        super(start, end);
        this.mAttributes = attributes;
        if (null == this.mAttributes || 0 == this.mAttributes.size()) {
            String[] names = this.getIds();
            if (null != names && 0 != names.length) {
                this.setTagName(names[0]);
            } else {
                this.setTagName("");
            }
        } else {
            this.setTagName(((Attribute)this.mAttributes.get(0)).getName());
        }
    }

    public String getAttribute(String name) {
        String ret = null;
        NodeAttribute attribute = this.getAttributeEx(name);
        if (null != attribute) {
            ret = attribute.getValue();
        }
        return ret;
    }

    public void setAttribute(String key, String value) {
        char quote;
        boolean needed = false;
        boolean singleq = true;
        boolean doubleq = true;
        if (null != value) {
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (Character.isWhitespace(ch)) {
                    needed = true;
                    continue;
                }
                if ('\'' == ch) {
                    singleq = false;
                    continue;
                }
                if ('\"' != ch) continue;
                doubleq = false;
            }
        }
        if (needed) {
            if (doubleq) {
                quote = '\"';
            } else if (singleq) {
                quote = '\'';
            } else {
                quote = '\"';
                value = StringUtils.replace((String)value, (String)"\"", (String)"&quot;");
            }
        } else {
            quote = '\u0000';
        }
        NodeAttribute attribute = this.getAttributeEx(key);
        if (null != attribute) {
            attribute.setValue(value);
            if ('\u0000' != quote) {
                attribute.setQuote(quote);
            }
        } else {
            this.setAttribute(key, value, quote);
        }
    }

    public void removeAttribute(String key) {
        NodeAttribute attribute = this.getAttributeEx(key);
        if (null != attribute) {
            this.getAttributesEx().remove(attribute);
        }
    }

    public void setAttribute(String key, String value, char quote) {
        this.setAttribute(new NodeAttribute(key, value, quote));
    }

    public NodeAttribute getAttributeEx(String name) {
        NodeAttribute ret = null;
        List<NodeAttribute> attributes = this.getAttributesEx();
        if (null != attributes) {
            int size = attributes.size();
            for (int i = 0; i < size; ++i) {
                NodeAttribute attribute = attributes.get(i);
                String string = attribute.getName();
                if (null == string || !name.equalsIgnoreCase(string)) continue;
                ret = attribute;
                i = size;
            }
        }
        return ret;
    }

    public void setAttributeEx(NodeAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setAttribute(NodeAttribute attribute) {
        boolean replaced = false;
        List<NodeAttribute> attributes = this.getAttributesEx();
        int length = attributes.size();
        if (0 < length) {
            String name = attribute.getName();
            for (int i = 1; i < attributes.size(); ++i) {
                Attribute test = attributes.get(i);
                String test_name = test.getName();
                if (null == test_name || !test_name.equalsIgnoreCase(name)) continue;
                attributes.set(i, attribute);
                replaced = true;
            }
        }
        if (!replaced) {
            if (0 != length && !attributes.get(length - 1).isWhitespace()) {
                attributes.add(new NodeAttribute(" "));
            }
            attributes.add(attribute);
        }
    }

    public List<NodeAttribute> getAttributesEx() {
        return this.mAttributes;
    }

    public String getTagName() {
        String ret = this.getRawTagName();
        if (null != ret) {
            if ((ret = ret.toLowerCase()).startsWith("/")) {
                ret = ret.substring(1);
            }
            if (ret.endsWith("/")) {
                ret = ret.substring(0, ret.length() - 1);
            }
        }
        return ret;
    }

    public String getRawTagName() {
        String ret = null;
        List<NodeAttribute> attributes = this.getAttributesEx();
        if (0 != attributes.size()) {
            ret = attributes.get(0).getName();
        }
        return ret;
    }

    public void setTagName(String name) {
        NodeAttribute attribute = new NodeAttribute(name, null, '\u0000');
        List<NodeAttribute> attributes = this.getAttributesEx();
        if (null == attributes) {
            attributes = new ArrayList<NodeAttribute>();
            this.setAttributesEx(attributes);
        }
        if (0 == attributes.size()) {
            attributes.add(attribute);
        } else {
            Attribute zeroth = attributes.get(0);
            if (null == zeroth.getValue() && '\u0000' == zeroth.getQuote()) {
                attributes.set(0, attribute);
            } else {
                attributes.add(0, attribute);
            }
        }
    }

    @Override
    public String getText() {
        String ret = this.toHtml();
        ret = ret.substring(1, ret.length() - 1);
        return ret;
    }

    public void setAttributesEx(List<NodeAttribute> attribs) {
        this.mAttributes = attribs;
    }

    public void setTagBegin(int tagBegin) {
        this.nodeBegin = tagBegin;
    }

    public int getTagBegin() {
        return this.nodeBegin;
    }

    public void setTagEnd(int tagEnd) {
        this.nodeEnd = tagEnd;
    }

    public int getTagEnd() {
        return this.nodeEnd;
    }

    @Override
    public String toPlainTextString() {
        return "";
    }

    @Override
    public String toHtml(boolean verbatim) {
        NodeAttribute attribute;
        int i;
        int length = 2;
        List<NodeAttribute> attributes = this.getAttributesEx();
        int size = attributes.size();
        for (i = 0; i < size; ++i) {
            attribute = attributes.get(i);
            length += attribute.getLength();
        }
        StringBuilder ret = new StringBuilder(length);
        ret.append("<");
        for (i = 0; i < size; ++i) {
            attribute = attributes.get(i);
            attribute.toString(ret);
            if (i >= size - 1) continue;
            ret.append(" ");
        }
        ret.append(">");
        return ret.toString();
    }

    public boolean isEmptyXmlTag() {
        Attribute attribute;
        String name;
        boolean ret = false;
        List<NodeAttribute> attributes = this.getAttributesEx();
        int size = attributes.size();
        if (0 < size && null != (name = (attribute = (Attribute)attributes.get(size - 1)).getName())) {
            int length = name.length();
            ret = name.charAt(length - 1) == '/';
        }
        return ret;
    }

    public void setEmptyXmlTag(boolean emptyXmlTag) {
        List<NodeAttribute> attributes = this.getAttributesEx();
        int size = attributes.size();
        if (0 < size) {
            NodeAttribute attribute = attributes.get(size - 1);
            String name = attribute.getName();
            if (null != name) {
                int length = name.length();
                String value = attribute.getValue();
                if (null == value) {
                    if (name.charAt(length - 1) == '/') {
                        if (!emptyXmlTag) {
                            if (1 == length) {
                                attributes.remove(size - 1);
                            } else {
                                name = name.substring(0, length - 1);
                                attribute = new NodeAttribute(name, null);
                                attributes.remove(size - 1);
                                attributes.add(attribute);
                            }
                        }
                    } else if (emptyXmlTag) {
                        attribute = new NodeAttribute(" ");
                        attributes.add(attribute);
                        attribute = new NodeAttribute("/", null);
                        attributes.add(attribute);
                    }
                } else if (emptyXmlTag) {
                    attribute = new NodeAttribute(" ");
                    attributes.add(attribute);
                    attribute = new NodeAttribute("/", null);
                    attributes.add(attribute);
                }
            } else if (emptyXmlTag) {
                attribute = new NodeAttribute("/", null);
                attributes.add(attribute);
            }
        } else if (emptyXmlTag) {
            NodeAttribute attribute = new NodeAttribute("/", null);
            attributes.add(attribute);
        }
    }

    public boolean isEndTag() {
        String raw = this.getRawTagName();
        return null != raw && 0 != raw.length() && '/' == raw.charAt(0);
    }

    public String[] getIds() {
        return NONE;
    }

    public String[] getEnders() {
        return NONE;
    }

    public String[] getEndTagEnders() {
        return NONE;
    }
}

