/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.util.Vector;

public class PGtokenizer {
    protected Vector tokens;

    public PGtokenizer(String string, char delim) {
        this.tokenize(string, delim);
    }

    public int tokenize(String string, char delim) {
        this.tokens = new Vector();
        int nest = 0;
        int p = 0;
        int s = 0;
        while (p < string.length()) {
            char c2 = string.charAt(p);
            if (c2 == '(' || c2 == '[' || c2 == '<') {
                ++nest;
            }
            if (c2 == ')' || c2 == ']' || c2 == '>') {
                --nest;
            }
            if (nest == 0 && c2 == delim) {
                this.tokens.addElement(string.substring(s, p));
                s = p + 1;
            }
            ++p;
        }
        if (s < string.length()) {
            this.tokens.addElement(string.substring(s));
        }
        return this.tokens.size();
    }

    public int getSize() {
        return this.tokens.size();
    }

    public String getToken(int n) {
        return (String)this.tokens.elementAt(n);
    }

    public PGtokenizer tokenizeToken(int n, char delim) {
        return new PGtokenizer(this.getToken(n), delim);
    }

    public static String remove(String s, String l2, String t) {
        if (s.startsWith(l2)) {
            s = s.substring(l2.length());
        }
        if (s.endsWith(t)) {
            s = s.substring(0, s.length() - t.length());
        }
        return s;
    }

    public void remove(String l2, String t) {
        int i2 = 0;
        while (i2 < this.tokens.size()) {
            this.tokens.setElementAt(PGtokenizer.remove((String)this.tokens.elementAt(i2), l2, t), i2);
            ++i2;
        }
    }

    public static String removePara(String s) {
        return PGtokenizer.remove(s, "(", ")");
    }

    public void removePara() {
        this.remove("(", ")");
    }

    public static String removeBox(String s) {
        return PGtokenizer.remove(s, "[", "]");
    }

    public void removeBox() {
        this.remove("[", "]");
    }

    public static String removeAngle(String s) {
        return PGtokenizer.remove(s, "<", ">");
    }

    public void removeAngle() {
        this.remove("<", ">");
    }
}

