/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import com.lowagie.text.DocumentException;
import de.memtext.db.NichtAngemeldetException;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.ServletHelper;
import de.memtext.util.StringUtils;
import de.superx.common.DBServletException;
import de.superx.common.InvalidDataTypeException;
import de.superx.common.InvalidKeyException;
import de.superx.common.SichtException;
import de.superx.common.UngueltigeEingabeException;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SuperXManager;
import de.superx.util.SqlStringUtils;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public abstract class SuperXServletHelper
extends ServletHelper {
    protected String userid;
    private boolean isAjaxResponder = false;
    protected String currentXml;

    public SuperXServletHelper(HttpServletRequest request, HttpServletResponse response) throws IOException {
        super(request, response, "superx");
    }

    public static void removeCookie(HttpServletRequest request, HttpServletResponse response) {
        try {
            Cookie[] cookies = request.getCookies();
            if (cookies.length > 0) {
                int i2 = 0;
                while (i2 < cookies.length) {
                    Cookie c2 = cookies[i2];
                    if (c2.getName().equals("JSESSIONID") || c2.getName().equals("JSESSIONIDSSO")) {
                        String host;
                        Cookie c22 = new Cookie(c2.getName(), "1234567890");
                        c22.setMaxAge(0);
                        if (c2.getName().equals("JSESSIONID")) {
                            c22.setPath("/superx");
                        }
                        if (c2.getName().equals("JSESSIONIDSSO")) {
                            c22.setPath("/");
                        }
                        if ((host = request.getHeader("host")) != null && host.startsWith(".")) {
                            host = host.substring(1);
                        }
                        c22.setDomain(host);
                        if (request.getScheme().equals("https")) {
                            c22.setSecure(true);
                        }
                        response.addCookie(c22);
                    }
                    ++i2;
                }
            }
        }
        catch (Exception e2) {
            System.out.println(e2);
        }
    }

    @Override
    public void checkSessionType() throws NichtAngemeldetException {
        super.checkSessionType();
        if (!(SuperXManager.refererstart == null || SuperXManager.refererstart.equals("null") || this.request.getHeader("Referer") != null && this.request.getHeader("Referer").startsWith(SuperXManager.refererstart))) {
            System.out.println("Falscher Referer: " + this.request.getHeader("Referer") + " erwartet:" + SuperXManager.refererstart);
            throw new NichtAngemeldetException("False Referer");
        }
    }

    @Override
    public void run(boolean isAuthentificationCheckWanted) throws IOException, ServletException {
        try {
            if (isAuthentificationCheckWanted) {
                this.checkSessionType();
            }
            this.perform();
        }
        catch (NichtAngemeldetException e2) {
            this.sendNotAuthorized();
        }
        catch (SichtException e3) {
            this.writeExceptionText("sql", e3, null);
        }
        catch (SQLException e4) {
            this.writeExceptionText("sql", e4, null);
        }
        catch (DBServletException e5) {
            this.writeExceptionText("conn", e5, null);
        }
        catch (KeyParentEqualException e6) {
            this.writeExceptionText("sql", e6, null);
        }
        catch (TransformerException e7) {
            Logger.getLogger("superx_" + this.getMandantenID()).log(Level.SEVERE, e7.toString());
            this.response.reset();
            this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
            this.response.getWriter().println(ServletUtils.getXmlErrorText(e7.toString(), this.currentXml, this.getDesiredLocale()));
        }
        catch (ParseException e8) {
            this.writeExceptionText("sql", e8, null);
        }
        catch (IOException e9) {
            this.writeExceptionText("sql", e9, null);
        }
        catch (ParserConfigurationException e10) {
            this.writeExceptionText("sql", e10, null);
        }
        catch (FactoryConfigurationError e11) {
            this.writeExceptionText("sql", e11, null);
        }
        catch (SAXException e12) {
            this.writeExceptionText("sql", e12, null);
        }
        catch (DocumentException e13) {
            this.writeExceptionText("sql", e13, null);
        }
        catch (IllegalArgumentException e14) {
            this.writeExceptionText("sql", e14, null);
        }
        catch (SecurityException e15) {
            this.writeExceptionText("sql", e15, null);
        }
        catch (InstantiationException e16) {
            this.writeExceptionText("sql", e16, null);
        }
        catch (IllegalAccessException e17) {
            this.writeExceptionText("sql", e17, null);
        }
        catch (InvocationTargetException e18) {
            this.writeExceptionText("sql", e18, null);
        }
        catch (NoSuchMethodException e19) {
            this.writeExceptionText("sql", e19, null);
        }
        catch (CloneNotSupportedException e20) {
            this.writeExceptionText("sql", e20, null);
        }
        catch (TemplateException e21) {
            this.writeExceptionText("sql", e21, null);
        }
        catch (NoMainEntryException e22) {
            this.writeExceptionText("sql", e22, null);
        }
        catch (InvalidKeyException e23) {
            this.writeResponse(e23);
        }
        catch (UngueltigeEingabeException e24) {
            this.writeResponse(e24);
        }
        catch (InvalidDataTypeException e25) {
            this.writeResponse(e25);
        }
    }

    private void writeResponse(Exception e2) {
        this.response.reset();
        this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
        PrintWriter output = null;
        try {
            output = this.response.getWriter();
            output.write("<html><body><h1>Achtung</h1>" + e2.getMessage() + "</body></html>");
            output.close();
            this.turnCacheOff();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void sendNotAuthorized() throws IOException {
        this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
        String mand = null;
        try {
            mand = this.getMandantenID();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        PrintWriter p = this.response.getWriter();
        p.print(ServletUtils.getLoginFailureXml(this.userid, mand, this.getDesiredLocale()));
        p.close();
    }

    public void writeExceptionText(String loggerType, Throwable e2, String task) {
        Logger.getLogger("superx_" + this.getMandantenID()).log(Level.SEVERE, e2.toString());
        this.response.reset();
        if (!this.isAjaxResponder()) {
            this.response.setStatus(500);
            this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
        } else {
            this.response.setContentType("text/json-comment-filtered");
        }
        PrintWriter output = null;
        try {
            output = this.response.getWriter();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.turnCacheOff();
        if (this.isAjaxResponder()) {
            String ex = "Serverfehler:" + StringUtils.jsonAdapt(e2.toString(), true);
            output.println("/*({error:\"" + ex + "\"})*/");
        } else {
            String msg = "Es ist ein Fehler aufgetreten";
            if (task != null) {
                msg = String.valueOf(msg) + " bei: " + task;
            }
            StringWriter outstr = new StringWriter();
            e2.printStackTrace(new PrintWriter(outstr));
            output.println("<html><body><h1>" + msg + "</h1><p>");
            output.print(StringUtils.filterOutput(outstr.toString()));
            output.println("</p></body></html>");
        }
        output.flush();
        output.close();
    }

    @Override
    protected abstract void perform() throws SQLException, DBServletException, TransformerException, KeyParentEqualException, NichtAngemeldetException, IOException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, CloneNotSupportedException, TemplateException, InvalidKeyException, SichtException, IOException, ServletException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException;

    public String getMandantenID() {
        return ServletUtils.getMandantenID(this.request);
    }

    public boolean isAjaxResponder() {
        return this.isAjaxResponder;
    }

    public void setAjaxResponder(boolean isAjaxResponder) {
        this.isAjaxResponder = isAjaxResponder;
    }

    class DummyErrorListener
    implements ErrorListener {
        DummyErrorListener() {
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            System.out.println(exception);
        }
    }
}

