/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Random;

public class NumberUtils {
    static int maxLength = 7;
    static Random rnd = new Random();
    static NumberFormat numberformat = NumberFormat.getInstance();

    static {
        numberformat.setMaximumFractionDigits(2);
    }

    private NumberUtils() {
    }

    public static void setFractionDigits(int numberOfDigits) {
        numberformat.setMaximumFractionDigits(numberOfDigits);
        numberformat.setMinimumFractionDigits(numberOfDigits);
    }

    public static int getRandomInt(int max) {
        return Math.abs(rnd.nextInt() % (max + 1));
    }

    public static String format(double zahl) {
        return numberformat.format(zahl);
    }

    public static String format(double zahl, int digits) {
        numberformat.setMinimumFractionDigits(digits);
        numberformat.setMaximumFractionDigits(digits);
        return numberformat.format(zahl);
    }

    public static String format(Double zahl, int digits) {
        numberformat.setMinimumFractionDigits(digits);
        numberformat.setMaximumFractionDigits(digits);
        String ret = null;
        try {
            ret = numberformat.format(zahl);
        }
        catch (IllegalArgumentException e2) {
            System.out.println(zahl);
        }
        return numberformat.format(zahl);
    }

    public static String format(Double zahl) {
        return numberformat.format(zahl);
    }

    public static Number parse(String in) throws ParseException {
        return numberformat.parse(in);
    }

    public static void setMaxLength(int maxLen) {
        if (maxLen < 1) {
            maxLen = 1;
        }
        maxLength = maxLen;
    }

    public static String getMaxLenString(double x) {
        String ret = new Double(x).toString();
        if (ret.length() > maxLength) {
            ret = ret.substring(0, maxLength);
        }
        return ret;
    }

    public static String getMaxLenString(Object x) {
        String ret = x.toString();
        if (ret.length() > maxLength) {
            ret = ret.substring(0, maxLength);
        }
        return ret;
    }

    public static String getMaxLenString(String x) {
        if (x.length() > maxLength) {
            x = x.substring(0, maxLength);
        }
        return x;
    }
}

