/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.xbean.spring.generator.AttributeMapping;
import org.apache.xbean.spring.generator.ElementMapping;
import org.apache.xbean.spring.generator.GeneratorPlugin;
import org.apache.xbean.spring.generator.LogFacade;
import org.apache.xbean.spring.generator.NamespaceMapping;
import org.apache.xbean.spring.generator.Type;
import org.apache.xbean.spring.generator.Utils;

public class WikiDocumentationGenerator
implements GeneratorPlugin {
    private final File destFile;
    private LogFacade log;

    public WikiDocumentationGenerator(File destFile) {
        this.destFile = destFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(NamespaceMapping namespaceMapping) throws IOException {
        String namespace = namespaceMapping.getNamespace();
        File file = new File(this.destFile.getParentFile(), this.destFile.getName() + ".wiki");
        this.log.log("Generating WIKI documentation file: " + file + " for namespace: " + namespace);
        PrintWriter out = new PrintWriter(new FileWriter(file));
        try {
            this.generateDocumentation(out, namespaceMapping);
        }
        finally {
            out.close();
        }
    }

    private void generateDocumentation(PrintWriter out, NamespaceMapping namespaceMapping) {
        HashMap refercencedTypes = new HashMap();
        Iterator<Object> iter = namespaceMapping.getElements().iterator();
        while (iter.hasNext()) {
            ElementMapping element = (ElementMapping)iter.next();
            Iterator iterator = element.getAttributes().iterator();
            while (iterator.hasNext()) {
                AttributeMapping attribute = (AttributeMapping)iterator.next();
                Type type = this.getNestedType(attribute.getType());
                if (Utils.isSimpleType(type) || refercencedTypes.containsKey(type.getName())) continue;
                refercencedTypes.put(type.getName(), new ArrayList());
            }
        }
        iter = refercencedTypes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            String type = (String)entry.getKey();
            ArrayList implementations = (ArrayList)entry.getValue();
            Iterator iterator = namespaceMapping.getElements().iterator();
            block3: while (iterator.hasNext()) {
                String t;
                Iterator j;
                ElementMapping element = (ElementMapping)iterator.next();
                boolean matched = false;
                if (type.equals(element.getClassName())) {
                    implementations.add(element);
                    matched = true;
                }
                if (!matched) {
                    j = element.getSuperClasses().iterator();
                    while (j.hasNext()) {
                        t = (String)j.next();
                        if (!type.equals(t)) continue;
                        implementations.add(element);
                        matched = true;
                        break;
                    }
                }
                if (matched) continue;
                j = element.getInterfaces().iterator();
                while (j.hasNext()) {
                    t = (String)j.next();
                    if (!type.equals(t)) continue;
                    implementations.add(element);
                    matched = true;
                    continue block3;
                }
            }
        }
        iter = refercencedTypes.values().iterator();
        while (iter.hasNext()) {
            ArrayList implementations = (ArrayList)iter.next();
            if (!implementations.isEmpty()) continue;
            iter.remove();
        }
        this.generateElementsByType(out, namespaceMapping, refercencedTypes);
        this.generateElementsDetail(out, namespaceMapping, refercencedTypes);
        this.generateElementsIndex(out, namespaceMapping, refercencedTypes);
    }

    private Type getNestedType(Type type) {
        if (type.isCollection()) {
            return this.getNestedType(type.getNestedType());
        }
        return type;
    }

    private void generateElementsByType(PrintWriter out, NamespaceMapping namespaceMapping, HashMap refercencedTypes) {
        out.println("h3. Elements By Type");
        Iterator iter = refercencedTypes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String className = (String)entry.getKey();
            Collection elements = (Collection)entry.getValue();
            out.println("{anchor:" + className + "-types}");
            out.println("h4. The _[" + className + "|#" + className + "-types]_ Type Implementations");
            Iterator iterator = elements.iterator();
            while (iterator.hasNext()) {
                ElementMapping element = (ElementMapping)iterator.next();
                out.println("    | _[<" + element.getElementName() + ">|#" + element.getElementName() + "-element]_ | {html}" + element.getDescription() + "{html} |");
            }
            out.println();
        }
        out.println();
    }

    private void generateElementsIndex(PrintWriter out, NamespaceMapping namespaceMapping, HashMap refercencedTypes) {
        out.println("h3. Element Index");
        Iterator iter = namespaceMapping.getElements().iterator();
        while (iter.hasNext()) {
            ElementMapping element = (ElementMapping)iter.next();
            out.println("    | _[<" + element.getElementName() + ">|#" + element.getElementName() + "-element]_ | {html}" + element.getDescription() + "{html} |");
        }
        out.println();
    }

    private void generateElementsDetail(PrintWriter out, NamespaceMapping namespaceMapping, HashMap refercencedTypes) {
        Iterator iter = namespaceMapping.getElements().iterator();
        while (iter.hasNext()) {
            ElementMapping element = (ElementMapping)iter.next();
            this.generateElementDetail(out, namespaceMapping, element, refercencedTypes);
        }
    }

    private void generateElementDetail(PrintWriter out, NamespaceMapping namespaceMapping, ElementMapping element, HashMap refercencedTypes) {
        out.println("{anchor:" + element.getElementName() + "-element}");
        out.println("h3. The _[<" + element.getElementName() + ">|#" + element.getElementName() + "-element]_ Element");
        out.println("    {html}" + element.getDescription() + "{html}");
        if (element.getAttributes().size() > 0) {
            out.println("h4. Properties");
            out.println("    || Property Name || Type || Description ||");
            Iterator iterator = element.getAttributes().iterator();
            while (iterator.hasNext()) {
                AttributeMapping attribute = (AttributeMapping)iterator.next();
                Type type = attribute.getType();
                out.println("    | " + attribute.getAttributeName() + " | " + this.getTypeLink(type, refercencedTypes) + " | {html}" + attribute.getDescription() + "{html} |");
            }
        }
        out.println();
    }

    private String getTypeLink(Type type, HashMap refercencedTypes) {
        if (type.isCollection()) {
            return "(" + this.getTypeLink(type.getNestedType(), refercencedTypes) + ")\\*";
        }
        if (refercencedTypes.containsKey(type.getName())) {
            return "_[" + type.getName() + "|#" + type.getName() + "-types]_";
        }
        return "_" + type.getName() + "_";
    }

    public LogFacade getLog() {
        return this.log;
    }

    public void setLog(LogFacade log) {
        this.log = log;
    }
}

