/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.rights.AllowableHierarchyUtil;
import de.memtext.rights.Rights;
import de.memtext.rights.RightsKeyEntry;
import de.memtext.util.EqualsUtil;
import de.memtext.util.StringUtils;
import de.superx.common.AbstractSicht;
import de.superx.common.SelectableItemNode;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.tree.TreeNode;

public class RightsApplicator {
    static void apply(AbstractSicht sicht, Rights rights) {
        if (sicht.getArt().equals("Organigramm-Sicht")) {
            AllowableHierarchyUtil.markNotAllowedNodes(sicht.getRoot(), " (Auswahl)");
        } else {
            if (sicht.getArt().indexOf("Kostenstellen") > -1 || sicht.getSichtartRechte().isActive()) {
                if (sicht.getUser().isAdmin() || rights.hasAllRights()) {
                    RightsApplicator.setAllAllowed(sicht);
                } else {
                    RightsApplicator.setSpecificRights(sicht, rights);
                }
                AllowableHierarchyUtil.removeUnallowedNodes(sicht.getRoot());
            } else {
                RightsApplicator.setAllAllowed(sicht);
            }
            if (sicht.getAttribut3() != null && sicht.getAttribut3() == 1) {
                AllowableHierarchyUtil.reorg(sicht.getRoot());
            } else {
                AllowableHierarchyUtil.markNotAllowedNodes(sicht.getRoot(), " (Auswahl)");
            }
        }
    }

    private static void setSpecificRights(AbstractSicht sicht, Rights rights) {
        Iterator it = rights.iterator();
        while (it.hasNext()) {
            RightsKeyEntry re = (RightsKeyEntry)it.next();
            if (re.getKey().toString().indexOf(",") > -1) {
                RightsApplicator.checkOnlyPosOrNeg(re.getKey().toString());
            }
            if (re.getKey().toString().indexOf("-") > -1) {
                RightsApplicator.addNegativeRight(sicht, re);
                continue;
            }
            StringTokenizer st = new StringTokenizer(re.getKey().toString(), ",");
            while (st.hasMoreElements()) {
                String singleKey = st.nextToken();
                String key = StringUtils.replace(singleKey, "*", "");
                key = StringUtils.replace(key, "-", "");
                RightsApplicator.addPositiveRight(sicht, re, singleKey, key);
            }
        }
        Enumeration<TreeNode> en = sicht.getRoot().breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            if (!node.isTmpMarkerAllowed()) continue;
            node.setAllowed(true);
        }
    }

    private static void addNegativeRight(AbstractSicht sicht, RightsKeyEntry re) {
        StringTokenizer st = new StringTokenizer(re.getKey().toString(), ",");
        TreeSet<String> sternKeys = new TreeSet<String>();
        TreeSet<String> standardKeys = new TreeSet<String>();
        while (st.hasMoreElements()) {
            String akey = st.nextToken();
            if ((akey = StringUtils.replace(akey, "-", "")).indexOf("*") > -1) {
                akey = StringUtils.replace(akey, "*", "");
                sternKeys.add(akey);
                continue;
            }
            standardKeys.add(akey);
        }
        Enumeration<TreeNode> en = sicht.getRoot().breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            if (re.getKey().toString().indexOf("*") <= -1) continue;
            if (!RightsApplicator.identified(sternKeys, standardKeys, node.getId().toString())) {
                node.setAllowed(true);
                node.setTmpMarkerAllowed(true);
                continue;
            }
            node.setAllowed(false);
        }
    }

    private static boolean identified(Set sternKeys, Set standardKeys, String id) {
        boolean result = false;
        Iterator it = sternKeys.iterator();
        while (it.hasNext()) {
            if (!id.startsWith(it.next().toString())) continue;
            result = true;
            break;
        }
        it = standardKeys.iterator();
        while (it.hasNext()) {
            if (!id.equals(it.next().toString())) continue;
            result = true;
            break;
        }
        return result;
    }

    private static void addPositiveRight(AbstractSicht sicht, RightsKeyEntry re, String singleKey, String key) {
        Enumeration<TreeNode> en = sicht.getRoot().breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            if (singleKey.indexOf("*") > -1) {
                if (!node.getId().toString().startsWith(key)) continue;
                node.setAllowed(true);
                node.setTmpMarkerAllowed(true);
                node.setDescendantsAllowed(re.isSubordinatesAllowed());
                continue;
            }
            if (!EqualsUtil.areEqual(node.getId(), singleKey)) continue;
            node.setAllowed(true);
            node.setTmpMarkerAllowed(true);
            node.setDescendantsAllowed(re.isSubordinatesAllowed());
            break;
        }
    }

    private static void hideSubordinates(SelectableItemNode node) {
        Enumeration<TreeNode> en = node.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode n = (SelectableItemNode)en.nextElement();
            if (n == node) continue;
            n.setHidden(true);
            n.setDescendantsAllowed(false);
        }
    }

    private static void setAllAllowed(AbstractSicht sicht) {
        Enumeration<TreeNode> en = sicht.getRoot().breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            node.setAllowed(true);
        }
    }

    public static void checkOnlyPosOrNeg(String value) {
        StringTokenizer st = new StringTokenizer(value, ",");
        String lastVorzeichen = "";
        while (st.hasMoreElements()) {
            String einWert = st.nextToken();
            if (lastVorzeichen.equals("")) {
                if (einWert.indexOf("-") > -1) {
                    lastVorzeichen = "-";
                    continue;
                }
                lastVorzeichen = "+";
                continue;
            }
            String aktuellesVorzeichen = "";
            aktuellesVorzeichen = einWert.indexOf("-") > -1 ? "-" : "+";
            if (aktuellesVorzeichen.equals(lastVorzeichen)) continue;
            throw new IllegalArgumentException(" Berechtigungen m\u00fcssen entweder alle positive oder alle negativ sein (gefunden: " + value + ")");
        }
    }
}

