/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import de.memtext.util.ImageAndRtfTransferable;
import de.memtext.util.ImageTransferable;
import de.memtext.util.RtfTransferable;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class ClipboardUtils {
    private static final Clipboard CLIPBOARD = Toolkit.getDefaultToolkit().getSystemClipboard();

    private ClipboardUtils() {
    }

    public static boolean setContents(StringBuffer content, ClipboardOwner owner) {
        return ClipboardUtils.setContents(content.toString(), owner);
    }

    public static boolean setContents(Image image, ClipboardOwner owner) {
        return ClipboardUtils.setContents(new ImageTransferable(image), owner);
    }

    public static boolean setContents(String content, ClipboardOwner owner) {
        return ClipboardUtils.setContents(new StringSelection(content), null);
    }

    public static boolean setImageContents(Component comp, ClipboardOwner owner) {
        return ClipboardUtils.setContents(new ImageTransferable(comp), owner);
    }

    public static void setImageAndRtfContents(Image image, ByteArrayOutputStream outStream, ClipboardOwner owner) {
        ByteArrayInputStream byteInputStream = new ByteArrayInputStream(outStream.toByteArray());
        ClipboardUtils.setContents(new ImageAndRtfTransferable(image, byteInputStream), owner);
    }

    public static void setRtfContents(ByteArrayOutputStream outStream, ClipboardOwner owner) {
        ByteArrayInputStream byteInputStream = new ByteArrayInputStream(outStream.toByteArray());
        ClipboardUtils.setContents(new RtfTransferable(byteInputStream), owner);
    }

    public static boolean setContents(Transferable contents, ClipboardOwner owner) {
        boolean result = true;
        try {
            CLIPBOARD.setContents(contents, owner);
        }
        catch (IllegalStateException e) {
            ClipboardUtils.showWarning(e);
            result = false;
        }
        return result;
    }

    public static BufferedImage toBufferedImage(Component comp) {
        BufferedImage tempImage = new BufferedImage(comp.getSize().width, comp.getSize().height, 1);
        Graphics tempGraphics = tempImage.getGraphics();
        Graphics2D g2d = (Graphics2D)tempImage.getGraphics();
        comp.paint(tempGraphics);
        return tempImage;
    }

    public static byte[] toByteArray(BufferedImage image) throws IOException {
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "jpg", outstream);
        return outstream.toByteArray();
    }

    private static void showWarning(Exception e) {
        JOptionPane.showMessageDialog(null, "Couldn't copy to clipboard.\n" + e.toString(), "Problem", 2);
    }

    public static Object getContents() {
        Transferable result;
        String[] s = ImageIO.getWriterFormatNames();
        for (int i = 0; i < s.length; ++i) {
            System.out.println(s[i]);
        }
        System.exit(-1);
        Transferable t = result = CLIPBOARD.getContents(null);
        DataFlavor[] d = t.getTransferDataFlavors();
        for (int i = 1; i < d.length; ++i) {
            System.out.println(d[i]);
        }
        try {
            Object o = t.getTransferData(new DataFlavor("text/rtf;representationclass=java.io.InputStream"));
            boolean bl = true;
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        boolean i = true;
        return result;
    }

    public static void main(String[] args) {
        ClipboardUtils.test();
    }

    private static void test() {
        try {
            Transferable data = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            DataFlavor[] df = data.getTransferDataFlavors();
            for (int i = 0; i < df.length; ++i) {
                System.out.println(df[i].getHumanPresentableName() + "   " + df[i].getMimeType());
            }
        }
        catch (Throwable ta) {
            ta.printStackTrace();
        }
    }
}

