/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.csv.filter;

import de.werum.sis.csv.filter.FilterConstants;
import de.werum.sis.csv.filter.FilterField;
import de.werum.sis.csv.filter.FilterFieldGroup;
import de.werum.sis.csv.filter.FilterFieldSet;
import de.werum.sis.csv.filter.FilterFieldSetInstance;
import de.werum.sis.csv.filter.FilterPath;
import de.werum.sis.csv.filter.FilterProblem;
import de.werum.sis.csv.filter.FilterStructure;
import java.awt.Point;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Filter
extends FilterStructure
implements FilterConstants {
    private int type = 1;
    private String id = null;
    private String jspName = null;
    private List<FilterFieldSet> fieldSets = new LinkedList<FilterFieldSet>();

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getJspName() {
        return this.jspName;
    }

    public void setJspName(String jspName) {
        this.jspName = jspName;
    }

    public List<FilterFieldSet> getFieldSets() {
        return this.fieldSets;
    }

    public FilterFieldSet getFieldSet(String name) {
        FilterFieldSet result = null;
        for (FilterFieldSet fieldSet : this.fieldSets) {
            if (!fieldSet.getName().equals(name)) continue;
            result = fieldSet;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("Satz <" + name + "> existiert nicht.");
        }
        return result;
    }

    public Filter getCopy() {
        Filter copy = new Filter();
        this.copyInto(copy);
        copy.setType(this.getType());
        copy.setId(this.getId());
        copy.setJspName(this.getJspName());
        for (FilterFieldSet fieldSet : this.fieldSets) {
            copy.getFieldSets().add(fieldSet.getCopy());
        }
        return copy;
    }

    public void computePositions(boolean modifyOnly) {
        this.computePositions(1, this.getType(), modifyOnly);
        for (FilterFieldSet fieldSet : this.fieldSets) {
            fieldSet.computePositions(this.getType(), modifyOnly);
        }
    }

    public FilterProblem[] check() {
        return this.check(null);
    }

    public FilterProblem[] check(String language) {
        int i;
        LinkedList<FilterProblem> problems = new LinkedList<FilterProblem>();
        HashMap<Point, FilterPath> positions = new HashMap<Point, FilterPath>();
        LinkedList<String> selektorValues = new LinkedList<String>();
        FilterPath filterPath = new FilterPath(this);
        int fieldSetInstancesCount = this.getFieldSetInstancesCount();
        for (i = 0; i < this.getFields().size(); ++i) {
            this.check(this.getFields().get(i), filterPath, problems, positions, 0);
        }
        for (i = 0; i < this.getFieldSets().size(); ++i) {
            FilterFieldSet fieldSet = this.getFieldSets().get(i);
            FilterPath fieldSetPath = new FilterPath(filterPath, fieldSet);
            for (int j = 0; j < fieldSet.getInstances().size(); ++j) {
                FilterFieldSetInstance instance = fieldSet.getInstances().get(j);
                FilterPath fieldSetInstancePath = new FilterPath(fieldSetPath, instance);
                positions.clear();
                for (int k = 0; k < instance.getFields().size(); ++k) {
                    this.check(instance.getFields().get(k), fieldSetInstancePath, problems, positions, 0);
                }
                FilterField[] selectors = instance.getPossibleSelectors();
                if (selectors != null && selectors.length > 0) {
                    StringBuffer selectorKey = new StringBuffer();
                    for (FilterField selector : selectors) {
                        selectorKey.append('[');
                        selectorKey.append(selector.getPosition());
                        selectorKey.append('=');
                        selectorKey.append(selector.getDefaultValue());
                        selectorKey.append(']');
                        if (!selektorValues.contains(selectorKey.toString())) continue;
                        LinkedList<FilterPath> list = new LinkedList<FilterPath>();
                        list.add(fieldSetInstancePath);
                        problems.add(new FilterProblem(FilterProblem.ProblemSeverity.ERROR, FilterProblem.ProblemReason.AMBIGUITY, list));
                        break;
                    }
                    selektorValues.add(selectorKey.toString());
                    continue;
                }
                if (fieldSetInstancesCount <= 1) continue;
                LinkedList<FilterPath> list = new LinkedList<FilterPath>();
                list.add(fieldSetInstancePath);
                problems.add(new FilterProblem(FilterProblem.ProblemSeverity.ERROR, FilterProblem.ProblemReason.AMBIGUITY, list));
            }
        }
        return problems.toArray(new FilterProblem[0]);
    }

    @Override
    public boolean hasFieldGroups() {
        boolean result = super.hasFieldGroups();
        if (!result) {
            for (int i = 0; i < this.getFieldSets().size(); ++i) {
                FilterFieldSet fieldSet = this.getFieldSets().get(i);
                if (!fieldSet.hasFieldGroups()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public void updateFrom(FilterStructure structure) {
        Filter filter = (Filter)structure;
        if (this.getType() == filter.getType()) {
            super.updateFrom(structure);
            for (int i = 0; i < this.getFieldSets().size(); ++i) {
                FilterFieldSet anotherFieldSet;
                FilterFieldSet fieldSet = this.getFieldSets().get(i);
                try {
                    anotherFieldSet = filter.getFieldSet(fieldSet.getName());
                }
                catch (Exception e) {
                    anotherFieldSet = null;
                }
                if (anotherFieldSet == null) continue;
                fieldSet.updateFrom(anotherFieldSet);
            }
        }
    }

    @Override
    public void sortByPosition() {
        super.sortByPosition();
        for (int i = 0; i < this.getFieldSets().size(); ++i) {
            FilterFieldSet fieldSet = this.getFieldSets().get(i);
            fieldSet.sortByPosition();
        }
    }

    private int check(Object object, FilterPath parentPath, List<FilterProblem> problems, Map<Point, FilterPath> positions, int offset) {
        int maxFieldPos = 0;
        int minFieldPos = Integer.MAX_VALUE;
        if (object instanceof FilterField) {
            FilterField field = (FilterField)object;
            FilterPath fieldPath = new FilterPath(parentPath, field);
            boolean defined = false;
            if (field.getPosition() != null && field.getPosition() > 0) {
                if (this.getType() == 2) {
                    if (field.getLength() != null && field.getLength() > 0) {
                        defined = true;
                    }
                } else {
                    defined = true;
                }
            }
            if (defined) {
                int value = field.getPosition();
                boolean overlap = false;
                Point pos = this.getType() == 2 ? new Point(value, value + field.getLength() - 1) : new Point(value += offset, value);
                for (Point position : positions.keySet()) {
                    if (pos.x > position.y || pos.y < position.x) continue;
                    overlap = true;
                    LinkedList<FilterPath> list = new LinkedList<FilterPath>();
                    list.add(positions.get(position));
                    list.add(fieldPath);
                    problems.add(new FilterProblem(FilterProblem.ProblemSeverity.WARNING, FilterProblem.ProblemReason.OVERLAP, list));
                    break;
                }
                if (!overlap) {
                    positions.put(pos, fieldPath);
                }
                maxFieldPos = value;
            } else {
                maxFieldPos = 0;
            }
        } else if (object instanceof FilterFieldGroup) {
            FilterFieldGroup fieldGroup = (FilterFieldGroup)object;
            int fieldPos = 0;
            if (fieldGroup.getNumber() > 0) {
                int durchlauf = 0;
                int merkeOffSet = offset;
                while (durchlauf < fieldGroup.getNumber()) {
                    maxFieldPos = 0;
                    minFieldPos = Integer.MAX_VALUE;
                    for (int i = 0; i < fieldGroup.getFields().size(); ++i) {
                        fieldPos = this.check(fieldGroup.getFields().get(i), new FilterPath(parentPath, fieldGroup), problems, positions, offset);
                        if (fieldPos > 0 && fieldPos > maxFieldPos) {
                            maxFieldPos = fieldPos;
                        }
                        if (fieldPos <= 0 || fieldPos >= minFieldPos) continue;
                        minFieldPos = fieldPos;
                    }
                    offset = merkeOffSet + (maxFieldPos - minFieldPos + 1) * ++durchlauf;
                }
            }
        }
        return maxFieldPos;
    }

    private int getFieldSetInstancesCount() {
        int result = 0;
        for (int i = 0; i < this.getFieldSets().size(); ++i) {
            FilterFieldSet fieldSet = this.getFieldSets().get(i);
            result += fieldSet.getInstances().size();
        }
        return result;
    }
}

