/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.sdf.generator.meta.MetaCustomSDFTemplateProgramm;
import de.statspez.sdf.generator.meta.SDFTags;
import de.statspez.sdf.generator.meta.generated.MetaSDFTemplateParameter;
import de.statspez.sdf.generator.parser.SDFParserContext;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ExecutableParser
extends SubParser {
    private MetaCustomSDFTemplateProgramm programm = null;
    private MetaSDFTemplateParameter parameter = null;
    private boolean notationPL = false;

    public ExecutableParser(SuperParser superParser, ResolverInterface resolver) {
        super(superParser, resolver);
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("executable".equalsIgnoreCase(localName)) {
            String id = atts.getValue("id");
            if (id == null) {
                throw new MetaParseException("ID von executable nicht definiert!");
            }
            this.programm.setId(SDFTags.dekodiereXMLName(id));
        } else if ("param".equalsIgnoreCase(localName)) {
            String name = atts.getValue("name");
            if (name == null) {
                throw new MetaParseException("Name von param nicht definiert!");
            }
            this.parameter.setName(name);
        } else if ("code".equalsIgnoreCase(localName)) {
            String notation = atts.getValue("notation");
            if (notation == null) {
                throw new MetaParseException("Notation von code nicht definiert!");
            }
            this.notationPL = notation.equalsIgnoreCase("PL");
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        boolean handled = true;
        String chars = this.superParser().charData().toString();
        if ("param".equalsIgnoreCase(localName)) {
            if (chars.length() > 0) {
                this.parameter.setVorgabeWert(chars);
            }
            this.programm.addToParameter(this.parameter);
        } else if ("code".equalsIgnoreCase(localName)) {
            if (this.notationPL) {
                this.programm.setCode(chars);
                try {
                    this.programm.setSpecification(Helper.metaStructureFor((String)chars));
                }
                catch (Exception e) {
                    throw new MetaParseException("SDF-Meta-Programm <" + this.programm.getId() + ">, Fehler in der Spezifikation.", e);
                }
            }
        } else {
            handled = false;
        }
        return handled;
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("executable".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("executable".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            this.programm = new MetaCustomSDFTemplateProgramm();
            this.enable();
        } else if ("param".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            this.superParser().charData().delete(0, this.superParser().charData().length());
            this.parameter = new MetaSDFTemplateParameter();
        } else if ("code".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else {
            throw MetaParseException.unknownTagException((String)localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("executable".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.handleTag(namespaceURI, localName, qName)) {
            throw MetaParseException.unknownClosingTagException((String)localName);
        }
    }

    public MetaElementInterface object() {
        return this.programm;
    }
}

