/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.meta.MetaCustomSDFDokumenterzeuger;
import de.statspez.sdf.generator.meta.SDFTags;
import de.statspez.sdf.generator.meta.generated.MetaSDFTemplate;
import de.statspez.sdf.generator.meta.generated.MetaSDFTemplateProgramm;
import de.statspez.sdf.generator.parser.ExecutableParser;
import de.statspez.sdf.generator.parser.LocalReference;
import de.statspez.sdf.generator.parser.SDFParserContext;
import de.statspez.sdf.generator.parser.TemplateParser;
import de.werum.sis.common.AbstractMessage;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.ParserChain;
import de.werum.sis.meta.parser.Reference;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DocumentBuilderParser
extends SubParser
implements SuperParser {
    private ParserChain parserChain = new ParserChain();
    private ExecutableParser executableParser;
    private TemplateParser templateParser;
    private MetaCustomSDFDokumenterzeuger dokumenterzeuger;

    public DocumentBuilderParser(SuperParser superParser, ResolverInterface resolver) {
        super(superParser, resolver);
        this.executableParser = new ExecutableParser(this, resolver);
        this.parserChain.addParser((SubParser)this.executableParser);
        this.templateParser = new TemplateParser(this, resolver);
        this.parserChain.addParser((SubParser)this.templateParser);
        this.dokumenterzeuger = null;
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("documentBuilder".equalsIgnoreCase(localName)) {
            String documentType = atts.getValue("document-type");
            if (documentType == null) {
                throw new MetaParseException("DocumentType von documentBuilder nicht definiert!");
            }
            this.dokumenterzeuger.setDokumentTyp(documentType);
            String version = atts.getValue("version");
            if (version == null) {
                throw new MetaParseException("Version von documentBuilder nicht definiert!");
            }
            this.dokumenterzeuger.setDokumentVersion(version);
            String encoding = atts.getValue("encoding");
            if (encoding == null) {
                throw new MetaParseException("Encoding von documentBuilder nicht definiert!");
            }
            this.dokumenterzeuger.setEncoding(encoding);
            String method = atts.getValue("method");
            if (method == null) {
                throw new MetaParseException("Method von documentBuilder nicht definiert!");
            }
            this.dokumenterzeuger.setMethode(method);
        } else if ("templates".equalsIgnoreCase(localName)) {
            String startTemplate = atts.getValue("start-template");
            if (startTemplate == null) {
                throw new MetaParseException("Start-Template von templates nicht definiert!");
            }
            startTemplate = SDFTags.dekodiereXMLName(startTemplate);
            this.dokumenterzeuger.setStartTemplateId(startTemplate);
            this.resolver().registerForResolve((Reference)new LocalReference(this.dokumenterzeuger, "TEMPLATE_BY_ID", startTemplate, this.dokumenterzeuger));
        }
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("documentBuilder".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("documentBuilder".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSDF(namespaceURI);
            this.dokumenterzeuger = new MetaCustomSDFDokumenterzeuger();
            this.templateParser.setDokumenterzeuger(this.dokumenterzeuger);
            this.enable();
        } else if ("executables".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("templates".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
            throw MetaParseException.unknownTagException((String)localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("documentBuilder".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!("executables".equalsIgnoreCase(localName) || "templates".equalsIgnoreCase(localName) || this.parserChain.endElement(namespaceURI, localName, qName))) {
            throw MetaParseException.unknownClosingTagException((String)localName);
        }
    }

    public MetaElementInterface object() {
        return this.dokumenterzeuger;
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public void notifyObjectStarted(SubParser aParser) {
    }

    public void notifyObjectAvailable(SubParser aParser) {
        if (aParser == this.executableParser) {
            this.dokumenterzeuger.addToProgramme((MetaSDFTemplateProgramm)aParser.object());
        } else if (aParser == this.templateParser) {
            this.dokumenterzeuger.addToTemplates((MetaSDFTemplate)aParser.object());
        }
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

