/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.saiku.service.ISessionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionService
implements ISessionService {
    private static final Logger log = LoggerFactory.getLogger(SessionService.class);
    private AuthenticationManager authenticationManager;
    Map<Object, Map<String, Object>> sessionHolder = new HashMap<Object, Map<String, Object>>();
    private Boolean anonymous = false;

    public void setAllowAnonymous(Boolean allow) {
        this.anonymous = allow;
    }

    public void setAuthenticationManager(AuthenticationManager auth) {
        this.authenticationManager = auth;
    }

    public Map<String, Object> login(HttpServletRequest req, String username, String password) {
        if (this.authenticationManager != null) {
            this.authenticate(req, username, password);
        }
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null) {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            Object p = auth.getPrincipal();
            this.createSession(auth, username, password);
            return this.sessionHolder.get(p);
        }
        return new HashMap<String, Object>();
    }

    private void createSession(Authentication auth, String username, String password) {
        boolean isAnonOk;
        if (auth == null || !auth.isAuthenticated()) {
            return;
        }
        boolean isAnonymousUser = auth instanceof AnonymousAuthenticationToken;
        Object p = auth.getPrincipal();
        String authUser = this.getUsername(p);
        boolean isAnonymous = isAnonymousUser || StringUtils.equals((String)"anonymousUser", (String)authUser);
        boolean bl = isAnonOk = !isAnonymous || isAnonymous && this.anonymous != false;
        if (isAnonOk && auth.isAuthenticated() && p != null && !this.sessionHolder.containsKey(p)) {
            HashMap<String, Object> session = new HashMap<String, Object>();
            if (isAnonymous) {
                log.debug("Creating Session for Anonymous User");
            }
            if (StringUtils.isNotBlank((String)username)) {
                session.put("username", username);
            } else {
                session.put("username", authUser);
            }
            if (StringUtils.isNotBlank((String)password)) {
                session.put("password", password);
            }
            session.put("sessionid", UUID.randomUUID().toString());
            ArrayList<String> roles = new ArrayList<String>();
            for (GrantedAuthority ga : SecurityContextHolder.getContext().getAuthentication().getAuthorities()) {
                roles.add(ga.getAuthority());
            }
            session.put("roles", roles);
            this.sessionHolder.put(p, session);
        }
    }

    private String getUsername(Object p) {
        if (p instanceof UserDetails) {
            return ((UserDetails)p).getUsername();
        }
        return p.toString();
    }

    public void logout(HttpServletRequest req) {
        Object p;
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null && this.sessionHolder.containsKey(p = SecurityContextHolder.getContext().getAuthentication().getPrincipal())) {
            this.sessionHolder.remove(p);
        }
        SecurityContextHolder.getContext().setAuthentication(null);
        SecurityContextHolder.clearContext();
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    public void authenticate(HttpServletRequest req, String username, String password) {
        try {
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
            token.setDetails((Object)new WebAuthenticationDetails(req));
            Authentication authentication = this.authenticationManager.authenticate((Authentication)token);
            log.debug("Logging in with [{}]", authentication.getPrincipal());
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        catch (BadCredentialsException bd) {
            throw new RuntimeException("Authentication failed for: " + username, bd);
        }
    }

    public Map<String, Object> getSession() {
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null) {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            Object p = auth.getPrincipal();
            this.createSession(auth, null, null);
            if (this.sessionHolder.containsKey(p)) {
                HashMap<String, Object> r = new HashMap<String, Object>();
                r.putAll(this.sessionHolder.get(p));
                r.remove("password");
                return r;
            }
        }
        return new HashMap<String, Object>();
    }

    public Map<String, Object> getAllSessionObjects() {
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null) {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            Object p = auth.getPrincipal();
            this.createSession(auth, null, null);
            if (this.sessionHolder.containsKey(p)) {
                HashMap<String, Object> r = new HashMap<String, Object>();
                r.putAll(this.sessionHolder.get(p));
                return r;
            }
        }
        return new HashMap<String, Object>();
    }
}

