/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.saiku.olap.dto.resultset.AbstractBaseCell;
import org.saiku.olap.dto.resultset.CellDataSet;
import org.saiku.olap.dto.resultset.DataCell;
import org.saiku.olap.dto.resultset.MemberCell;
import org.saiku.web.rest.objects.resultset.Cell;
import org.saiku.web.rest.objects.resultset.QueryResult;

public class RestUtil {
    public static QueryResult convert(ResultSet rs) {
        return RestUtil.convert(rs, 0);
    }

    public static QueryResult convert(ResultSet rs, int limit) {
        Integer width = 0;
        Integer height = 0;
        Cell[] header = null;
        ArrayList<Cell[]> rows = new ArrayList<Cell[]>();
        try {
            while (rs.next() && (limit == 0 || height < limit)) {
                if (height == 0) {
                    width = rs.getMetaData().getColumnCount();
                    header = new Cell[width.intValue()];
                    for (int s = 0; s < width; ++s) {
                        header[s] = new Cell(rs.getMetaData().getColumnName(s + 1), Cell.Type.COLUMN_HEADER);
                    }
                    if (width > 0) {
                        rows.add(header);
                    }
                }
                Cell[] row = new Cell[width.intValue()];
                for (int i = 0; i < width; ++i) {
                    String content = rs.getString(i + 1);
                    if (content == null) {
                        content = "";
                    }
                    row[i] = new Cell(content, Cell.Type.DATA_CELL);
                }
                rows.add(row);
                Integer n = height;
                Integer n2 = height = Integer.valueOf(height + 1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return new QueryResult(rows, 0, width, height);
    }

    public static QueryResult convert(CellDataSet cellSet) {
        return RestUtil.convert(cellSet, 0);
    }

    public static QueryResult convert(CellDataSet cellSet, int limit) {
        AbstractBaseCell[][] headers;
        ArrayList<Cell[]> rows = new ArrayList<Cell[]>();
        if (cellSet == null || cellSet.getCellSetBody() == null || cellSet.getCellSetHeaders() == null) {
            return null;
        }
        AbstractBaseCell[][] body = cellSet.getCellSetBody();
        for (AbstractBaseCell[] header : headers = cellSet.getCellSetHeaders()) {
            rows.add(RestUtil.convert(header, Cell.Type.COLUMN_HEADER));
        }
        for (int i = 0; i < body.length && (limit == 0 || i < limit); ++i) {
            AbstractBaseCell[] row = body[i];
            rows.add(RestUtil.convert(row, Cell.Type.ROW_HEADER));
        }
        QueryResult qr = new QueryResult(rows, cellSet.getRuntime(), cellSet.getWidth(), cellSet.getHeight());
        return qr;
    }

    public static Cell[] convert(AbstractBaseCell[] acells, Cell.Type headertype) {
        Cell[] cells = new Cell[acells.length];
        for (int i = 0; i < acells.length; ++i) {
            cells[i] = RestUtil.convert(acells[i], headertype);
        }
        return cells;
    }

    public static Cell convert(AbstractBaseCell acell, Cell.Type headertype) {
        if (acell != null) {
            if (acell instanceof DataCell) {
                DataCell dcell = (DataCell)acell;
                Properties metaprops = new Properties();
                String position = null;
                for (Integer number : dcell.getCoordinates()) {
                    if (position != null) {
                        position = position + ":" + number.toString();
                        continue;
                    }
                    position = number.toString();
                }
                if (position != null) {
                    metaprops.put("position", position);
                }
                if (dcell != null && dcell.getRawNumber() != null) {
                    metaprops.put("raw", "" + dcell.getRawNumber());
                }
                metaprops.putAll((Map<?, ?>)dcell.getProperties());
                return new Cell(dcell.getFormattedValue(), metaprops, Cell.Type.DATA_CELL);
            }
            if (acell instanceof MemberCell) {
                MemberCell mcell = (MemberCell)acell;
                Properties props = new Properties();
                if (mcell != null) {
                    if (mcell.getParentDimension() != null) {
                        props.put("dimension", mcell.getParentDimension());
                    }
                    if (mcell.getUniqueName() != null) {
                        props.put("uniquename", mcell.getUniqueName());
                    }
                    if (mcell.getHierarchy() != null) {
                        props.put("hierarchy", mcell.getHierarchy());
                    }
                    if (mcell.getLevel() != null) {
                        props.put("level", mcell.getLevel());
                    }
                }
                if ("row_header_header".equals(mcell.getProperty("__headertype"))) {
                    headertype = Cell.Type.ROW_HEADER_HEADER;
                }
                return new Cell("" + mcell.getFormattedValue(), props, headertype);
            }
        }
        return null;
    }
}

