/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.test;

import de.statspez.pleditor.generator.parser.speclanguage.Scanner;
import java.io.StringReader;
import java_cup.runtime.Symbol;
import junit.framework.TestCase;

public class ScannerTest
extends TestCase {
    private Scanner scanner = null;

    public ScannerTest(String arg0) {
        super(arg0);
    }

    public void test_01_bezeichner() throws Exception {
        String test = "foo bar foo123 foo123bar foo_bar _foo";
        String[] expected = new String[]{"foo", "bar", "foo123", "foo123bar", "foo_bar", "_foo"};
        this.scanner.yyreset(new StringReader(test));
        Symbol sym = null;
        int i = 0;
        while (i < expected.length) {
            sym = this.scanner.next_token();
            ScannerTest.assertNotNull((Object)sym);
            ScannerTest.assertEquals((int)89, (int)sym.sym);
            ScannerTest.assertEquals((Object)expected[i], (Object)sym.value);
            ++i;
        }
    }

    public void test_02_zahl() throws Exception {
        String test = "123 123.456";
        int[] expectedSym = new int[]{91, 90};
        String[] expectedVal = new String[]{"123", "123.456"};
        this.scanner.yyreset(new StringReader(test));
        Symbol sym = null;
        int i = 0;
        while (i < expectedSym.length) {
            sym = this.scanner.next_token();
            ScannerTest.assertNotNull((Object)sym);
            ScannerTest.assertEquals((int)expectedSym[i], (int)sym.sym);
            ScannerTest.assertEquals((Object)expectedVal[i], (Object)sym.value);
            ++i;
        }
    }

    public void test_03_keywords() throws Exception {
        String test = "WIEDERHOLE FUER JEDES VON BIS SCHRITTWEITE SOLANGE WENN DANN SONST ENDE PRUEFE FEHLER ABBRUCH RUECKGABE GIB AUS MATERIAL VAR";
        int[] expected = new int[]{36, 15, 21, 33, 6, 27, 28, 35, 7, 29, 10, 24, 14, 2, 26, 17, 5, 22, 32};
        this.scanner.yyreset(new StringReader(test));
        Symbol sym = null;
        int i = 0;
        while (i < expected.length) {
            sym = this.scanner.next_token();
            ScannerTest.assertNotNull((Object)sym);
            ScannerTest.assertEquals((int)expected[i], (int)sym.sym);
            ++i;
        }
    }

    public void test_04_operators() throws Exception {
        String test = "* / + - < > /= >= <= IN UND ODER NICHT";
        int[] expected = new int[]{66, 58, 70, 65, 64, 61, 68, 60, 63, 62, 71, 69, 67};
        this.scanner.yyreset(new StringReader(test));
        Symbol sym = null;
        int i = 0;
        while (i < expected.length) {
            sym = this.scanner.next_token();
            ScannerTest.assertNotNull((Object)sym);
            ScannerTest.assertEquals((int)expected[i], (int)sym.sym);
            ++i;
        }
    }

    public void test_05_otherTerminals() throws Exception {
        String test = ", ; .. := ( [ ) ] -- -+ +- ++ { } & .";
        int[] expected = new int[]{74, 87, 88, 73, 82, 80, 86, 84, 76, 77, 78, 79, 81, 85, 72, 83};
        this.scanner.yyreset(new StringReader(test));
        Symbol sym = null;
        int i = 0;
        while (i < expected.length) {
            sym = this.scanner.next_token();
            ScannerTest.assertNotNull((Object)sym);
            ScannerTest.assertEquals((int)expected[i], (int)sym.sym);
            ++i;
        }
    }

    public void test_06_strings() throws Exception {
        String test = "'Dies ist eine Zeichenkette' 'eine andere Zeichenkette''Eine Zeichenkette mit \\'' 'noch mal \\'text in anfuehrungszeichen\\' '";
        String[] expected = new String[]{"Dies ist eine Zeichenkette", "eine andere Zeichenkette", "Eine Zeichenkette mit '", "noch mal 'text in anfuehrungszeichen' "};
        this.scanner.yyreset(new StringReader(test));
        Symbol sym = null;
        int i = 0;
        while (i < expected.length) {
            sym = this.scanner.next_token();
            ScannerTest.assertNotNull((Object)sym);
            ScannerTest.assertEquals((int)92, (int)sym.sym);
            ScannerTest.assertEquals((Object)expected[i], (Object)sym.value);
            ++i;
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.scanner = new Scanner(new StringReader(""));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.scanner.yyclose();
    }
}

