/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.MessageContextInterface;
import de.statspez.pleditor.generator.meta.ILTypes;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.parser.speclanguage.Parser;
import de.statspez.pleditor.generator.parser.speclanguage.Scanner;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class Helper {
    public static boolean toBoolean(String aString) {
        if (aString.equalsIgnoreCase("1")) {
            return true;
        }
        if (aString.equalsIgnoreCase("0")) {
            return false;
        }
        throw new IllegalArgumentException("Ungueltiger boolscher Wert '" + aString + "'");
    }

    public static MetaProgram metaStructureFor(String program) {
        Scanner scanner = new Scanner(new StringReader(program));
        return (MetaProgram)Parser.parse(scanner);
    }

    public static MetaProgram metaStructureFor(MessageContextInterface context, String program) {
        Scanner scanner = new Scanner(new StringReader(program));
        scanner.setContext(context);
        return (MetaProgram)Parser.parse(context, scanner);
    }

    public static int[] parseDimensionSpec(String dimensionSpec) {
        StringTokenizer tokens = new StringTokenizer(dimensionSpec, ",");
        int[] result = new int[tokens.countTokens()];
        int i = 0;
        while (i < result.length) {
            String dim = tokens.nextToken().trim();
            if (dim.length() == 0) {
                throw new IllegalArgumentException("Ung\u00fcltige Dimensionsangabe: " + dimensionSpec);
            }
            if (dim.equals("N")) {
                result[i] = -1;
            } else {
                try {
                    result[i] = Integer.parseInt(dim);
                    if (result[i] < 1) {
                        throw new IllegalArgumentException("Ung\u00fcltige Dimensionsangabe: " + dimensionSpec);
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Ung\u00fcltige Dimensionsangabe: " + dimensionSpec);
                }
            }
            ++i;
        }
        return result;
    }

    public static short typeByName(String name) {
        if ("zahl".equalsIgnoreCase(name)) {
            return 1;
        }
        if ("kategorie".equalsIgnoreCase(name)) {
            return 6;
        }
        int i = 0;
        while (i < ILTypes.TYPE_NAMES.length) {
            if (ILTypes.TYPE_NAMES[i].equalsIgnoreCase(name)) {
                return (short)(i + 1);
            }
            ++i;
        }
        throw new IllegalArgumentException("Ungueltiger Typ '" + name + "'");
    }

    public static MetaProgram getFehlerTextAlsMetaProgram(String fehlerText, MessageContextInterface context) throws IllegalArgumentException {
        MetaProgram result;
        String resultString = Helper.getFehlerTextAlsProgramString(fehlerText, context);
        if (resultString != null) {
            result = Helper.metaStructureFor(context, resultString);
            if (result.containsHierarchicalFunction()) {
                throw new IllegalArgumentException("Fehlertext darf keine hierarchischen Spezifikationen enthalten.");
            }
        } else {
            result = null;
        }
        return result;
    }

    public static String getFehlerTextAlsProgramString(String fehlerText, MessageContextInterface context) throws IllegalArgumentException {
        String[] zeilen = Helper.getZeilenArray(fehlerText);
        StringBuffer fehlerTextNeu = new StringBuffer();
        boolean templateFound = false;
        int i = 0;
        while (i < zeilen.length) {
            StringBuffer uebersetzung;
            if (i > 0) {
                fehlerTextNeu.append(' ');
            }
            if (Helper.uebersetzeZeile(zeilen[i], uebersetzung = new StringBuffer())) {
                templateFound = true;
            }
            fehlerTextNeu.append(uebersetzung);
            ++i;
        }
        return templateFound ? fehlerTextNeu.toString() : null;
    }

    private static String[] getZeilenArray(String text) {
        Vector<String> result = new Vector<String>();
        StringBuffer zeile = new StringBuffer();
        char[] chars = text.toCharArray();
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '\n': {
                    result.add(zeile.toString());
                    zeile = new StringBuffer();
                    break;
                }
                default: {
                    zeile.append(chars[i]);
                }
            }
            ++i;
        }
        if (zeile.length() > 0) {
            result.add(zeile.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    private static boolean uebersetzeZeile(String fehlerText, StringBuffer uebersetzung) throws IllegalArgumentException {
        boolean templateFound = false;
        if (fehlerText != null && fehlerText.length() > 0) {
            char[] chars = fehlerText.toCharArray();
            uebersetzung.append("GIB ");
            boolean started = false;
            boolean closeText = false;
            boolean closeTemplate = false;
            int i = 0;
            while (i < chars.length) {
                switch (chars[i]) {
                    case '$': {
                        if (i < chars.length - 1 && chars[i + 1] == '$') {
                            ++i;
                        } else {
                            started = true;
                            if (closeTemplate) {
                                closeTemplate = false;
                                break;
                            }
                            if (closeText) {
                                uebersetzung.append("', ");
                                closeText = false;
                            }
                            closeTemplate = true;
                            templateFound = true;
                            break;
                        }
                    }
                    default: {
                        if (!closeText && !closeTemplate) {
                            if (started) {
                                uebersetzung.append(", ");
                            } else {
                                started = true;
                            }
                            uebersetzung.append('\'');
                            closeText = true;
                        }
                        if (chars[i] == '\'') {
                            uebersetzung.append('\"');
                            break;
                        }
                        uebersetzung.append(chars[i]);
                    }
                }
                ++i;
            }
            if (closeTemplate) {
                throw new IllegalArgumentException("Das Einf\u00fcgen von Werten muss vom Zeichen '$' umschlossen werden.");
            }
            if (closeText) {
                uebersetzung.append('\'');
            }
            uebersetzung.append(" AUS");
        }
        return templateFound;
    }
}

