/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.doku;

import de.statspez.pleditor.generator.codegen.doku.AbstractStat;
import de.statspez.pleditor.generator.codegen.doku.DokuElement;
import de.statspez.pleditor.generator.codegen.doku.ReferenceGetter;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaKeywordLocation;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.parser.Helper;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class PruefungStat
extends AbstractStat {
    private HashSet imputationChecks = new HashSet();
    private HashSet mandatoryChecks = new HashSet();
    private HashSet noCorrectionOrErrorText = new HashSet();
    private HashSet optionalChecks = new HashSet();
    private HashSet referencedFieldContexts = new HashSet();
    private ArrayList automaticVerificationList = null;
    private ArrayList errorVerificationList = null;
    private ArrayList manualVerificationList = null;
    private ArrayList noCorrectionOrErrorTextList = null;
    private ArrayList warningVerificationList = null;

    @Override
    public void add(MetaStatspezObjekt pruefung) {
        MetaCustomPruefung p = (MetaCustomPruefung)pruefung;
        if (!this.idElementTable.containsKey(p.getId())) {
            boolean keinKorrekturHinweis;
            DokuElement de = new DokuElement(p.getId(), p.getName());
            de.setElement(p);
            this.idElementTable.put(p.getId(), de);
            if (p.getKommentar() != null && p.getKommentar().trim().length() > 0) {
                this.addToWithAnnotation(p.getId());
            }
            boolean manuell = p.getPruefungsart() == 1 || p.getPruefungsart() == 2;
            boolean keinFehlerText = p.getFehlertextKurz().trim().length() == 0 && p.getFehlertextLang().trim().length() == 0;
            boolean bl = keinKorrekturHinweis = p.getKorrekturhinweis().trim().length() == 0;
            if (manuell && (keinFehlerText || keinKorrekturHinweis)) {
                this.addToNoCorrectionOrErrorText(pruefung.getId());
            }
            switch (p.getPruefungsart()) {
                case 1: {
                    this.mandatoryChecks.add(p.getId());
                    break;
                }
                case 2: {
                    this.optionalChecks.add(p.getId());
                    break;
                }
                case 3: {
                    this.imputationChecks.add(p.getId());
                }
            }
            if (p.getFreigabeStatus() == 0) {
                this.addToLocked(p.getId());
            }
            ReferenceGetter rg = new ReferenceGetter();
            rg.generateReferencedSet(p);
            this.referencedFieldContexts.addAll(rg.getFeldNamen());
            if (!p.istKompilierbar()) {
                this.fehlerHafteElemente.add(de);
                de.setZusatz("fehlerhaft");
            }
        }
    }

    public boolean addToNoCorrectionOrErrorText(String id) {
        return this.noCorrectionOrErrorText.add(id);
    }

    public int getAutomaticVerificationChecksCount() {
        return this.imputationChecks.size();
    }

    public List getAutomaticVerificationList() {
        if (this.automaticVerificationList == null) {
            return this.resolveIds(this.imputationChecks);
        }
        return this.automaticVerificationList;
    }

    public int getErrorVerificationChecksCount() {
        return this.mandatoryChecks.size() + this.imputationChecks.size();
    }

    public List getErrorVerificationList() {
        if (this.errorVerificationList == null) {
            ArrayList tmpList = new ArrayList();
            tmpList.addAll(this.resolveIds(this.mandatoryChecks));
            tmpList.addAll(this.resolveIds(this.imputationChecks));
            return tmpList;
        }
        return this.errorVerificationList;
    }

    public int getManualVerificationChecksCount() {
        return this.mandatoryChecks.size() + this.optionalChecks.size();
    }

    public List getManualVerificationList() {
        if (this.noCorrectionOrErrorTextList == null) {
            ArrayList tmpList = new ArrayList();
            tmpList.addAll(this.resolveIds(this.mandatoryChecks));
            tmpList.addAll(this.resolveIds(this.optionalChecks));
            return tmpList;
        }
        return this.noCorrectionOrErrorTextList;
    }

    public String[] splitConditionalStatement(String conditionalStatement) {
        String[] result = null;
        MetaProgram metaProgramm = Helper.metaStructureFor(conditionalStatement);
        MetaStatementSequence statementSequence = metaProgramm.statements();
        if (statementSequence.numberOfStatements() == 1 && statementSequence.statementAt(0) instanceof MetaConditionalStatement) {
            MetaConditionalStatement ifThenElseStatement = (MetaConditionalStatement)statementSequence.statementAt(0);
            MetaKeywordLocation thenLocation = ifThenElseStatement.getThenLocation();
            int startColumn = thenLocation.getStartColumn();
            int lineNr = thenLocation.getEndLine();
            try {
                String bedingung = null;
                String anweisung = null;
                InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(conditionalStatement.getBytes()));
                LineNumberReader lineNumberReader = new LineNumberReader(reader);
                int startAnweisung = 0;
                int i = 0;
                while (i < lineNr) {
                    String line = lineNumberReader.readLine();
                    if (i < lineNr - 1) {
                        startAnweisung += line.length();
                        ++startAnweisung;
                    } else if (startColumn > 1) {
                        startAnweisung += startColumn - 1;
                    }
                    ++i;
                }
                bedingung = conditionalStatement.substring("WENN".length(), startAnweisung).trim();
                MetaStatementSequence ifTrueStatementSequence = ifThenElseStatement.ifTrue();
                lineNr = ifTrueStatementSequence.endLine();
                int endAnweisung = 0;
                reader = new InputStreamReader(new ByteArrayInputStream(conditionalStatement.getBytes()));
                lineNumberReader = new LineNumberReader(reader);
                int i2 = 0;
                while (i2 < lineNr) {
                    String line = lineNumberReader.readLine();
                    if (i2 < lineNr - 1) {
                        endAnweisung += line.length();
                        ++endAnweisung;
                    } else if (startColumn > 1) {
                        endAnweisung += ifTrueStatementSequence.endColumn() - 1;
                    }
                    ++i2;
                }
                anweisung = conditionalStatement.substring(startAnweisung + "DANN".length(), endAnweisung).trim();
                result = new String[]{bedingung, anweisung};
            }
            catch (Exception e) {
                e.printStackTrace();
                result = null;
            }
        }
        return result;
    }

    public HashSet getNoCorrectionOrErrorText() {
        return this.noCorrectionOrErrorText;
    }

    public int getNoCorrectionOrErrorTextCount() {
        return this.noCorrectionOrErrorText.size();
    }

    public List getNoCorrectionOrErrorTextList() {
        if (this.noCorrectionOrErrorTextList == null) {
            return this.resolveIds(this.noCorrectionOrErrorText);
        }
        return this.noCorrectionOrErrorTextList;
    }

    public HashSet getReferencedFieldContexts() {
        return this.referencedFieldContexts;
    }

    public List getWarningVerificationList() {
        if (this.warningVerificationList == null) {
            return this.resolveIds(this.optionalChecks);
        }
        return this.warningVerificationList;
    }

    public int getWarninigVerificationChecksCount() {
        return this.optionalChecks.size();
    }

    @Override
    public void initializeLists() {
        this.initializeLists(false);
    }

    @Override
    public void initializeLists(boolean force) {
        if (this.noCorrectionOrErrorTextList == null | force) {
            this.noCorrectionOrErrorTextList = new ArrayList();
            this.noCorrectionOrErrorTextList.addAll(this.resolveIds(this.noCorrectionOrErrorText));
        }
        if (this.automaticVerificationList == null | force) {
            this.automaticVerificationList = new ArrayList();
            this.automaticVerificationList.addAll(this.resolveIds(this.imputationChecks));
        }
        if (this.manualVerificationList == null | force) {
            this.manualVerificationList = new ArrayList();
            this.manualVerificationList.addAll(this.resolveIds(this.mandatoryChecks));
            this.manualVerificationList.addAll(this.resolveIds(this.optionalChecks));
        }
        if (this.errorVerificationList == null | force) {
            this.errorVerificationList = new ArrayList();
            this.errorVerificationList.addAll(this.resolveIds(this.mandatoryChecks));
            this.errorVerificationList.addAll(this.resolveIds(this.imputationChecks));
        }
        if (this.warningVerificationList == null | force) {
            this.warningVerificationList = new ArrayList();
            this.warningVerificationList.addAll(this.resolveIds(this.optionalChecks));
        }
        super.initializeLists(force);
    }

    @Override
    public void sortLists() {
        this.sortLists(null);
    }

    public void sortLists(List folge) {
        if (folge == null) {
            this.initializeLists();
            Collections.sort(this.noCorrectionOrErrorTextList);
            super.sortListsOnly();
        } else {
            this.elementList = new ArrayList();
            this.lockedList = new ArrayList();
            this.withAnnotationList = new ArrayList();
            this.referencedList = new ArrayList();
            this.noChecksList = new ArrayList();
            this.noCorrectionOrErrorTextList = new ArrayList();
            this.automaticVerificationList = new ArrayList();
            this.manualVerificationList = new ArrayList();
            this.errorVerificationList = new ArrayList();
            this.warningVerificationList = new ArrayList();
            Iterator it = folge.iterator();
            while (it.hasNext()) {
                DokuElement aktPruefung = this.getElement((String)it.next());
                this.elementList.add(aktPruefung);
                if (this.locked.contains(aktPruefung)) {
                    this.lockedList.add(aktPruefung);
                }
                if (this.withAnnotation.contains(aktPruefung)) {
                    this.withAnnotationList.add(aktPruefung);
                }
                if (this.referenced.contains(aktPruefung)) {
                    this.referencedList.add(aktPruefung);
                }
                if (this.noChecks.contains(aktPruefung)) {
                    this.noChecksList.add(aktPruefung);
                }
                if (this.noCorrectionOrErrorText.contains(aktPruefung)) {
                    this.noCorrectionOrErrorTextList.add(aktPruefung);
                }
                if (this.imputationChecks.contains(aktPruefung)) {
                    this.automaticVerificationList.add(aktPruefung);
                }
                if (this.mandatoryChecks.contains(aktPruefung) || this.optionalChecks.contains(aktPruefung)) {
                    this.manualVerificationList.add(aktPruefung);
                }
                if (this.mandatoryChecks.contains(aktPruefung) || this.imputationChecks.contains(aktPruefung)) {
                    this.errorVerificationList.add(aktPruefung);
                }
                if (!this.optionalChecks.contains(aktPruefung)) continue;
                this.warningVerificationList.add(aktPruefung);
            }
        }
    }
}

