/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.diff;

import de.statspez.pleditor.generator.codegen.diff.DiffConfig;
import de.statspez.pleditor.generator.codegen.diff.DiffResult;
import de.statspez.pleditor.generator.codegen.diff.DiffResultTree;
import de.statspez.pleditor.generator.codegen.diff.DiffResultTreeNode;
import de.statspez.pleditor.generator.codegen.diff.DiffStructure;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import java.util.LinkedList;
import java.util.List;

public final class DiffResultContainer {
    private DiffConfig diffConfig = null;
    private DiffResultTree diffResultTree = null;
    private DiffStructure diffStructure1 = null;
    private DiffStructure diffStructure2 = null;

    DiffResultContainer(DiffStructure diffStructure1, DiffStructure diffStructure2) {
        if (diffStructure1 == null || diffStructure2 == null) {
            throw new NullPointerException();
        }
        this.diffStructure1 = diffStructure1;
        this.diffStructure2 = diffStructure2;
    }

    public final String getAllDiffDescription() {
        return this.getDiffDescription(this.diffResultTree.getRootContext());
    }

    public final List getAllDiffResults() {
        return this.getDiffResults(this.diffResultTree.getRootContext());
    }

    public final DiffConfig getDiffConfig() {
        return this.diffConfig;
    }

    public final String getDiffDescription(String context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (context.equals("")) {
            throw new IllegalArgumentException("Der Kontext darf nicht leer sein!");
        }
        String ln = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        LinkedList<DiffResultTreeNode> elements = new LinkedList<DiffResultTreeNode>();
        elements.add(this.diffResultTree.getNode(context));
        elements.addAll(this.diffResultTree.getNodeChildren(context));
        for (DiffResultTreeNode node : elements) {
            List diffs = node.getDiffResults();
            for (DiffResult diffResult : diffs) {
                if (!(node.getParent() == null || node.getParent().equals(this.diffResultTree.getRootTBContextNode()) || node.getParent().equals(this.diffResultTree.getGlobalContextNode()) || node.getParent().equals(this.diffResultTree.getRootNode()))) {
                    String parentContext = node.getParent().getContext();
                    int index = parentContext.indexOf("___PKT___");
                    index = parentContext.indexOf("___PKT___", index + "___PKT___".length());
                    parentContext = parentContext.substring(index + "___PKT___".length(), parentContext.length());
                    buffer.append(parentContext);
                    buffer.append(": ");
                }
                buffer.append(diffResult.getDiffDescription());
                buffer.append(ln);
            }
        }
        return buffer.toString();
    }

    public final List getDiffResults(String context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (context.equals("")) {
            throw new IllegalArgumentException("Der Kontext darf nicht leer sein!");
        }
        LinkedList diffResults = new LinkedList();
        if (this.diffResultTree != null) {
            LinkedList<DiffResultTreeNode> children = new LinkedList<DiffResultTreeNode>();
            children.add(this.diffResultTree.getNode(context));
            children.addAll(this.diffResultTree.getNodeChildren(context));
            for (DiffResultTreeNode node : children) {
                List diffs = node.getDiffResults();
                diffResults.addAll(diffs);
            }
        }
        return diffResults;
    }

    public final DiffResultTree getDiffResultTree() {
        return this.diffResultTree;
    }

    public final String getGlobalDiffDescription() {
        return this.getDiffDescription(this.diffResultTree.getPlausiContext());
    }

    public final List getGlobalDiffResults() {
        return this.getDiffResults(this.diffResultTree.getPlausiContext());
    }

    public final MetaCustomPlausibilisierung getPlausi1() {
        return this.diffStructure1.getMetaPlausibilisierung();
    }

    public final MetaCustomPlausibilisierung getPlausi2() {
        return this.diffStructure2.getMetaPlausibilisierung();
    }

    public final String getStructureDiffDescription() {
        return this.getDiffDescription(this.diffResultTree.getPLStrukturContext());
    }

    public final List getStructureDiffResults() {
        return this.getDiffResults(this.diffResultTree.getPLStrukturContext());
    }

    public final void setDiffConfig(DiffConfig diffConfig) {
        this.diffConfig = diffConfig;
    }

    void setDiffResultTree(DiffResultTree diffResultTree) {
        if (diffResultTree == null) {
            throw new NullPointerException();
        }
        this.diffResultTree = diffResultTree;
    }
}

