/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.cpp;

import de.statspez.pleditor.generator.codegen.cpp.CppProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.ClassificationRegKeyBuilder;
import de.statspez.pleditor.generator.codegen.support.HelperVisitor;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptor;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaBoolean;
import de.statspez.pleditor.generator.meta.MetaClassificationReference;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaNoValue;
import de.statspez.pleditor.generator.meta.MetaNumber;
import de.statspez.pleditor.generator.meta.MetaString;

class CppGetValueStrategy
extends HelperVisitor {
    public static final int NODE_REF_STRATEGY = 0;
    public static final int VALUE_STRATEGY = 1;
    public static final int STRING_STRATEGY = 2;
    public static final int BOOL_STRATEGY = 3;
    public static final int INTEGER_STRATEGY = 4;
    public static final int REAL_STRATEGY = 5;
    private int strategy;
    private String derefPrefix;
    private String derefMethod;

    public CppGetValueStrategy(int strategy, CppProgramCodeGenerator generator) {
        super(generator);
        this.strategy = strategy;
        switch (strategy) {
            case 0: {
                this.derefPrefix = "";
                this.derefMethod = "";
                break;
            }
            case 1: {
                this.derefPrefix = "->get(context)";
                this.derefMethod = "";
                break;
            }
            case 2: {
                this.derefPrefix = "->get(context)";
                this.derefMethod = "->asString()";
                break;
            }
            case 3: {
                this.derefPrefix = "->get(context)";
                this.derefMethod = "->asBool()";
                break;
            }
            case 4: {
                this.derefPrefix = "->get(context)";
                this.derefMethod = "->asInteger()";
                break;
            }
            case 5: {
                this.derefPrefix = "->get(context)";
                this.derefMethod = "->asReal()";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unzulaessige Strategie.");
            }
        }
    }

    @Override
    public void visitFieldAccess(MetaFieldAccess anAccess) {
        if (!this.scope().isDefined(anAccess.accessedField(), this.namespace())) {
            this.error(anAccess, String.valueOf(anAccess.accessedField().toString()) + " ist nicht in diesem Gueltigkeitsbereich definiert " + "(Scope: " + this.namespace() + ")");
            return;
        }
        SymbolDescriptor sd = this.scope().symbolDescriptor(anAccess.accessedField(), this.namespace());
        if (sd.isLokaleVariable()) {
            this.out().print("(&");
        }
        this.out().print(StringHelper.getEscapedName(anAccess.accessedField().value()));
        if (sd.isLokaleVariable()) {
            this.out().print(")");
        }
        this.out().print(this.derefPrefix);
        this.out().print(this.derefMethod);
    }

    @Override
    public void visitArrayAccess(MetaArrayAccess anAccess) {
        this.out().print(this.derefPrefix);
        this.out().print(this.derefMethod);
    }

    @Override
    public void visitClassificationReference(MetaClassificationReference anAccess) {
        ClassificationRegKeyBuilder keyBuilder = new ClassificationRegKeyBuilder();
        anAccess.accept(keyBuilder);
        String regKey = keyBuilder.regKey();
        if (anAccess.referenceByCode()) {
            this.out().print("context->getClassificationByCode");
        } else {
            this.out().print("context->getClassificationByValue");
        }
        this.out().print("(\"");
        this.out().print(regKey);
        this.out().print("\")");
        this.out().print(this.derefMethod);
    }

    @Override
    public void visitLiteralAccess(MetaLiteralAccess anAccess) {
        anAccess.accessedLiteral().accept(this);
    }

    @Override
    public void visitNumber(MetaNumber aNumber) {
        if (this.strategy == 4) {
            this.out().print(aNumber.value().longValue());
        } else if (this.strategy == 5) {
            this.out().print(aNumber.value());
        } else {
            this.out().print("context->createNumberValue(");
            this.out().print(aNumber.value());
            this.out().print(")");
            this.out().print(this.derefMethod);
        }
    }

    @Override
    public void visitBoolean(MetaBoolean aBoolean) {
        if (this.strategy == 3) {
            this.out().print(aBoolean.value());
        } else {
            if (aBoolean.value().equals(Boolean.TRUE)) {
                this.out().print("context->createBoolValue(PL_TRUE)");
            } else {
                this.out().print("context->createBoolValue(PL_FALSE)");
            }
            this.out().print(this.derefMethod);
        }
    }

    @Override
    public void visitString(MetaString aString) {
        if (this.strategy == 2) {
            this.out().print("\"");
            this.out().print(StringHelper.getEscapedStringValue(aString.value()));
            this.out().print("\"");
        } else {
            this.out().print("context->createStringValue(\"");
            this.out().print(StringHelper.getEscapedStringValue(aString.value()));
            this.out().print("\")");
            this.out().print(this.derefMethod);
        }
    }

    @Override
    public void visitNoValue(MetaNoValue noValue) {
        this.out().print("context->createInvalidValue()");
        this.out().print(this.derefMethod);
    }
}

