/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.recorder.MessageRecorder;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapStar;
import mondrian.rolap.aggmatcher.ExplicitRecognizer;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.rolap.aggmatcher.Recognizer;
import org.apache.log4j.Logger;

public class ExplicitRules {
    private static final Logger LOGGER = Logger.getLogger(ExplicitRules.class);
    private static final MondrianResource mres = MondrianResource.instance();

    public static boolean excludeTable(String tableName, List<Group> aggGroups) {
        for (Group group : aggGroups) {
            if (!group.excludeTable(tableName)) continue;
            return true;
        }
        return false;
    }

    public static TableDef getIncludeByTableDef(String tableName, List<Group> aggGroups) {
        for (Group group : aggGroups) {
            TableDef tableDef = group.getIncludeByTableDef(tableName);
            if (tableDef == null) continue;
            return tableDef;
        }
        return null;
    }

    private static Exclude make(MondrianDef.AggExclude aggExclude) {
        return aggExclude.getNameAttribute() != null ? new ExcludeName(aggExclude.getNameAttribute(), aggExclude.isIgnoreCase()) : new ExcludePattern(aggExclude.getPattern(), aggExclude.isIgnoreCase());
    }

    private static void checkAttributeString(MessageRecorder msgRecorder, String attrValue, String attrName) {
        if (attrValue == null) {
            msgRecorder.reportError(ExplicitRules.mres.NullAttributeString.str(msgRecorder.getContext(), attrName));
        } else if (attrValue.length() == 0) {
            msgRecorder.reportError(ExplicitRules.mres.EmptyAttributeString.str(msgRecorder.getContext(), attrName));
        }
    }

    private ExplicitRules() {
    }

    public static class PatternTableDef
    extends TableDef {
        private final Pattern pattern;
        private List<Exclude> excludes;

        static PatternTableDef make(MondrianDef.AggPattern aggPattern, Group group) {
            PatternTableDef pattern = new PatternTableDef(aggPattern.getPattern(), aggPattern.isIgnoreCase(), group);
            MondrianDef.AggExclude[] excludes = aggPattern.getAggExcludes();
            if (excludes != null) {
                for (MondrianDef.AggExclude exclude1 : excludes) {
                    Exclude exclude = ExplicitRules.make(exclude1);
                    pattern.add(exclude);
                }
            }
            TableDef.add((TableDef)pattern, aggPattern);
            return pattern;
        }

        public PatternTableDef(String pattern, boolean ignoreCase, Group group) {
            super(ignoreCase, group);
            this.pattern = this.ignoreCase ? Pattern.compile(pattern, 2) : Pattern.compile(pattern);
            this.excludes = Collections.emptyList();
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public List<Exclude> getExcludes() {
            return this.excludes;
        }

        private void add(Exclude exclude) {
            if (this.excludes == Collections.EMPTY_LIST) {
                this.excludes = new ArrayList<Exclude>();
            }
            this.excludes.add(exclude);
        }

        @Override
        public boolean matches(String tableName) {
            if (!this.pattern.matcher(tableName).matches()) {
                return false;
            }
            for (Exclude exclude : this.getExcludes()) {
                if (!exclude.isExcluded(tableName)) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void validate(MessageRecorder msgRecorder) {
            msgRecorder.pushContextName("PatternTableDef");
            try {
                ExplicitRules.checkAttributeString(msgRecorder, this.pattern.pattern(), "pattern");
                for (Exclude exclude : this.getExcludes()) {
                    exclude.validate(msgRecorder);
                }
                super.validate(msgRecorder);
            }
            finally {
                msgRecorder.popContextName();
            }
        }

        @Override
        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("ExplicitRules.PatternTableDef:");
            super.print(pw, prefix);
            String subprefix = prefix + "  ";
            String subsubprefix = subprefix + "  ";
            pw.print(subprefix);
            pw.print("pattern=");
            pw.print(this.pattern.pattern());
            pw.print(":");
            pw.println(this.pattern.flags());
            pw.print(subprefix);
            pw.println("Excludes: [");
            for (Exclude exclude : this.excludes) {
                exclude.print(pw, subsubprefix);
            }
            pw.print(subprefix);
            pw.println("]");
        }
    }

    static class NameTableDef
    extends TableDef {
        private final String name;

        static NameTableDef make(MondrianDef.AggName aggName, Group group) {
            NameTableDef name = new NameTableDef(aggName.getNameAttribute(), aggName.getApproxRowCountAttribute(), aggName.isIgnoreCase(), group);
            TableDef.add((TableDef)name, aggName);
            return name;
        }

        public NameTableDef(String name, String approxRowCount, boolean ignoreCase, Group group) {
            super(ignoreCase, group);
            this.name = name;
            this.approxRowCount = this.loadApproxRowCount(approxRowCount);
        }

        private int loadApproxRowCount(String approxRowCount) {
            boolean notNullAndNumeric;
            boolean bl = notNullAndNumeric = approxRowCount != null && approxRowCount.matches("^\\d+$");
            if (notNullAndNumeric) {
                return Integer.parseInt(approxRowCount);
            }
            return Integer.MIN_VALUE;
        }

        @Override
        public boolean matches(String tableName) {
            return this.ignoreCase ? this.name.equalsIgnoreCase(tableName) : this.name.equals(tableName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void validate(MessageRecorder msgRecorder) {
            msgRecorder.pushContextName("NameTableDef");
            try {
                ExplicitRules.checkAttributeString(msgRecorder, this.name, "name");
                super.validate(msgRecorder);
            }
            finally {
                msgRecorder.popContextName();
            }
        }

        @Override
        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("ExplicitRules.NameTableDef:");
            super.print(pw, prefix);
            String subprefix = prefix + "  ";
            pw.print(subprefix);
            pw.print("name=");
            pw.println(this.name);
        }
    }

    public static abstract class TableDef {
        private static int idCount = 0;
        protected final int id;
        protected final boolean ignoreCase;
        protected final Group aggGroup;
        protected String factCountName;
        protected List<String> ignoreColumnNames;
        private Map<String, String> foreignKeyMap;
        private List<Level> levels;
        private List<Measure> measures;
        protected int approxRowCount = Integer.MIN_VALUE;

        static TableDef make(MondrianDef.AggTable aggTable, Group group) {
            return aggTable instanceof MondrianDef.AggName ? NameTableDef.make((MondrianDef.AggName)aggTable, group) : PatternTableDef.make((MondrianDef.AggPattern)aggTable, group);
        }

        private static void add(TableDef tableDef, MondrianDef.AggTable aggTable) {
            MondrianDef.AggLevel[] levels;
            MondrianDef.AggMeasure[] measures;
            MondrianDef.AggForeignKey[] fks;
            MondrianDef.AggIgnoreColumn[] ignores;
            if (aggTable.getAggFactCount() != null) {
                tableDef.setFactCountName(aggTable.getAggFactCount().getColumnName());
            }
            if ((ignores = aggTable.getAggIgnoreColumns()) != null) {
                for (MondrianDef.AggIgnoreColumn ignore : ignores) {
                    tableDef.addIgnoreColumnName(ignore.getColumnName());
                }
            }
            if ((fks = aggTable.getAggForeignKeys()) != null) {
                for (MondrianDef.AggForeignKey fk : fks) {
                    tableDef.addFK(fk);
                }
            }
            if ((measures = aggTable.getAggMeasures()) != null) {
                for (MondrianDef.AggMeasure measure : measures) {
                    TableDef.addTo(tableDef, measure);
                }
            }
            if ((levels = aggTable.getAggLevels()) != null) {
                for (MondrianDef.AggLevel level : levels) {
                    TableDef.addTo(tableDef, level);
                }
            }
        }

        private static void addTo(TableDef tableDef, MondrianDef.AggLevel aggLevel) {
            TableDef.addLevelTo(tableDef, aggLevel.getNameAttribute(), aggLevel.getColumnName(), aggLevel.isCollapsed());
        }

        private static void addTo(TableDef tableDef, MondrianDef.AggMeasure aggMeasure) {
            TableDef.addMeasureTo(tableDef, aggMeasure.getNameAttribute(), aggMeasure.getColumn());
        }

        public static void addLevelTo(TableDef tableDef, String name, String columnName, boolean collapsed) {
            TableDef tableDef2 = tableDef;
            tableDef2.getClass();
            Level level = tableDef2.new Level(name, columnName, collapsed);
            tableDef.add(level);
        }

        public static void addMeasureTo(TableDef tableDef, String name, String column) {
            TableDef tableDef2 = tableDef;
            tableDef2.getClass();
            Measure measure = tableDef2.new Measure(name, column);
            tableDef.add(measure);
        }

        private static int nextId() {
            return idCount++;
        }

        protected TableDef(boolean ignoreCase, Group aggGroup) {
            this.id = TableDef.nextId();
            this.ignoreCase = ignoreCase;
            this.aggGroup = aggGroup;
            this.foreignKeyMap = Collections.emptyMap();
            this.levels = Collections.emptyList();
            this.measures = Collections.emptyList();
            this.ignoreColumnNames = Collections.emptyList();
        }

        public int getApproxRowCount() {
            return this.approxRowCount;
        }

        public boolean isIgnoreCase() {
            return this.ignoreCase;
        }

        public RolapStar getStar() {
            return this.getAggGroup().getStar();
        }

        public Group getAggGroup() {
            return this.aggGroup;
        }

        protected String getFactCountName() {
            return this.factCountName;
        }

        protected void setFactCountName(String factCountName) {
            this.factCountName = factCountName;
        }

        protected Iterator<String> getIgnoreColumnNames() {
            return this.ignoreColumnNames.iterator();
        }

        public List<Level> getLevels() {
            return this.levels;
        }

        public List<Measure> getMeasures() {
            return this.measures;
        }

        protected Recognizer.Matcher getIgnoreMatcher() {
            return new Recognizer.Matcher(){

                @Override
                public boolean matches(String name) {
                    Iterator<String> it = TableDef.this.getIgnoreColumnNames();
                    while (it.hasNext()) {
                        String ignoreName = it.next();
                        if (!(TableDef.this.isIgnoreCase() ? ignoreName.equalsIgnoreCase(name) : ignoreName.equals(name))) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        protected Recognizer.Matcher getFactCountMatcher() {
            return new Recognizer.Matcher(){

                @Override
                public boolean matches(String name) {
                    String factCountName = TableDef.this.factCountName;
                    return factCountName != null && factCountName.equalsIgnoreCase(name);
                }
            };
        }

        RolapCube getCube() {
            return this.aggGroup.getCube();
        }

        public boolean columnsOK(RolapStar star, JdbcSchema.Table dbFactTable, JdbcSchema.Table dbTable, MessageRecorder msgRecorder) {
            ExplicitRecognizer cb = new ExplicitRecognizer(this, star, this.getCube(), dbFactTable, dbTable, msgRecorder);
            return cb.check();
        }

        protected void addIgnoreColumnName(String ignoreName) {
            if (this.ignoreColumnNames == Collections.EMPTY_LIST) {
                this.ignoreColumnNames = new ArrayList<String>();
            }
            this.ignoreColumnNames.add(ignoreName);
        }

        protected void addFK(MondrianDef.AggForeignKey fk) {
            if (this.foreignKeyMap == Collections.EMPTY_MAP) {
                this.foreignKeyMap = new HashMap<String, String>();
            }
            this.foreignKeyMap.put(fk.getFactFKColumnName(), fk.getAggregateFKColumnName());
        }

        protected String getAggregateFK(String baseFK) {
            return this.foreignKeyMap.get(baseFK);
        }

        protected void add(Level level) {
            if (this.levels == Collections.EMPTY_LIST) {
                this.levels = new ArrayList<Level>();
            }
            this.levels.add(level);
        }

        protected void add(Measure measure) {
            if (this.measures == Collections.EMPTY_LIST) {
                this.measures = new ArrayList<Measure>();
            }
            this.measures.add(measure);
        }

        public abstract boolean matches(String var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate(MessageRecorder msgRecorder) {
            msgRecorder.pushContextName("TableDef");
            try {
                HashMap<String, Object> namesToObjects = new HashMap<String, Object>();
                HashMap<String, Object> columnsToObjects = new HashMap<String, Object>();
                for (Level level : this.levels) {
                    level.validate(msgRecorder);
                    if (namesToObjects.containsKey(level.getName())) {
                        msgRecorder.reportError(mres.DuplicateLevelNames.str(msgRecorder.getContext(), level.getName()));
                    } else {
                        namesToObjects.put(level.getName(), level);
                    }
                    if (columnsToObjects.containsKey(level.getColumnName())) {
                        Level l = (Level)columnsToObjects.get(level.getColumnName());
                        msgRecorder.reportError(mres.DuplicateLevelColumnNames.str(msgRecorder.getContext(), level.getName(), l.getName(), level.getColumnName()));
                        continue;
                    }
                    columnsToObjects.put(level.getColumnName(), level);
                }
                namesToObjects.clear();
                for (Measure measure : this.measures) {
                    measure.validate(msgRecorder);
                    if (namesToObjects.containsKey(measure.getName())) {
                        msgRecorder.reportError(mres.DuplicateMeasureNames.str(msgRecorder.getContext(), measure.getName()));
                        continue;
                    }
                    namesToObjects.put(measure.getName(), measure);
                    if (columnsToObjects.containsKey(measure.getColumnName())) {
                        Object o = columnsToObjects.get(measure.getColumnName());
                        if (o instanceof Measure) {
                            Measure m = (Measure)o;
                            msgRecorder.reportError(mres.DuplicateMeasureColumnNames.str(msgRecorder.getContext(), measure.getName(), m.getName(), measure.getColumnName()));
                            continue;
                        }
                        Level l = (Level)o;
                        msgRecorder.reportError(mres.DuplicateLevelMeasureColumnNames.str(msgRecorder.getContext(), l.getName(), measure.getName(), measure.getColumnName()));
                        continue;
                    }
                    columnsToObjects.put(measure.getColumnName(), measure);
                }
                namesToObjects.clear();
                columnsToObjects.clear();
                RolapStar star = this.getStar();
                RolapStar.Table factTable = star.getFactTable();
                String tableName = factTable.getAlias();
                for (Map.Entry<String, String> e : this.foreignKeyMap.entrySet()) {
                    MondrianDef.Column c;
                    String baseFKName = e.getKey();
                    String aggFKName = e.getValue();
                    if (namesToObjects.containsKey(baseFKName)) {
                        msgRecorder.reportError(mres.DuplicateFactForeignKey.str(msgRecorder.getContext(), baseFKName, aggFKName));
                    } else {
                        namesToObjects.put(baseFKName, aggFKName);
                    }
                    if (columnsToObjects.containsKey(aggFKName)) {
                        msgRecorder.reportError(mres.DuplicateFactForeignKey.str(msgRecorder.getContext(), baseFKName, aggFKName));
                    } else {
                        columnsToObjects.put(aggFKName, baseFKName);
                    }
                    if (factTable.findTableWithLeftCondition(c = new MondrianDef.Column(tableName, baseFKName)) != null) continue;
                    msgRecorder.reportError(mres.UnknownLeftJoinCondition.str(msgRecorder.getContext(), tableName, baseFKName));
                }
            }
            finally {
                msgRecorder.popContextName();
            }
        }

        public String toString() {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }

        public void print(PrintWriter pw, String prefix) {
            String subprefix = prefix + "  ";
            String subsubprefix = subprefix + "  ";
            pw.print(subprefix);
            pw.print("id=");
            pw.println(this.id);
            pw.print(subprefix);
            pw.print("ignoreCase=");
            pw.println(this.ignoreCase);
            pw.print(subprefix);
            pw.println("Levels: [");
            for (Level level : this.levels) {
                level.print(pw, subsubprefix);
            }
            pw.print(subprefix);
            pw.println("]");
            pw.print(subprefix);
            pw.println("Measures: [");
            for (Measure measure : this.measures) {
                measure.print(pw, subsubprefix);
            }
            pw.print(subprefix);
            pw.println("]");
        }

        class Measure {
            private final String name;
            private String symbolicName;
            private final String columnName;
            private RolapStar.Measure rolapMeasure;

            Measure(String name, String columnName) {
                this.name = name;
                this.columnName = columnName;
            }

            public String getName() {
                return this.name;
            }

            public String getSymbolicName() {
                return this.symbolicName;
            }

            public String getColumnName() {
                return this.columnName;
            }

            public RolapStar.Measure getRolapStarMeasure() {
                return this.rolapMeasure;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void validate(MessageRecorder msgRecorder) {
                msgRecorder.pushContextName("Measure");
                try {
                    String name = this.getName();
                    String column = this.getColumnName();
                    ExplicitRules.checkAttributeString(msgRecorder, name, "name");
                    ExplicitRules.checkAttributeString(msgRecorder, column, "column");
                    List<Id.Segment> names = Util.parseIdentifier(name);
                    if (names.size() != 2) {
                        msgRecorder.reportError(mres.BadMeasureNameFormat.str(msgRecorder.getContext(), name));
                    } else {
                        RolapCube cube = TableDef.this.getCube();
                        SchemaReader schemaReader = cube.getSchemaReader();
                        Member member = (Member)schemaReader.lookupCompound(cube, names, false, 6);
                        if (member == null) {
                            if (!(names.get(0) instanceof Id.NameSegment) || !((Id.NameSegment)names.get((int)0)).name.equals("Measures")) {
                                msgRecorder.reportError(mres.BadMeasures.str(msgRecorder.getContext(), names.get(0).toString()));
                            } else {
                                msgRecorder.reportError(mres.UnknownMeasureName.str(msgRecorder.getContext(), names.get(1).toString()));
                            }
                        }
                        RolapStar star = cube.getStar();
                        RolapStar.Measure measure = this.rolapMeasure = names.get(1) instanceof Id.NameSegment ? star.getFactTable().lookupMeasureByName(cube.getName(), ((Id.NameSegment)names.get((int)1)).name) : null;
                        if (this.rolapMeasure == null) {
                            msgRecorder.reportError(mres.BadMeasureName.str(msgRecorder.getContext(), names.get(1).toString(), cube.getName()));
                        }
                        this.symbolicName = names.get(1).toString();
                    }
                }
                finally {
                    msgRecorder.popContextName();
                }
            }

            public String toString() {
                StringWriter sw = new StringWriter(256);
                PrintWriter pw = new PrintWriter(sw);
                this.print(pw, "");
                pw.flush();
                return sw.toString();
            }

            public void print(PrintWriter pw, String prefix) {
                pw.print(prefix);
                pw.println("Measure:");
                String subprefix = prefix + "  ";
                pw.print(subprefix);
                pw.print("name=");
                pw.println(this.name);
                pw.print(subprefix);
                pw.print("column=");
                pw.println(this.columnName);
            }
        }

        class Level {
            private final String name;
            private final String columnName;
            private final boolean collapsed;
            private RolapLevel rlevel;

            Level(String name, String columnName, boolean collapsed) {
                this.name = name;
                this.columnName = columnName;
                this.collapsed = collapsed;
            }

            public String getName() {
                return this.name;
            }

            public String getColumnName() {
                return this.columnName;
            }

            public boolean isCollapsed() {
                return this.collapsed;
            }

            public RolapLevel getRolapLevel() {
                return this.rlevel;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void validate(MessageRecorder msgRecorder) {
                msgRecorder.pushContextName("Level");
                try {
                    String name = this.getName();
                    String columnName = this.getColumnName();
                    ExplicitRules.checkAttributeString(msgRecorder, name, "name");
                    ExplicitRules.checkAttributeString(msgRecorder, columnName, "column");
                    List<Id.Segment> names = Util.parseIdentifier(name);
                    if (!(names.size() == 2 || MondrianProperties.instance().SsasCompatibleNaming.get() && names.size() == 3)) {
                        msgRecorder.reportError(mres.BadLevelNameFormat.str(msgRecorder.getContext(), name));
                    } else {
                        RolapCube cube = TableDef.this.getCube();
                        SchemaReader schemaReader = cube.getSchemaReader();
                        RolapLevel level = (RolapLevel)schemaReader.lookupCompound(cube, names, false, 4);
                        if (level == null) {
                            Hierarchy hierarchy = (Hierarchy)schemaReader.lookupCompound(cube, names.subList(0, 1), false, 3);
                            if (hierarchy == null) {
                                msgRecorder.reportError(mres.UnknownHierarchyName.str(msgRecorder.getContext(), names.get(0).toString()));
                            } else {
                                msgRecorder.reportError(mres.UnknownLevelName.str(msgRecorder.getContext(), names.get(0).toString(), names.get(1).toString()));
                            }
                        }
                        this.rlevel = level;
                    }
                }
                finally {
                    msgRecorder.popContextName();
                }
            }

            public String toString() {
                StringWriter sw = new StringWriter(256);
                PrintWriter pw = new PrintWriter(sw);
                this.print(pw, "");
                pw.flush();
                return sw.toString();
            }

            public void print(PrintWriter pw, String prefix) {
                pw.print(prefix);
                pw.println("Level:");
                String subprefix = prefix + "  ";
                pw.print(subprefix);
                pw.print("name=");
                pw.println(this.name);
                pw.print(subprefix);
                pw.print("columnName=");
                pw.println(this.columnName);
            }
        }
    }

    private static class ExcludePattern
    implements Exclude {
        private final Pattern pattern;

        private ExcludePattern(String pattern, boolean ignoreCase) {
            this.pattern = ignoreCase ? Pattern.compile(pattern, 2) : Pattern.compile(pattern);
        }

        @Override
        public boolean isExcluded(String tableName) {
            return this.pattern.matcher(tableName).matches();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void validate(MessageRecorder msgRecorder) {
            msgRecorder.pushContextName("ExcludePattern");
            try {
                ExplicitRules.checkAttributeString(msgRecorder, this.pattern.pattern(), "pattern");
            }
            finally {
                msgRecorder.popContextName();
            }
        }

        @Override
        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("ExplicitRules.PatternTableDef.ExcludePattern:");
            String subprefix = prefix + "  ";
            pw.print(subprefix);
            pw.print("pattern=");
            pw.print(this.pattern.pattern());
            pw.print(":");
            pw.println(this.pattern.flags());
        }
    }

    private static class ExcludeName
    implements Exclude {
        private final String name;
        private final boolean ignoreCase;

        private ExcludeName(String name, boolean ignoreCase) {
            this.name = name;
            this.ignoreCase = ignoreCase;
        }

        public String getName() {
            return this.name;
        }

        public boolean isIgnoreCase() {
            return this.ignoreCase;
        }

        @Override
        public boolean isExcluded(String tableName) {
            return this.ignoreCase ? this.name.equals(tableName) : this.name.equalsIgnoreCase(tableName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void validate(MessageRecorder msgRecorder) {
            msgRecorder.pushContextName("ExcludeName");
            try {
                String name = this.getName();
                ExplicitRules.checkAttributeString(msgRecorder, name, "name");
            }
            finally {
                msgRecorder.popContextName();
            }
        }

        @Override
        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("ExplicitRules.PatternTableDef.ExcludeName:");
            String subprefix = prefix + "  ";
            pw.print(subprefix);
            pw.print("name=");
            pw.println(this.name);
            pw.print(subprefix);
            pw.print("ignoreCase=");
            pw.println(this.ignoreCase);
        }
    }

    private static interface Exclude {
        public boolean isExcluded(String var1);

        public void validate(MessageRecorder var1);

        public void print(PrintWriter var1, String var2);
    }

    public static class Group {
        private final RolapCube cube;
        private List<TableDef> tableDefs;
        private List<Exclude> excludes;

        public static Group make(RolapCube cube, MondrianDef.Cube xmlCube) {
            Group group = new Group(cube);
            MondrianDef.Relation relation = xmlCube.fact;
            if (relation instanceof MondrianDef.Table) {
                MondrianDef.AggTable[] aggTables;
                MondrianDef.AggExclude[] aggExcludes = ((MondrianDef.Table)relation).getAggExcludes();
                if (aggExcludes != null) {
                    for (MondrianDef.AggExclude aggExclude : aggExcludes) {
                        Exclude exclude = ExplicitRules.make(aggExclude);
                        group.addExclude(exclude);
                    }
                }
                if ((aggTables = ((MondrianDef.Table)relation).getAggTables()) != null) {
                    for (MondrianDef.AggTable aggTable : aggTables) {
                        TableDef tableDef = TableDef.make(aggTable, group);
                        group.addTableDef(tableDef);
                    }
                }
            } else {
                LOGGER.warn((Object)mres.CubeRelationNotTable.str(cube.getName(), ((Object)((Object)relation)).getClass().getName()));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(Util.nl + group));
            }
            return group;
        }

        public Group(RolapCube cube) {
            this.cube = cube;
            this.excludes = Collections.emptyList();
            this.tableDefs = Collections.emptyList();
        }

        public RolapCube getCube() {
            return this.cube;
        }

        public RolapStar getStar() {
            return this.getCube().getStar();
        }

        public String getName() {
            return this.getCube().getName();
        }

        public boolean hasRules() {
            return this.excludes != Collections.EMPTY_LIST || this.tableDefs != Collections.EMPTY_LIST;
        }

        public void addExclude(Exclude exclude) {
            if (this.excludes == Collections.EMPTY_LIST) {
                this.excludes = new ArrayList<Exclude>();
            }
            this.excludes.add(exclude);
        }

        public void addTableDef(TableDef tableDef) {
            if (this.tableDefs == Collections.EMPTY_LIST) {
                this.tableDefs = new ArrayList<TableDef>();
            }
            this.tableDefs.add(tableDef);
        }

        public boolean excludeTable(String tableName) {
            for (Exclude exclude : this.excludes) {
                if (!exclude.isExcluded(tableName)) continue;
                return true;
            }
            return false;
        }

        public TableDef getIncludeByTableDef(String tableName) {
            for (TableDef tableDef : this.tableDefs) {
                if (!(tableDef instanceof NameTableDef) || !tableDef.matches(tableName)) continue;
                return tableDef;
            }
            for (TableDef tableDef : this.tableDefs) {
                if (!(tableDef instanceof PatternTableDef) || !tableDef.matches(tableName)) continue;
                return tableDef;
            }
            return null;
        }

        public String getTableName() {
            RolapStar.Table table = this.getStar().getFactTable();
            MondrianDef.Relation relation = table.getRelation();
            return relation.getAlias();
        }

        public String getSchemaName() {
            String schema = null;
            RolapStar.Table table = this.getStar().getFactTable();
            MondrianDef.Relation relation = table.getRelation();
            if (relation instanceof MondrianDef.Table) {
                MondrianDef.Table mtable = (MondrianDef.Table)relation;
                schema = mtable.schema;
            }
            return schema;
        }

        public String getCatalogName() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate(MessageRecorder msgRecorder) {
            msgRecorder.pushContextName(this.getName());
            try {
                for (TableDef tableDef : this.tableDefs) {
                    tableDef.validate(msgRecorder);
                }
            }
            finally {
                msgRecorder.popContextName();
            }
        }

        public String toString() {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }

        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("ExplicitRules.Group:");
            String subprefix = prefix + "  ";
            String subsubprefix = subprefix + "  ";
            pw.print(subprefix);
            pw.print("name=");
            pw.println((Object)this.getStar().getFactTable().getRelation());
            pw.print(subprefix);
            pw.println("TableDefs: [");
            for (TableDef tableDef : this.tableDefs) {
                tableDef.print(pw, subsubprefix);
            }
            pw.print(subprefix);
            pw.println("]");
        }
    }
}

