/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xbaseinput;

import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xbaseinput.XBase;
import org.pentaho.di.trans.steps.xbaseinput.XBaseInputData;
import org.pentaho.di.trans.steps.xbaseinput.XBaseInputMeta;

public class XBaseInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = XBaseInputMeta.class;
    private XBaseInputMeta meta;
    private XBaseInputData data;

    public XBaseInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (XBaseInputMeta)smi;
        this.data = (XBaseInputData)sdi;
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            if (this.meta.isAcceptingFilenames()) {
                this.data.files.getFiles().clear();
                int idx = -1;
                RowSet rowSet = this.findInputRowSet(this.meta.getAcceptingStepName());
                Object[] fileRowData = this.getRowFrom(rowSet);
                while (fileRowData != null) {
                    RowMetaInterface fileRowMeta = rowSet.getRowMeta();
                    if (idx < 0 && (idx = fileRowMeta.indexOfValue(this.meta.getAcceptingField())) < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"XBaseInput.Log.Error.UnableToFindFilenameField", (String[])new String[]{this.meta.getAcceptingField()}));
                        this.setErrors(1L);
                        this.stopAll();
                        return false;
                    }
                    try {
                        String filename = fileRowMeta.getString(fileRowData, idx);
                        this.data.files.addFile(KettleVFS.getFileObject((String)filename, (VariableSpace)this.getTransMeta()));
                    }
                    catch (Exception e) {
                        throw new KettleException((Throwable)e);
                    }
                    fileRowData = this.getRowFrom(rowSet);
                }
                if (this.data.files.nrOfFiles() == 0) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"XBaseInput.Log.Error.NoFilesSpecified", (String[])new String[0]));
                    this.setOutputDone();
                    return false;
                }
            }
            this.data.outputRowMeta = this.meta.getOutputFields(this.data.files, this.getStepname());
            this.openNextFile();
        }
        Object[] row = this.data.xbi.getRow(RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size()));
        while (row == null && this.data.fileNr < this.data.files.nrOfFiles()) {
            this.openNextFile();
            row = this.data.xbi.getRow(RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size()));
        }
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        this.incrementLinesInput();
        int outputIndex = this.data.fields.size();
        if (this.meta.includeFilename()) {
            row[outputIndex++] = this.data.file_dbf.getName().getURI();
        }
        if (this.meta.isRowNrAdded()) {
            row[outputIndex++] = new Long(this.getLinesInput());
        }
        this.putRow(this.data.outputRowMeta, row);
        if (this.checkFeedback(this.getLinesInput())) {
            this.logBasic(BaseMessages.getString(PKG, (String)"XBaseInput.Log.LineNr", (String[])new String[0]) + this.getLinesInput());
        }
        if (this.meta.getRowLimit() > 0 && this.getLinesInput() >= (long)this.meta.getRowLimit()) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XBaseInputMeta)smi;
        this.data = (XBaseInputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.files = this.meta.getTextFileList(this);
            this.data.fileNr = 0;
            if (this.data.files.nrOfFiles() == 0 && !this.meta.isAcceptingFilenames()) {
                this.logError(BaseMessages.getString(PKG, (String)"XBaseInput.Log.Error.NoFilesSpecified", (String[])new String[0]));
                return false;
            }
            if (this.meta.isAcceptingFilenames()) {
                try {
                    if (Const.isEmpty((String)this.meta.getAcceptingStepName()) || this.findInputRowSet(this.meta.getAcceptingStepName()) == null) {
                        this.logError(BaseMessages.getString(PKG, (String)"XBaseInput.Log.Error.InvalidAcceptingStepName", (String[])new String[0]));
                        return false;
                    }
                    if (Const.isEmpty((String)this.meta.getAcceptingField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"XBaseInput.Log.Error.InvalidAcceptingFieldName", (String[])new String[0]));
                        return false;
                    }
                }
                catch (Exception e) {
                    this.logError(e.getMessage());
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private void openNextFile() throws KettleException {
        if (this.data.xbi != null) {
            this.logBasic(BaseMessages.getString(PKG, (String)"XBaseInput.Log.FinishedReadingRecords", (String[])new String[0]));
            this.data.xbi.close();
        }
        this.data.file_dbf = this.data.files.getFile(this.data.fileNr);
        ++this.data.fileNr;
        try {
            this.data.xbi = new XBase(this.log, KettleVFS.getInputStream((FileObject)this.data.file_dbf));
            this.data.xbi.setDbfFile(this.data.file_dbf.getName().getURI());
            this.data.xbi.open();
            if (!Const.isEmpty((String)this.meta.getCharactersetName())) {
                this.data.xbi.getReader().setCharactersetName(this.meta.getCharactersetName());
            }
            this.logBasic(BaseMessages.getString(PKG, (String)"XBaseInput.Log.OpenedXBaseFile", (String[])new String[0]) + " : [" + this.data.xbi + "]");
            this.data.fields = this.data.xbi.getFields();
            ResultFile resultFile = new ResultFile(0, this.data.file_dbf, this.getTransMeta().getName(), this.getStepname());
            resultFile.setComment(BaseMessages.getString(PKG, (String)"XBaseInput.ResultFile.Comment", (String[])new String[0]));
            this.addResultFile(resultFile);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"XBaseInput.Log.Error.CouldNotOpenXBaseFile1", (String[])new String[0]) + this.data.file_dbf + BaseMessages.getString(PKG, (String)"XBaseInput.Log.Error.CouldNotOpenXBaseFile2", (String[])new String[0]) + e.getMessage());
            throw new KettleException((Throwable)e);
        }
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.closeLastFile();
        super.dispose(smi, sdi);
    }

    private void closeLastFile() {
        this.logBasic(BaseMessages.getString(PKG, (String)"XBaseInput.Log.FinishedReadingRecords", (String[])new String[0]));
        if (this.data.xbi != null) {
            this.data.xbi.close();
        }
    }
}

