/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.textfileoutput;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.WriterOutputStream;
import org.pentaho.di.core.compress.CompressionProvider;
import org.pentaho.di.core.compress.CompressionProviderFactory;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.fileinput.CharsetToolkit;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.util.StreamLogger;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputData;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMeta;

public class TextFileOutput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = TextFileOutputMeta.class;
    private static final String FILE_COMPRESSION_TYPE_NONE = TextFileOutputMeta.fileCompressionTypeCodes[0];
    public TextFileOutputMeta meta;
    public TextFileOutputData data;

    public TextFileOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public synchronized boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (TextFileOutputMeta)smi;
        this.data = (TextFileOutputData)sdi;
        if (this.meta.getEncoding() == null || this.meta.getEncoding().isEmpty()) {
            this.meta.setEncoding(CharsetToolkit.getDefaultSystemCharset().name());
        }
        boolean result = true;
        boolean bEndedLineWrote = false;
        Object[] r = this.getRow();
        if (r != null && this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            if (this.meta.isFileNameInField()) {
                this.data.fileNameFieldIndex = this.getInputRowMeta().indexOfValue(this.meta.getFileNameField());
                if (this.data.fileNameFieldIndex < 0) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"TextFileOutput.Exception.FileNameFieldNotFound", (String[])new String[]{this.meta.getFileNameField()}));
                }
                this.data.fileNameMeta = this.getInputRowMeta().getValueMeta(this.data.fileNameFieldIndex);
                this.data.fileName = this.data.fileNameMeta.getString(r[this.data.fileNameFieldIndex]);
                this.setDataWriterForFilename(this.data.fileName);
            } else if (this.meta.isDoNotOpenNewFileInit() && !this.meta.isFileNameInField()) {
                this.openNewFile(this.meta.getFileName());
                this.data.oneFileOpened = true;
                this.initBinaryDataFields();
            }
            if (!this.meta.isFileAppended() && (this.meta.isHeaderEnabled() || this.meta.isFooterEnabled()) && !this.meta.isFileNameInField() && this.meta.isHeaderEnabled() && this.data.outputRowMeta != null) {
                this.writeHeader();
            }
            this.data.fieldnrs = new int[this.meta.getOutputFields().length];
            for (int i = 0; i < this.meta.getOutputFields().length; ++i) {
                this.data.fieldnrs[i] = this.data.outputRowMeta.indexOfValue(this.meta.getOutputFields()[i].getName());
                if (this.data.fieldnrs[i] >= 0) continue;
                throw new KettleStepException("Field [" + this.meta.getOutputFields()[i].getName() + "] couldn't be found in the input stream!");
            }
        }
        if (r == null && this.data.outputRowMeta != null && this.meta.isFooterEnabled() || r != null && this.getLinesOutput() > 0L && this.meta.getSplitEvery() > 0 && (this.getLinesOutput() + (long)this.meta.getFooterShift()) % (long)this.meta.getSplitEvery() == 0L) {
            if (this.data.outputRowMeta != null && this.meta.isFooterEnabled()) {
                this.writeHeader();
            }
            if (r == null) {
                this.writeEndedLine();
                bEndedLineWrote = true;
            }
            this.closeFile();
            if (r != null) {
                this.openNewFile(this.meta.getFileName());
                if (this.meta.isHeaderEnabled() && this.data.outputRowMeta != null) {
                    this.writeHeader();
                }
            }
        }
        if (r == null) {
            if (!bEndedLineWrote && !Const.isEmpty((String)this.meta.getEndedLine())) {
                if (this.data.writer == null) {
                    this.openNewFile(this.meta.getFileName());
                    this.data.oneFileOpened = true;
                    this.initBinaryDataFields();
                }
                this.writeEndedLine();
                bEndedLineWrote = true;
            }
            this.setOutputDone();
            return false;
        }
        if (this.meta.isFileNameInField()) {
            String baseFilename = this.data.fileNameMeta.getString(r[this.data.fileNameFieldIndex]);
            this.setDataWriterForFilename(baseFilename);
        }
        this.writeRowToFile(this.data.outputRowMeta, r);
        this.putRow(this.data.outputRowMeta, r);
        if (this.checkFeedback(this.getLinesOutput())) {
            this.logBasic("linenr " + this.getLinesOutput());
        }
        return result;
    }

    private void setDataWriterForFilename(String filename) throws KettleException {
        this.data.writer = this.data.fileWriterMap.get(filename);
        if (this.data.writer == null) {
            this.openNewFile(filename);
            this.data.oneFileOpened = true;
            this.data.fileWriterMap.put(filename, this.data.writer);
            if (!this.meta.isFileAppended() && this.meta.isHeaderEnabled() && this.writeHeader()) {
                this.incrementLinesOutput();
            }
        }
    }

    protected void writeRowToFile(RowMetaInterface rowMeta, Object[] r) throws KettleStepException {
        try {
            if (this.meta.getOutputFields() == null || this.meta.getOutputFields().length == 0) {
                for (int i = 0; i < rowMeta.size(); ++i) {
                    if (i > 0 && this.data.binarySeparator.length > 0) {
                        this.data.writer.write(this.data.binarySeparator);
                    }
                    ValueMetaInterface v = rowMeta.getValueMeta(i);
                    Object valueData = r[i];
                    this.writeField(v, valueData, null);
                }
                this.data.writer.write(this.data.binaryNewline);
            } else {
                for (int i = 0; i < this.meta.getOutputFields().length; ++i) {
                    if (i > 0 && this.data.binarySeparator.length > 0) {
                        this.data.writer.write(this.data.binarySeparator);
                    }
                    ValueMetaInterface v = rowMeta.getValueMeta(this.data.fieldnrs[i]);
                    Object valueData = r[this.data.fieldnrs[i]];
                    this.writeField(v, valueData, this.data.binaryNullValue[i]);
                }
                this.data.writer.write(this.data.binaryNewline);
            }
            this.incrementLinesOutput();
        }
        catch (Exception e) {
            throw new KettleStepException("Error writing line", (Throwable)e);
        }
    }

    private byte[] formatField(ValueMetaInterface v, Object valueData) throws KettleValueException {
        if (v.isString()) {
            if (v.isStorageBinaryString() && v.getTrimType() == 0 && v.getLength() < 0 && Const.isEmpty((String)v.getStringEncoding())) {
                return (byte[])valueData;
            }
            String svalue = valueData instanceof String ? (String)valueData : v.getString(valueData);
            return this.convertStringToBinaryString(v, Const.trimToType((String)svalue, (int)v.getTrimType()));
        }
        return v.getBinaryString(valueData);
    }

    private byte[] convertStringToBinaryString(ValueMetaInterface v, String string) throws KettleValueException {
        byte[] text;
        int length = v.getLength();
        if (string == null) {
            return new byte[0];
        }
        if (length > -1 && length < string.length()) {
            String tmp = string.substring(0, length);
            if (Const.isEmpty((String)v.getStringEncoding())) {
                return tmp.getBytes();
            }
            try {
                return tmp.getBytes(v.getStringEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new KettleValueException("Unable to convert String to Binary with specified string encoding [" + v.getStringEncoding() + "]", (Throwable)e);
            }
        }
        if (Const.isEmpty((String)v.getStringEncoding())) {
            text = string.getBytes();
        } else {
            try {
                text = string.getBytes(v.getStringEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new KettleValueException("Unable to convert String to Binary with specified string encoding [" + v.getStringEncoding() + "]", (Throwable)e);
            }
        }
        if (length > string.length()) {
            int size = 0;
            byte[] filler = null;
            try {
                filler = !Const.isEmpty((String)this.meta.getEncoding()) ? " ".getBytes(this.meta.getEncoding()) : " ".getBytes();
                size = text.length + filler.length * (length - string.length());
            }
            catch (UnsupportedEncodingException uee) {
                throw new KettleValueException((Throwable)uee);
            }
            byte[] bytes = new byte[size];
            System.arraycopy(text, 0, bytes, 0, text.length);
            if (filler.length == 1) {
                Arrays.fill(bytes, text.length, size, filler[0]);
            } else {
                int currIndex = text.length;
                for (int i = 0; i < length - string.length(); ++i) {
                    for (int j = 0; j < filler.length; ++j) {
                        bytes[currIndex++] = filler[j];
                    }
                }
            }
            return bytes;
        }
        return text;
    }

    private byte[] getBinaryString(String string) throws KettleStepException {
        try {
            if (this.data.hasEncoding) {
                return string.getBytes(this.meta.getEncoding());
            }
            return string.getBytes();
        }
        catch (Exception e) {
            throw new KettleStepException((Throwable)e);
        }
    }

    private void writeField(ValueMetaInterface v, Object valueData, byte[] nullString) throws KettleStepException {
        try {
            byte[] str = nullString != null && v.isNull(valueData) ? nullString : (this.meta.isFastDump() ? (valueData instanceof byte[] ? (byte[])valueData : this.getBinaryString(valueData == null ? "" : valueData.toString())) : this.formatField(v, valueData));
            if (str != null && str.length > 0) {
                List<Integer> enclosures = null;
                boolean writeEnclosures = false;
                if (v.isString()) {
                    if (this.meta.isEnclosureForced() && !this.meta.isPadded()) {
                        writeEnclosures = true;
                    } else if (!this.meta.isEnclosureFixDisabled() && this.containsSeparatorOrEnclosure(str, this.data.binarySeparator, this.data.binaryEnclosure)) {
                        writeEnclosures = true;
                    }
                }
                if (writeEnclosures) {
                    this.data.writer.write(this.data.binaryEnclosure);
                    enclosures = this.getEnclosurePositions(str);
                }
                if (enclosures == null) {
                    this.data.writer.write(str);
                } else {
                    int from = 0;
                    for (int i = 0; i < enclosures.size(); ++i) {
                        int position = enclosures.get(i);
                        this.data.writer.write(str, from, position + this.data.binaryEnclosure.length - from);
                        this.data.writer.write(this.data.binaryEnclosure);
                        from = position + this.data.binaryEnclosure.length;
                    }
                    if (from < str.length) {
                        this.data.writer.write(str, from, str.length - from);
                    }
                }
                if (writeEnclosures) {
                    this.data.writer.write(this.data.binaryEnclosure);
                }
            }
        }
        catch (Exception e) {
            throw new KettleStepException("Error writing field content to file", (Throwable)e);
        }
    }

    private List<Integer> getEnclosurePositions(byte[] str) {
        ArrayList<Integer> positions = null;
        if (this.data.binaryEnclosure != null && this.data.binaryEnclosure.length > 0) {
            int len = str.length - this.data.binaryEnclosure.length + 1;
            for (int i = 0; i < len; ++i) {
                boolean found = true;
                for (int x = 0; found && x < this.data.binaryEnclosure.length; ++x) {
                    if (str[i + x] == this.data.binaryEnclosure[x]) continue;
                    found = false;
                }
                if (!found) continue;
                if (positions == null) {
                    positions = new ArrayList<Integer>();
                }
                positions.add(i);
            }
        }
        return positions;
    }

    protected boolean writeEndedLine() {
        boolean retval = false;
        try {
            String sLine = this.meta.getEndedLine();
            if (sLine != null && sLine.trim().length() > 0) {
                this.data.writer.write(this.getBinaryString(sLine));
                this.incrementLinesOutput();
            }
        }
        catch (Exception e) {
            this.logError("Error writing ended tag line: " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
            retval = true;
        }
        return retval;
    }

    protected boolean writeHeader() {
        boolean retval = false;
        RowMetaInterface r = this.data.outputRowMeta;
        try {
            if (this.meta.getOutputFields() != null && this.meta.getOutputFields().length > 0) {
                for (int i = 0; i < this.meta.getOutputFields().length; ++i) {
                    boolean writeEnclosure;
                    String fieldName = this.meta.getOutputFields()[i].getName();
                    ValueMetaInterface v = r.searchValueMeta(fieldName);
                    if (i > 0 && this.data.binarySeparator.length > 0) {
                        this.data.writer.write(this.data.binarySeparator);
                    }
                    boolean bl = writeEnclosure = this.meta.isEnclosureForced() && this.data.binaryEnclosure.length > 0 && v != null && v.isString() || !this.meta.isEnclosureFixDisabled() && this.containsSeparatorOrEnclosure(fieldName.getBytes(), this.data.binarySeparator, this.data.binaryEnclosure);
                    if (writeEnclosure) {
                        this.data.writer.write(this.data.binaryEnclosure);
                    }
                    this.data.writer.write(this.getBinaryString(fieldName));
                    if (!writeEnclosure) continue;
                    this.data.writer.write(this.data.binaryEnclosure);
                }
                this.data.writer.write(this.data.binaryNewline);
            } else if (r != null) {
                for (int i = 0; i < r.size(); ++i) {
                    boolean writeEnclosure;
                    if (i > 0 && this.data.binarySeparator.length > 0) {
                        this.data.writer.write(this.data.binarySeparator);
                    }
                    ValueMetaInterface v = r.getValueMeta(i);
                    boolean bl = writeEnclosure = this.meta.isEnclosureForced() && this.data.binaryEnclosure.length > 0 && v != null && v.isString() || !this.meta.isEnclosureFixDisabled() && this.containsSeparatorOrEnclosure(v.getName().getBytes(), this.data.binarySeparator, this.data.binaryEnclosure);
                    if (writeEnclosure) {
                        this.data.writer.write(this.data.binaryEnclosure);
                    }
                    this.data.writer.write(this.getBinaryString(v.getName()));
                    if (!writeEnclosure) continue;
                    this.data.writer.write(this.data.binaryEnclosure);
                }
                this.data.writer.write(this.data.binaryNewline);
            } else {
                this.data.writer.write(this.getBinaryString("no rows selected" + Const.CR));
            }
        }
        catch (Exception e) {
            this.logError("Error writing header line: " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
            retval = true;
        }
        this.incrementLinesOutput();
        return retval;
    }

    public String buildFilename(String filename, boolean ziparchive) {
        return this.meta.buildFilename(filename, this.meta.getExtension(), this, this.getCopy(), this.getPartitionID(), this.data.splitnr, ziparchive, this.meta);
    }

    public void openNewFile(String baseFilename) throws KettleException {
        ResultFile resultFile;
        if (baseFilename == null) {
            throw new KettleFileException(BaseMessages.getString(PKG, (String)"TextFileOutput.Exception.FileNameNotSet", (String[])new String[0]));
        }
        this.data.writer = null;
        String filename = this.buildFilename(this.environmentSubstitute(baseFilename), true);
        try {
            if (this.meta.isServletOutput()) {
                PrintWriter writer = this.getTrans().getServletPrintWriter();
                this.data.writer = Const.isEmpty((String)this.meta.getEncoding()) ? new WriterOutputStream((Writer)writer) : new WriterOutputStream((Writer)writer, this.meta.getEncoding());
            } else if (this.meta.isFileAsCommand()) {
                if (this.log.isDebug()) {
                    this.logDebug("Spawning external process");
                }
                if (this.data.cmdProc != null) {
                    this.logError("Previous command not correctly terminated");
                    this.setErrors(1L);
                }
                String cmdstr = this.environmentSubstitute(this.meta.getFileName());
                if (Const.getOS().equals("Windows 95")) {
                    cmdstr = "command.com /C " + cmdstr;
                } else if (Const.getOS().startsWith("Windows")) {
                    cmdstr = "cmd.exe /C " + cmdstr;
                }
                if (this.isDetailed()) {
                    this.logDetailed("Starting: " + cmdstr);
                }
                Runtime r = Runtime.getRuntime();
                this.data.cmdProc = r.exec(cmdstr, EnvUtil.getEnvironmentVariablesForRuntimeExec());
                this.data.writer = this.data.cmdProc.getOutputStream();
                StreamLogger stdoutLogger = new StreamLogger(this.log, this.data.cmdProc.getInputStream(), "(stdout)");
                StreamLogger stderrLogger = new StreamLogger(this.log, this.data.cmdProc.getErrorStream(), "(stderr)");
                new Thread((Runnable)stdoutLogger).start();
                new Thread((Runnable)stderrLogger).start();
            } else {
                CompressionProvider compressionProvider;
                String compressionType;
                if (this.meta.isCreateParentFolder()) {
                    this.createParentFolder(filename);
                }
                if (Const.isEmpty((String)(compressionType = this.meta.getFileCompression()))) {
                    compressionType = FILE_COMPRESSION_TYPE_NONE;
                }
                if ((compressionProvider = CompressionProviderFactory.getInstance().getCompressionProviderByName(compressionType)) == null) {
                    throw new KettleException("No compression provider found with name = " + compressionType);
                }
                if (!compressionProvider.supportsOutput()) {
                    throw new KettleException("Compression provider " + compressionType + " does not support output streams!");
                }
                if (this.log.isDetailed()) {
                    this.logDetailed("Opening output stream using provider: " + compressionProvider.getName());
                }
                this.data.fos = this.checkPreviouslyOpened(filename) ? this.getOutputStream(filename, this.getTransMeta(), true) : this.getOutputStream(filename, this.getTransMeta(), this.meta.isFileAppended());
                this.data.out = compressionProvider.createOutputStream(this.data.fos);
                this.data.out.addEntry(filename, this.environmentSubstitute(this.meta.getExtension()));
                if (!Const.isEmpty((String)this.meta.getEncoding())) {
                    if (this.log.isDetailed()) {
                        this.logDetailed("Opening output stream in encoding: " + this.meta.getEncoding());
                    }
                    this.data.writer = new BufferedOutputStream(this.data.out, 5000);
                } else {
                    if (this.log.isDetailed()) {
                        this.logDetailed("Opening output stream in default encoding");
                    }
                    this.data.writer = new BufferedOutputStream(this.data.out, 5000);
                }
                if (this.log.isDetailed()) {
                    this.logDetailed("Opened new file with name [" + KettleVFS.getFriendlyURI((String)filename) + "]");
                }
            }
        }
        catch (Exception e) {
            throw new KettleException("Error opening new file : " + e.toString());
        }
        ++this.data.splitnr;
        if (this.meta.isAddToResultFiles() && (resultFile = new ResultFile(0, this.getFileObject(filename, this.getTransMeta()), this.getTransMeta().getName(), this.getStepname())) != null) {
            resultFile.setComment(BaseMessages.getString(PKG, (String)"TextFileOutput.AddResultFile", (String[])new String[0]));
            this.addResultFile(resultFile);
        }
    }

    protected boolean closeFile() {
        boolean retval = false;
        try {
            if (this.data.writer != null) {
                this.data.writer.flush();
                if (this.data.cmdProc != null) {
                    if (this.log.isDebug()) {
                        this.logDebug("Closing output stream");
                    }
                    this.data.writer.close();
                    if (this.log.isDebug()) {
                        this.logDebug("Closed output stream");
                    }
                }
            }
            this.data.writer = null;
            if (this.data.cmdProc != null) {
                int procStatus;
                block15: {
                    if (this.log.isDebug()) {
                        this.logDebug("Ending running external command");
                    }
                    procStatus = this.data.cmdProc.waitFor();
                    try {
                        this.data.cmdProc.getErrorStream().close();
                        this.data.cmdProc.getOutputStream().flush();
                        this.data.cmdProc.getOutputStream().close();
                        this.data.cmdProc.getInputStream().close();
                    }
                    catch (IOException e) {
                        if (!this.log.isDetailed()) break block15;
                        this.logDetailed("Warning: Error closing streams: " + e.getMessage());
                    }
                }
                this.data.cmdProc = null;
                if (this.log.isBasic() && procStatus != 0) {
                    this.logBasic("Command exit status: " + procStatus);
                }
            } else {
                if (this.log.isDebug()) {
                    this.logDebug("Closing normal file ...");
                }
                if (this.data.out != null) {
                    this.data.out.close();
                }
                if (this.data.fos != null) {
                    this.data.fos.close();
                    this.data.fos = null;
                }
            }
            retval = true;
        }
        catch (Exception e) {
            this.logError("Exception trying to close file: " + e.toString());
            this.setErrors(1L);
            retval = false;
        }
        return retval;
    }

    public boolean checkPreviouslyOpened(String filename) {
        return this.data.getPreviouslyOpenedFiles().contains(filename);
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TextFileOutputMeta)smi;
        this.data = (TextFileOutputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.splitnr = 0;
            if (!this.meta.isDoNotOpenNewFileInit()) {
                try {
                    if (!this.meta.isFileNameInField()) {
                        this.openNewFile(this.meta.getFileName());
                    }
                    this.data.oneFileOpened = true;
                }
                catch (Exception e) {
                    this.logError("Couldn't open file " + KettleVFS.getFriendlyURI((String)this.getParentVariableSpace().environmentSubstitute(this.meta.getFileName())) + "." + this.getParentVariableSpace().environmentSubstitute(this.meta.getExtension()), e);
                    this.setErrors(1L);
                    this.stopAll();
                }
            }
            try {
                this.initBinaryDataFields();
            }
            catch (Exception e) {
                this.logError("Couldn't initialize binary data fields", e);
                this.setErrors(1L);
                this.stopAll();
            }
            return true;
        }
        return false;
    }

    private void initBinaryDataFields() throws KettleException {
        try {
            this.data.hasEncoding = !Const.isEmpty((String)this.meta.getEncoding());
            this.data.binarySeparator = new byte[0];
            this.data.binaryEnclosure = new byte[0];
            this.data.binaryNewline = new byte[0];
            if (this.data.hasEncoding) {
                if (!Const.isEmpty((String)this.meta.getSeparator())) {
                    this.data.binarySeparator = this.environmentSubstitute(this.meta.getSeparator()).getBytes(this.meta.getEncoding());
                }
                if (!Const.isEmpty((String)this.meta.getEnclosure())) {
                    this.data.binaryEnclosure = this.environmentSubstitute(this.meta.getEnclosure()).getBytes(this.meta.getEncoding());
                }
                if (!Const.isEmpty((String)this.meta.getNewline())) {
                    this.data.binaryNewline = this.meta.getNewline().getBytes(this.meta.getEncoding());
                }
            } else {
                if (!Const.isEmpty((String)this.meta.getSeparator())) {
                    this.data.binarySeparator = this.environmentSubstitute(this.meta.getSeparator()).getBytes();
                }
                if (!Const.isEmpty((String)this.meta.getEnclosure())) {
                    this.data.binaryEnclosure = this.environmentSubstitute(this.meta.getEnclosure()).getBytes();
                }
                if (!Const.isEmpty((String)this.meta.getNewline())) {
                    this.data.binaryNewline = this.environmentSubstitute(this.meta.getNewline()).getBytes();
                }
            }
            this.data.binaryNullValue = new byte[this.meta.getOutputFields().length][];
            for (int i = 0; i < this.meta.getOutputFields().length; ++i) {
                this.data.binaryNullValue[i] = null;
                String nullString = this.meta.getOutputFields()[i].getNullString();
                if (Const.isEmpty((String)nullString)) continue;
                this.data.binaryNullValue[i] = this.data.hasEncoding ? nullString.getBytes(this.meta.getEncoding()) : nullString.getBytes();
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error while encoding binary fields", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TextFileOutputMeta)smi;
        this.data = (TextFileOutputData)sdi;
        if (!this.meta.isFileNameInField()) {
            if (this.data.oneFileOpened) {
                this.closeFile();
            }
            try {
                if (this.data.fos != null) {
                    this.data.fos.close();
                }
            }
            catch (Exception e) {
                this.logError("Unexpected error closing file", e);
                this.setErrors(1L);
            }
        } else {
            for (OutputStream outputStream : this.data.fileWriterMap.values()) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    this.logError("Unexpected error closing file", e);
                    this.setErrors(1L);
                }
            }
        }
        super.dispose(smi, sdi);
    }

    public boolean containsSeparatorOrEnclosure(byte[] source, byte[] separator, byte[] enclosure) {
        boolean separatorExists;
        boolean result = false;
        boolean enclosureExists = enclosure != null && enclosure.length > 0;
        boolean bl = separatorExists = separator != null && separator.length > 0;
        if (separatorExists || enclosureExists) {
            block0: for (int index = 0; !result && index < source.length; ++index) {
                int i;
                if (enclosureExists && source[index] == enclosure[0]) {
                    if (index + enclosure.length > source.length) continue;
                    result = true;
                    for (i = 1; i < enclosure.length; ++i) {
                        if (source[index + i] == enclosure[i]) continue;
                        result = false;
                        continue block0;
                    }
                    continue;
                }
                if (!separatorExists || source[index] != separator[0] || index + separator.length > source.length) continue;
                result = true;
                for (i = 1; i < separator.length; ++i) {
                    if (source[index + i] == separator[i]) continue;
                    result = false;
                    continue block0;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createParentFolder(String filename) throws Exception {
        block13: {
            FileObject parentfolder = null;
            try {
                parentfolder = this.getFileObject(filename).getParent();
                if (parentfolder.exists()) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"TextFileOutput.Log.ParentFolderExist", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)parentfolder)}));
                    }
                    break block13;
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"TextFileOutput.Log.ParentFolderNotExist", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)parentfolder)}));
                }
                if (this.meta.isCreateParentFolder()) {
                    parentfolder.createFolder();
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"TextFileOutput.Log.ParentFolderCreated", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)parentfolder)}));
                    }
                    break block13;
                }
                throw new KettleException(BaseMessages.getString(PKG, (String)"TextFileOutput.Log.ParentFolderNotExistCreateIt", (String[])new String[]{KettleVFS.getFriendlyURI((FileObject)parentfolder), KettleVFS.getFriendlyURI((String)filename)}));
            }
            finally {
                if (parentfolder != null) {
                    try {
                        parentfolder.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    protected FileObject getFileObject(String vfsFilename) throws KettleFileException {
        return KettleVFS.getFileObject((String)vfsFilename);
    }

    protected FileObject getFileObject(String vfsFilename, VariableSpace space) throws KettleFileException {
        return KettleVFS.getFileObject((String)vfsFilename, (VariableSpace)space);
    }

    protected OutputStream getOutputStream(String vfsFilename, VariableSpace space, boolean append) throws KettleFileException {
        return KettleVFS.getOutputStream((String)vfsFilename, (VariableSpace)space, (boolean)append);
    }
}

