/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.pentahoreporting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.pentahoreporting.PentahoReportingOutput;
import org.pentaho.di.trans.steps.pentahoreporting.PentahoReportingOutputData;
import org.pentaho.di.trans.steps.pentahoreporting.PentahoReportingOutputMetaInjection;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class PentahoReportingOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = PentahoReportingOutput.class;
    public static final String XML_TAG_PARAMETERS = "parameters";
    public static final String XML_TAG_PARAMETER = "parameter";
    private String inputFileField;
    private String outputFileField;
    private Map<String, String> parameterFieldMap = new HashMap<String, String>();
    private ProcessorType outputProcessorType;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        PentahoReportingOutputMeta retval = (PentahoReportingOutputMeta)super.clone();
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.inputFileField = XMLHandler.getTagValue((Node)stepnode, (String)"input_file_field");
            this.outputFileField = XMLHandler.getTagValue((Node)stepnode, (String)"output_file_field");
            this.parameterFieldMap = new HashMap<String, String>();
            Node parsNode = XMLHandler.getSubNode((Node)stepnode, (String)XML_TAG_PARAMETERS);
            List nodes = XMLHandler.getNodes((Node)parsNode, (String)XML_TAG_PARAMETER);
            for (Node node : nodes) {
                String parameter = XMLHandler.getTagValue((Node)node, (String)"name");
                String fieldname = XMLHandler.getTagValue((Node)node, (String)"field");
                if (Const.isEmpty((String)parameter) || Const.isEmpty((String)fieldname)) continue;
                this.parameterFieldMap.put(parameter, fieldname);
            }
            this.outputProcessorType = ProcessorType.getProcessorTypeByCode(XMLHandler.getTagValue((Node)stepnode, (String)"processor_type"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"PentahoReportingOutputMeta.Exception.UnableToLoadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.outputProcessorType = ProcessorType.PDF;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("  " + XMLHandler.addTagValue((String)"input_file_field", (String)this.inputFileField));
        retval.append("  " + XMLHandler.addTagValue((String)"output_file_field", (String)this.outputFileField));
        retval.append("  " + XMLHandler.openTag((String)XML_TAG_PARAMETERS));
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.addAll(this.parameterFieldMap.keySet());
        Collections.sort(parameters);
        for (String name : parameters) {
            String field = this.parameterFieldMap.get(name);
            retval.append("   " + XMLHandler.openTag((String)XML_TAG_PARAMETER));
            retval.append("   " + XMLHandler.addTagValue((String)"name", (String)name, (boolean)false, (String[])new String[0]));
            retval.append("   " + XMLHandler.addTagValue((String)"field", (String)field, (boolean)false, (String[])new String[0]));
            retval.append("   " + XMLHandler.closeTag((String)XML_TAG_PARAMETER)).append(Const.CR);
        }
        retval.append("  " + XMLHandler.closeTag((String)XML_TAG_PARAMETERS));
        retval.append("    " + XMLHandler.addTagValue((String)"processor_type", (String)this.outputProcessorType.getCode()));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId idStep, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.inputFileField = rep.getStepAttributeString(idStep, "file_input_field");
            this.outputFileField = rep.getStepAttributeString(idStep, "file_output_field");
            this.parameterFieldMap = new HashMap<String, String>();
            int nrParameters = rep.countNrStepAttributes(idStep, "parameter_name");
            for (int i = 0; i < nrParameters; ++i) {
                String parameter = rep.getStepAttributeString(idStep, i, "parameter_name");
                String fieldname = rep.getStepAttributeString(idStep, i, "parameter_field");
                if (Const.isEmpty((String)parameter) || Const.isEmpty((String)fieldname)) continue;
                this.parameterFieldMap.put(parameter, fieldname);
            }
            this.outputProcessorType = ProcessorType.getProcessorTypeByCode(rep.getStepAttributeString(idStep, "processor_type"));
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"PentahoReportingOutputMeta.Exception.UnexpectedErrorInReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId idTransformation, ObjectId idStep) throws KettleException {
        try {
            rep.saveStepAttribute(idTransformation, idStep, "file_input_field", this.inputFileField);
            rep.saveStepAttribute(idTransformation, idStep, "file_output_field", this.outputFileField);
            ArrayList<String> pars = new ArrayList<String>(this.parameterFieldMap.keySet());
            Collections.sort(pars);
            for (int i = 0; i < pars.size(); ++i) {
                String parameter = (String)pars.get(i);
                String fieldname = this.parameterFieldMap.get(parameter);
                rep.saveStepAttribute(idTransformation, idStep, i, "parameter_name", parameter);
                rep.saveStepAttribute(idTransformation, idStep, i, "parameter_field", fieldname);
            }
            rep.saveStepAttribute(idTransformation, idStep, "processor_type", this.outputProcessorType.getCode());
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"PentahoReportingOutputMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + idStep, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PentahoReportingOutputMeta.CheckResult.ReceivingFields", (String[])new String[]{String.valueOf(prev.size())}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"PentahoReportingOutputMeta.CheckResult.FileSpecificationsNotChecked", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new PentahoReportingOutput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new PentahoReportingOutputData();
    }

    public String getInputFileField() {
        return this.inputFileField;
    }

    public void setInputFileField(String inputFileField) {
        this.inputFileField = inputFileField;
    }

    public String getOutputFileField() {
        return this.outputFileField;
    }

    public void setOutputFileField(String outputFileField) {
        this.outputFileField = outputFileField;
    }

    public Map<String, String> getParameterFieldMap() {
        return this.parameterFieldMap;
    }

    public void setParameterFieldMap(Map<String, String> parameterFieldMap) {
        this.parameterFieldMap = parameterFieldMap;
    }

    public ProcessorType getOutputProcessorType() {
        return this.outputProcessorType;
    }

    public void setOutputProcessorType(ProcessorType outputProcessorType) {
        this.outputProcessorType = outputProcessorType;
    }

    @Override
    public StepMetaInjectionInterface getStepMetaInjectionInterface() {
        return new PentahoReportingOutputMetaInjection(this);
    }

    public static enum ProcessorType {
        PDF("PDF", "PDF"),
        PagedHTML("PagedHtml", "Paged HTML"),
        StreamingHTML("StreamingHtml", "Streaming HTML"),
        CSV("CSV", "CSV"),
        Excel("Excel", "Excel"),
        Excel_2007("Excel 2007", "Excel 2007"),
        RTF("RTF", "RTF");

        private String code;
        private String description;

        private ProcessorType(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static String[] getDescriptions() {
            String[] desc = new String[ProcessorType.values().length];
            for (int i = 0; i < ProcessorType.values().length; ++i) {
                desc[i] = ProcessorType.values()[i].getDescription();
            }
            return desc;
        }

        public static ProcessorType getProcessorTypeByCode(String code) {
            for (ProcessorType type : ProcessorType.values()) {
                if (!type.getCode().equals(code)) continue;
                return type;
            }
            return null;
        }
    }
}

