/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.exceloutput;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.steps.exceloutput.ExcelField;
import org.pentaho.di.trans.steps.exceloutput.ExcelOutputMeta;

public class ExcelOutputMetaInjection
implements StepMetaInjectionInterface {
    private ExcelOutputMeta meta;

    public ExcelOutputMetaInjection(ExcelOutputMeta meta) {
        this.meta = meta;
    }

    @Override
    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() throws KettleException {
        ArrayList<StepInjectionMetaEntry> all = new ArrayList<StepInjectionMetaEntry>();
        StepInjectionMetaEntry fieldsEntry = new StepInjectionMetaEntry("FIELDS", 0, "All the fields on the spreadsheets");
        all.add(fieldsEntry);
        StepInjectionMetaEntry fieldEntry = new StepInjectionMetaEntry("FIELD", 0, "All the fields on the spreadsheets");
        fieldsEntry.getDetails().add(fieldEntry);
        for (Entry entry : Entry.values()) {
            if (entry.getValueType() == 0) continue;
            StepInjectionMetaEntry metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            fieldEntry.getDetails().add(metaEntry);
        }
        return all;
    }

    @Override
    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> all) throws KettleException {
        ArrayList<ExcelOutputField> excelOutputFields = new ArrayList<ExcelOutputField>();
        for (StepInjectionMetaEntry lookFields : all) {
            Entry fieldsEntry = Entry.findEntry(lookFields.getKey());
            if (fieldsEntry == null || fieldsEntry != Entry.FIELDS) continue;
            for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                Entry fieldEntry = Entry.findEntry(lookField.getKey());
                if (fieldEntry == null || fieldEntry != Entry.FIELD) continue;
                ExcelOutputField excelOutputField = new ExcelOutputField();
                List<StepInjectionMetaEntry> entries = lookField.getDetails();
                for (StepInjectionMetaEntry entry : entries) {
                    Entry metaEntry = Entry.findEntry(entry.getKey());
                    if (metaEntry == null) continue;
                    String value = (String)entry.getValue();
                    switch (metaEntry) {
                        case NAME: {
                            excelOutputField.setName(value);
                            break;
                        }
                        case TYPE: {
                            excelOutputField.setType(value);
                            break;
                        }
                        case FORMAT: {
                            excelOutputField.setFormat(value);
                            break;
                        }
                    }
                }
                excelOutputFields.add(excelOutputField);
            }
        }
        this.meta.allocate(excelOutputFields.size());
        for (int i = 0; i < excelOutputFields.size(); ++i) {
            ExcelField outputField = new ExcelField();
            outputField.setName(((ExcelOutputField)excelOutputFields.get(i)).getName());
            outputField.setType(((ExcelOutputField)excelOutputFields.get(i)).getTypeDesc());
            outputField.setFormat(((ExcelOutputField)excelOutputFields.get(i)).getFormat());
            this.meta.getOutputFields()[i] = outputField;
        }
    }

    @Override
    public List<StepInjectionMetaEntry> extractStepMetadataEntries() throws KettleException {
        return null;
    }

    public ExcelOutputMeta getMeta() {
        return this.meta;
    }

    private static enum Entry {
        FIELDS(0, "All the fields"),
        FIELD(0, "One field"),
        NAME(2, "Input field name"),
        TYPE(2, "Type field value"),
        FORMAT(2, "Format field name");

        private int valueType;
        private String description;

        private Entry(int valueType, String description) {
            this.valueType = valueType;
            this.description = description;
        }

        public int getValueType() {
            return this.valueType;
        }

        public String getDescription() {
            return this.description;
        }

        public static Entry findEntry(String key) {
            return Entry.valueOf(key);
        }
    }

    private class ExcelOutputField {
        private String name;
        private int type;
        private String format;

        private ExcelOutputField() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTypeDesc() {
            return ValueMeta.getTypeDesc((int)this.type);
        }

        public void setType(String typeDesc) {
            this.type = ValueMeta.getType((String)typeDesc);
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }
    }
}

