/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.http;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryHTTP
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryHTTP.class;
    private static final String URL_FIELDNAME = "URL";
    private String url = null;
    private String targetFilename;
    private boolean fileAppended;
    private boolean dateTimeAdded;
    private String targetFilenameExtention;
    private String uploadFilename;
    private String urlFieldname;
    private boolean runForEveryRow;
    private String proxyHostname;
    private String proxyPort;
    private String nonProxyHosts;
    private String username;
    private String password;
    private boolean addfilenameresult = true;
    private String[] headerName;
    private String[] headerValue;

    public JobEntryHTTP(String n) {
        super(n, "");
    }

    public JobEntryHTTP() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryHTTP je = (JobEntryHTTP)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"url", (String)this.url));
        retval.append("      ").append(XMLHandler.addTagValue((String)"targetfilename", (String)this.targetFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"file_appended", (boolean)this.fileAppended));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_added", (boolean)this.dateTimeAdded));
        retval.append("      ").append(XMLHandler.addTagValue((String)"targetfilename_extention", (String)this.targetFilenameExtention));
        retval.append("      ").append(XMLHandler.addTagValue((String)"uploadfilename", (String)this.uploadFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"url_fieldname", (String)this.urlFieldname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"run_every_row", (boolean)this.runForEveryRow));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.username));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_host", (String)this.proxyHostname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_port", (String)this.proxyPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"non_proxy_hosts", (String)this.nonProxyHosts));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addfilenameresult", (boolean)this.addfilenameresult));
        retval.append("      <headers>").append(Const.CR);
        if (this.headerName != null) {
            for (int i = 0; i < this.headerName.length; ++i) {
                retval.append("        <header>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"header_name", (String)this.headerName[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"header_value", (String)this.headerValue[i]));
                retval.append("        </header>").append(Const.CR);
            }
        }
        retval.append("      </headers>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.url = XMLHandler.getTagValue((Node)entrynode, (String)"url");
            this.targetFilename = XMLHandler.getTagValue((Node)entrynode, (String)"targetfilename");
            this.fileAppended = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"file_appended"));
            this.dateTimeAdded = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"date_time_added"));
            this.targetFilenameExtention = XMLHandler.getTagValue((Node)entrynode, (String)"targetfilename_extention");
            this.uploadFilename = XMLHandler.getTagValue((Node)entrynode, (String)"uploadfilename");
            this.urlFieldname = XMLHandler.getTagValue((Node)entrynode, (String)"url_fieldname");
            this.runForEveryRow = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"run_every_row"));
            this.username = XMLHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"password"));
            this.proxyHostname = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_host");
            this.proxyPort = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_port");
            this.nonProxyHosts = XMLHandler.getTagValue((Node)entrynode, (String)"non_proxy_hosts");
            this.addfilenameresult = "Y".equalsIgnoreCase(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"addfilenameresult"), (String)"Y"));
            Node headers = XMLHandler.getSubNode((Node)entrynode, (String)"headers");
            int nrHeaders = XMLHandler.countNodes((Node)headers, (String)"header");
            this.headerName = new String[nrHeaders];
            this.headerValue = new String[nrHeaders];
            for (int i = 0; i < nrHeaders; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)headers, (String)"header", (int)i);
                this.headerName[i] = XMLHandler.getTagValue((Node)fnode, (String)"header_name");
                this.headerValue[i] = XMLHandler.getTagValue((Node)fnode, (String)"header_value");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'HTTP' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.url = rep.getJobEntryAttributeString(id_jobentry, "url");
            this.targetFilename = rep.getJobEntryAttributeString(id_jobentry, "targetfilename");
            this.fileAppended = rep.getJobEntryAttributeBoolean(id_jobentry, "file_appended");
            this.dateTimeAdded = rep.getJobEntryAttributeBoolean(id_jobentry, "date_time_added");
            this.targetFilenameExtention = rep.getJobEntryAttributeString(id_jobentry, "targetfilename_extention");
            this.uploadFilename = rep.getJobEntryAttributeString(id_jobentry, "uploadfilename");
            this.urlFieldname = rep.getJobEntryAttributeString(id_jobentry, "url_fieldname");
            this.runForEveryRow = rep.getJobEntryAttributeBoolean(id_jobentry, "run_every_row");
            this.username = rep.getJobEntryAttributeString(id_jobentry, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "password"));
            this.proxyHostname = rep.getJobEntryAttributeString(id_jobentry, "proxy_host");
            this.proxyPort = rep.getJobEntryAttributeString(id_jobentry, "proxy_port");
            this.nonProxyHosts = rep.getJobEntryAttributeString(id_jobentry, "non_proxy_hosts");
            this.addfilenameresult = "Y".equalsIgnoreCase(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "addfilenameresult"), (String)"Y"));
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "header_name");
            this.headerName = new String[argnr];
            this.headerValue = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.headerName[a] = rep.getJobEntryAttributeString(id_jobentry, a, "header_name");
                this.headerValue[a] = rep.getJobEntryAttributeString(id_jobentry, a, "header_value");
            }
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'HTTP' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "url", this.url);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "targetfilename", this.targetFilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "file_appended", this.fileAppended);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "date_time_added", this.dateTimeAdded);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "targetfilename_extention", this.targetFilenameExtention);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "uploadfilename", this.uploadFilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "url_fieldname", this.urlFieldname);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "run_every_row", this.runForEveryRow);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "username", this.username);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_host", this.proxyHostname);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_port", this.proxyPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "non_proxy_hosts", this.nonProxyHosts);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "addfilenameresult", this.addfilenameresult);
            if (this.headerName != null) {
                for (int i = 0; i < this.headerName.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "header_name", this.headerName[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "header_value", this.headerValue[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'HTTP' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getTargetFilename() {
        return this.targetFilename;
    }

    public void setTargetFilename(String targetFilename) {
        this.targetFilename = targetFilename;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public void setNonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }

    public boolean isAddFilenameToResult() {
        return this.addfilenameresult;
    }

    public void setAddFilenameToResult(boolean addfilenameresult) {
        this.addfilenameresult = addfilenameresult;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProxyHostname() {
        return this.proxyHostname;
    }

    public void setProxyHostname(String proxyHostname) {
        this.proxyHostname = proxyHostname;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String[] getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String[] headerName) {
        this.headerName = headerName;
    }

    public String[] getHeaderValue() {
        return this.headerValue;
    }

    public void setHeaderValue(String[] headerValue) {
        this.headerValue = headerValue;
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized Result execute(Result previousResult, int nr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public String getUploadFilename() {
        return this.uploadFilename;
    }

    public void setUploadFilename(String uploadFilename) {
        this.uploadFilename = uploadFilename;
    }

    public String getUrlFieldname() {
        return this.urlFieldname;
    }

    public void setUrlFieldname(String getFieldname) {
        this.urlFieldname = getFieldname;
    }

    public boolean isRunForEveryRow() {
        return this.runForEveryRow;
    }

    public void setRunForEveryRow(boolean runForEveryRow) {
        this.runForEveryRow = runForEveryRow;
    }

    public boolean isFileAppended() {
        return this.fileAppended;
    }

    public void setFileAppended(boolean fileAppended) {
        this.fileAppended = fileAppended;
    }

    public boolean isDateTimeAdded() {
        return this.dateTimeAdded;
    }

    public void setDateTimeAdded(boolean dateTimeAdded) {
        this.dateTimeAdded = dateTimeAdded;
    }

    public String getTargetFilenameExtention() {
        return this.targetFilenameExtention;
    }

    public void setTargetFilenameExtention(String uploadFilenameExtention) {
        this.targetFilenameExtention = uploadFilenameExtention;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        String realUrl = jobMeta.environmentSubstitute(this.url);
        ResourceReference reference = new ResourceReference(this);
        reference.getEntries().add(new ResourceEntry(realUrl, ResourceEntry.ResourceType.URL));
        references.add(reference);
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate(this, "targetFilename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "targetFilenameExtention", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "uploadFilename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "proxyPort", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
    }
}

