/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.attributes.metastore;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;
import org.pentaho.di.core.attributes.metastore.AttributesInterfaceEntry;
import org.pentaho.metastore.api.BaseElementType;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public abstract class JsonElementType
extends BaseElementType
implements AttributesInterfaceEntry {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonElementType(String namespace) {
        super(namespace);
    }

    public static JsonElementType from(IMetaStoreElementType elementType) {
        if (elementType instanceof JsonElementType) {
            return (JsonElementType)elementType;
        }
        return new DerivedJsonElementType(elementType);
    }

    public String getId() {
        if (Strings.isNullOrEmpty((String)super.getId())) {
            this.setId(this.getName());
        }
        return Strings.emptyToNull((String)super.getId());
    }

    public static String groupName(String namespace) {
        return "METASTORE." + namespace;
    }

    @Override
    public String groupName() {
        return JsonElementType.groupName(this.getNamespace());
    }

    @Override
    public String key() {
        return (String)Preconditions.checkNotNull((Object)this.getId());
    }

    @Override
    public String jsonValue() throws IOException {
        return this.objectMapper.writeValueAsString((Object)this);
    }

    public JsonElementType load(String jsonData) throws IOException {
        return (JsonElementType)this.objectMapper.readerForUpdating((Object)this).readValue(jsonData);
    }

    private static class DerivedJsonElementType
    extends JsonElementType {
        private final IMetaStoreElementType elementType;

        public DerivedJsonElementType(IMetaStoreElementType elementType) {
            super(elementType.getNamespace());
            this.elementType = elementType;
            this.copyFrom(elementType);
        }

        public void save() throws MetaStoreException {
            this.elementType.save();
        }
    }
}

