/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export.pdf.classic;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.ImgTemplate;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.FopGlyphProcessor;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RadioCheckField;
import com.lowagie.text.pdf.TextField;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.export.AbstractPdfTextRenderer;
import net.sf.jasperreports.engine.export.PdfTextRenderer;
import net.sf.jasperreports.engine.export.SimplePdfTextRenderer;
import net.sf.jasperreports.engine.export.type.PdfFieldTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.BreakIteratorSplitCharacter;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.NullOutputStream;
import net.sf.jasperreports.export.pdf.PdfChunk;
import net.sf.jasperreports.export.pdf.PdfContent;
import net.sf.jasperreports.export.pdf.PdfDocument;
import net.sf.jasperreports.export.pdf.PdfDocumentWriter;
import net.sf.jasperreports.export.pdf.PdfImage;
import net.sf.jasperreports.export.pdf.PdfOutlineEntry;
import net.sf.jasperreports.export.pdf.PdfPhrase;
import net.sf.jasperreports.export.pdf.PdfProducer;
import net.sf.jasperreports.export.pdf.PdfProducerContext;
import net.sf.jasperreports.export.pdf.PdfRadioCheck;
import net.sf.jasperreports.export.pdf.PdfStructure;
import net.sf.jasperreports.export.pdf.PdfTextChunk;
import net.sf.jasperreports.export.pdf.PdfTextField;
import net.sf.jasperreports.export.pdf.PdfTextRendererContext;
import net.sf.jasperreports.export.pdf.classic.ClassicChunk;
import net.sf.jasperreports.export.pdf.classic.ClassicDocument;
import net.sf.jasperreports.export.pdf.classic.ClassicFontRecipient;
import net.sf.jasperreports.export.pdf.classic.ClassicImage;
import net.sf.jasperreports.export.pdf.classic.ClassicPdfContent;
import net.sf.jasperreports.export.pdf.classic.ClassicPdfFontMapper;
import net.sf.jasperreports.export.pdf.classic.ClassicPdfOutline;
import net.sf.jasperreports.export.pdf.classic.ClassicPdfStructure;
import net.sf.jasperreports.export.pdf.classic.ClassicPdfTextField;
import net.sf.jasperreports.export.pdf.classic.ClassicPdfWriter;
import net.sf.jasperreports.export.pdf.classic.ClassicPhrase;
import net.sf.jasperreports.export.pdf.classic.ClassicRadioCheck;
import net.sf.jasperreports.export.pdf.classic.ClassicTextChunk;
import net.sf.jasperreports.export.pdf.classic.GlyphRendering;
import net.sf.jasperreports.renderers.Graphics2DRenderable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassicPdfProducer
implements PdfProducer {
    private static final Log log = LogFactory.getLog(ClassicPdfProducer.class);
    public static final String PROPERTY_FOP_GLYPH_SUBSTITUTION_ENABLED = "net.sf.jasperreports.export.pdf.classic.fop.glyph.substitution.enabled";
    public static final String PROPERTY_DOCUMENT_LANGUAGE = "net.sf.jasperreports.export.pdf.classic.document.language";
    private PdfProducerContext context;
    private ClassicPdfStructure pdfStructure;
    private ClassicDocument document;
    private ClassicPdfWriter writer;
    private Document imageTesterDocument;
    private PdfContentByte imageTesterPdfContentByte;
    private SplitCharacter splitCharacter;
    private GlyphRendering glyphRendering;
    private ClassicPdfContent pdfContent;
    private Map<String, RadioCheckField> radioFieldFactories;
    private Map<String, PdfFormField> radioGroups;

    public ClassicPdfProducer(PdfProducerContext context) {
        this.context = context;
        this.glyphRendering = new GlyphRendering(this);
    }

    @Override
    public PdfProducerContext getContext() {
        return this.context;
    }

    @Override
    public PdfDocument createDocument(PrintPageFormat pageFormat) {
        Document pdfDocument = new Document(new Rectangle((float)pageFormat.getPageWidth().intValue(), (float)pageFormat.getPageHeight().intValue()));
        this.setDocumentProperties(pdfDocument);
        this.imageTesterDocument = new Document(new Rectangle(10.0f, 10.0f));
        this.document = new ClassicDocument(pdfDocument);
        return this.document;
    }

    protected void setDocumentProperties(Document pdfDocument) {
        boolean glyphSubstitutionEnabled;
        String documentLanguage = this.context.getProperties().getProperty(this.context.getCurrentJasperPrint(), PROPERTY_DOCUMENT_LANGUAGE);
        if (documentLanguage != null) {
            pdfDocument.setDocumentLanguage(documentLanguage);
        }
        if (!(glyphSubstitutionEnabled = this.context.getProperties().getBooleanProperty(this.context.getCurrentJasperPrint(), PROPERTY_FOP_GLYPH_SUBSTITUTION_ENABLED, false)) && FopGlyphProcessor.isFopSupported()) {
            pdfDocument.setGlyphSubstitutionEnabled(false);
        }
    }

    @Override
    public PdfDocumentWriter createWriter(OutputStream os) throws JRException {
        try {
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)this.document.getDocument(), (OutputStream)os);
            pdfWriter.setCloseStream(false);
            PdfWriter imageTesterPdfWriter = PdfWriter.getInstance((Document)this.imageTesterDocument, (OutputStream)new NullOutputStream());
            this.imageTesterDocument.open();
            this.imageTesterDocument.newPage();
            this.imageTesterPdfContentByte = imageTesterPdfWriter.getDirectContent();
            this.imageTesterPdfContentByte.setLiteral("\n");
            this.writer = new ClassicPdfWriter(this, pdfWriter);
            return this.writer;
        }
        catch (DocumentException e) {
            throw this.context.handleDocumentException((Exception)((Object)e));
        }
    }

    public PdfWriter getPdfWriter() {
        return this.writer.getPdfWriter();
    }

    @Override
    public void setTagged() {
        this.writer.getPdfWriter().setTagged();
    }

    @Override
    public PdfContent createPdfContent() {
        this.pdfContent = new ClassicPdfContent(this.writer.getPdfWriter(), this.context.getCMYKColorSpace());
        return this.pdfContent;
    }

    @Override
    public PdfContent getPdfContent() {
        return this.pdfContent;
    }

    public PdfContentByte getPdfContentByte() {
        return this.pdfContent.getPdfContentByte();
    }

    @Override
    public void initReport() {
        this.glyphRendering.initGlyphRenderer();
    }

    @Override
    public void setForceLineBreakPolicy(boolean forceLineBreakPolicy) {
        this.splitCharacter = forceLineBreakPolicy ? new BreakIteratorSplitCharacter() : null;
    }

    @Override
    public void newPage() {
        this.document.getDocument().newPage();
        this.pdfContent.refreshContent();
    }

    @Override
    public void setPageSize(PrintPageFormat pageFormat, int pageWidth, int pageHeight) {
        Rectangle pageSize;
        switch (pageFormat.getOrientation()) {
            case LANDSCAPE: {
                pageSize = new Rectangle((float)pageHeight, (float)pageWidth).rotate();
                break;
            }
            default: {
                pageSize = new Rectangle((float)pageWidth, (float)pageHeight);
            }
        }
        this.document.getDocument().setPageSize(pageSize);
    }

    @Override
    public void endPage() {
        if (this.radioGroups != null) {
            for (PdfFormField radioGroup : this.radioGroups.values()) {
                this.getPdfWriter().addAnnotation((PdfAnnotation)radioGroup);
            }
            this.radioGroups = null;
            this.radioFieldFactories = null;
        }
    }

    @Override
    public void close() {
        this.document.getDocument().close();
        this.imageTesterDocument.close();
    }

    @Override
    public AbstractPdfTextRenderer getTextRenderer(PdfTextRendererContext textContext) {
        AbstractPdfTextRenderer textRenderer = this.glyphRendering.getGlyphTextRenderer(textContext);
        if (textRenderer == null) {
            textRenderer = textContext.getPrintText().getLeadingOffset() == 0.0f ? new PdfTextRenderer(this.context.getJasperReportsContext(), textContext.getAwtIgnoreMissingFont(), textContext.getIndentFirstLine(), textContext.getJustifyLastLine()) : new SimplePdfTextRenderer(this.context.getJasperReportsContext(), textContext);
        }
        return textRenderer;
    }

    @Override
    public AbstractPdfTextRenderer getTextRenderer(JRPrintText text, JRStyledText styledText, Locale textLocale, boolean awtIgnoreMissingFont, boolean defaultIndentFirstLine, boolean defaultJustifyLastLine) {
        AbstractPdfTextRenderer textRenderer = this.glyphRendering.getGlyphTextRenderer(text, styledText, textLocale, awtIgnoreMissingFont, defaultIndentFirstLine, defaultJustifyLastLine);
        if (textRenderer == null) {
            textRenderer = text.getLeadingOffset() == 0.0f ? new PdfTextRenderer(this.context.getJasperReportsContext(), awtIgnoreMissingFont, defaultIndentFirstLine, defaultJustifyLastLine) : new SimplePdfTextRenderer(this.context.getJasperReportsContext(), awtIgnoreMissingFont, defaultIndentFirstLine, defaultJustifyLastLine);
        }
        return textRenderer;
    }

    @Override
    public PdfImage createImage(byte[] data, boolean verify) throws IOException, JRException {
        try {
            Image image = Image.getInstance((byte[])data);
            if (verify) {
                this.imageTesterPdfContentByte.addImage(image, 10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f);
            }
            return new ClassicImage(image);
        }
        catch (DocumentException e) {
            throw this.context.handleDocumentException((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PdfImage drawImage(JRPrintImage image, Graphics2DRenderable renderer, boolean forceSvgShapes, double renderWidth, double renderHeight) throws JRException, IOException {
        PdfContentByte pdfContentByte = this.getPdfContentByte();
        PdfTemplate template = pdfContentByte.createTemplate((float)renderWidth, (float)renderHeight);
        Graphics2D g = forceSvgShapes ? template.createGraphicsShapes((float)renderWidth, (float)renderHeight) : template.createGraphics((float)renderWidth, (float)renderHeight, (FontMapper)new ClassicPdfFontMapper(this));
        try {
            if (image.getModeValue() == ModeEnum.OPAQUE) {
                g.setColor(image.getBackcolor());
                g.fillRect(0, 0, (int)renderWidth, (int)renderHeight);
            }
            renderer.render(this.context.getJasperReportsContext(), g, new Rectangle2D.Double(0.0, 0.0, renderWidth, renderHeight));
        }
        finally {
            g.dispose();
        }
        return new ClassicImage((Image)new ImgTemplate(template));
    }

    @Override
    public PdfImage clipImage(PdfImage image, int clipWidth, int clipHeight, int translateX, int translateY) throws JRException {
        Image img = ((ClassicImage)image).getImage();
        PdfContentByte pdfContentByte = this.getPdfContentByte();
        PdfTemplate template = pdfContentByte.createTemplate(img.getWidth(), img.getHeight());
        template.newPath();
        template.rectangle((float)(-translateX), img.getHeight() - (float)clipHeight + (float)translateY, (float)clipWidth, (float)clipHeight);
        template.clip();
        template.newPath();
        img.setAbsolutePosition(0.0f, 0.0f);
        template.addImage(img);
        return new ClassicImage(Image.getInstance((PdfTemplate)template));
    }

    public Font getFont(Map<AttributedCharacterIterator.Attribute, Object> attributes, Locale locale) {
        ClassicFontRecipient fontRecipient = new ClassicFontRecipient(this.context.getCMYKColorSpace());
        this.context.setFont(attributes, locale, false, fontRecipient);
        Font font = fontRecipient.getFont();
        return font;
    }

    @Override
    public PdfTextChunk createChunk(String text, Map<AttributedCharacterIterator.Attribute, Object> attributes, Locale locale) {
        Font font = this.getFont(attributes, locale);
        Chunk chunk = new Chunk(text, font);
        if (this.splitCharacter != null) {
            chunk.setSplitCharacter(this.splitCharacter);
        }
        return new ClassicTextChunk(this, chunk, font);
    }

    @Override
    public PdfChunk createChunk(PdfImage imageContainer) {
        Image image = ((ClassicImage)imageContainer).getImage();
        Chunk chunk = new Chunk(image, 0.0f, 0.0f);
        return new ClassicChunk(this, chunk);
    }

    @Override
    public PdfPhrase createPhrase() {
        Phrase phrase = new Phrase();
        return new ClassicPhrase(this, phrase);
    }

    @Override
    public PdfPhrase createPhrase(PdfChunk chunk) {
        Phrase phrase = new Phrase(((ClassicChunk)chunk).getChunk());
        return new ClassicPhrase(this, phrase);
    }

    @Override
    public PdfTextField createTextField(float llx, float lly, float urx, float ury, String fieldName) {
        TextField textField = this.createTextFormField(llx, lly, urx, ury, fieldName);
        return new ClassicPdfTextField(this, textField, PdfFieldTypeEnum.TEXT);
    }

    protected TextField createTextFormField(float llx, float lly, float urx, float ury, String fieldName) {
        Rectangle rectangle = new Rectangle(llx, lly, urx, ury);
        TextField textField = new TextField(this.writer.getPdfWriter(), rectangle, fieldName);
        return textField;
    }

    @Override
    public PdfTextField createComboField(float llx, float lly, float urx, float ury, String fieldName, String value, String[] choices) {
        TextField textField = this.createTextFormField(llx, lly, urx, ury, fieldName);
        this.setFieldChoices(textField, value, choices);
        return new ClassicPdfTextField(this, textField, PdfFieldTypeEnum.COMBO);
    }

    protected void setFieldChoices(TextField textField, String value, String[] choices) {
        if (choices != null) {
            textField.setChoices(choices);
            if (value != null) {
                int i = 0;
                for (String choice : choices) {
                    if (value.equals(choice)) {
                        textField.setChoiceSelection(i);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public PdfTextField createListField(float llx, float lly, float urx, float ury, String fieldName, String value, String[] choices) {
        TextField textField = this.createTextFormField(llx, lly, urx, ury, fieldName);
        this.setFieldChoices(textField, value, choices);
        return new ClassicPdfTextField(this, textField, PdfFieldTypeEnum.LIST);
    }

    @Override
    public PdfRadioCheck createCheckField(float llx, float lly, float urx, float ury, String fieldName, String onValue) {
        Rectangle rectangle = new Rectangle(llx, lly, urx, ury);
        RadioCheckField radioField = new RadioCheckField(this.writer.getPdfWriter(), rectangle, fieldName, onValue);
        return new ClassicRadioCheck(this, radioField);
    }

    @Override
    public PdfRadioCheck getRadioField(float llx, float lly, float urx, float ury, String fieldName, String onValue) {
        RadioCheckField radioField;
        Rectangle rectangle = new Rectangle(llx, lly, urx, ury);
        RadioCheckField radioCheckField = radioField = this.radioFieldFactories == null ? null : this.radioFieldFactories.get(fieldName);
        if (radioField == null) {
            radioField = new RadioCheckField(this.writer.getPdfWriter(), rectangle, fieldName, onValue);
            if (this.radioFieldFactories == null) {
                this.radioFieldFactories = new HashMap<String, RadioCheckField>();
            }
            this.radioFieldFactories.put(fieldName, radioField);
        }
        radioField.setBox(rectangle);
        return new ClassicRadioCheck(this, radioField);
    }

    protected PdfFormField getRadioGroup(RadioCheckField radioCheckField) {
        PdfFormField radioGroup;
        String fieldName = radioCheckField.getFieldName();
        PdfFormField pdfFormField = radioGroup = this.radioGroups == null ? null : this.radioGroups.get(fieldName);
        if (radioGroup == null) {
            if (this.radioGroups == null) {
                this.radioGroups = new HashMap<String, PdfFormField>();
            }
            radioGroup = radioCheckField.getRadioGroup(true, false);
            this.radioGroups.put(fieldName, radioGroup);
        }
        return radioGroup;
    }

    @Override
    public PdfOutlineEntry getRootOutline() {
        PdfOutline rootOutline = this.pdfContent.getPdfContentByte().getRootOutline();
        return new ClassicPdfOutline(rootOutline);
    }

    @Override
    public PdfStructure getPdfStructure() {
        if (this.pdfStructure == null) {
            this.pdfStructure = new ClassicPdfStructure(this);
        }
        return this.pdfStructure;
    }
}

