/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTextAlignment;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.ooxml.XlsxParagraphHelper;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.ObjectUtils;

public class XlsxStyleInfo {
    protected int formatIndex;
    protected int fontIndex;
    protected int borderIndex;
    protected String backcolor;
    protected String horizontalAlign;
    protected String verticalAlign;
    protected boolean isWrapText = true;
    protected boolean isHidden;
    protected boolean isLocked;
    protected boolean isShrinkToFit;
    protected boolean isIgnoreTextFormatting;
    protected int rotation;
    protected boolean whitePageBackground;
    protected boolean ignoreCellBackground;
    protected boolean ignoreCellBorder;
    protected LineDirectionEnum direction;

    public XlsxStyleInfo(int formatIndex, int fontIndex, int borderIndex, boolean isWrapText, boolean isHidden, boolean isLocked, boolean isShrinkToFit, boolean isIgnoreTextFormatting, int rotation, JRXlsAbstractExporter.SheetInfo sheetInfo, LineDirectionEnum direction) {
        this.formatIndex = formatIndex;
        this.fontIndex = isIgnoreTextFormatting ? -1 : fontIndex;
        this.borderIndex = isIgnoreTextFormatting ? -1 : borderIndex;
        this.isWrapText = isShrinkToFit ? false : isWrapText;
        this.isHidden = isHidden;
        this.isLocked = isLocked;
        this.isShrinkToFit = isShrinkToFit;
        this.rotation = rotation;
        if (sheetInfo != null) {
            if (sheetInfo.whitePageBackground != null) {
                this.whitePageBackground = sheetInfo.whitePageBackground;
            }
            if (sheetInfo.ignoreCellBackground != null) {
                this.ignoreCellBackground = sheetInfo.ignoreCellBackground;
            }
            if (sheetInfo.ignoreCellBorder != null) {
                this.ignoreCellBorder = sheetInfo.ignoreCellBorder;
            }
        }
        this.direction = direction;
    }

    public XlsxStyleInfo(int formatIndex, int fontIndex, int borderIndex, JRPrintElement element, boolean isWrapText, boolean isHidden, boolean isLocked, boolean isShrinkToFit, boolean isIgnoreTextFormatting, int rotation, JRXlsAbstractExporter.SheetInfo sheetInfo, LineDirectionEnum direction, JRStyle parentStyle) {
        this(formatIndex, fontIndex, borderIndex, isWrapText, isHidden, isLocked, isShrinkToFit, isIgnoreTextFormatting, rotation, sheetInfo, direction);
        JRTextAlignment align;
        if (!isIgnoreTextFormatting) {
            if (element != null && element.getModeValue() == ModeEnum.OPAQUE) {
                this.backcolor = JRColorUtil.getColorHexa(element.getBackcolor());
            } else if (parentStyle != null && parentStyle.getBackcolor() != null) {
                this.backcolor = JRColorUtil.getColorHexa(parentStyle.getBackcolor());
            }
        }
        JRTextAlignment jRTextAlignment = align = element != null && element instanceof JRTextAlignment ? (JRTextAlignment)((Object)element) : null;
        if (align != null) {
            this.horizontalAlign = this.getHorizontalAlignment(align.getHorizontalTextAlign(), align.getVerticalTextAlign(), rotation);
            this.verticalAlign = this.getVerticalAlignment(align.getHorizontalTextAlign(), align.getVerticalTextAlign(), rotation);
        }
    }

    public XlsxStyleInfo(int formatIndex, int fontIndex, int borderIndex, JRExporterGridCell gridCell, JRPrintElement element, boolean isWrapText, boolean isHidden, boolean isLocked, boolean isShrinkToFit, boolean isIgnoreTextFormatting, int rotation, JRXlsAbstractExporter.SheetInfo sheetInfo, LineDirectionEnum direction) {
        this(formatIndex, fontIndex, borderIndex, isWrapText, isHidden, isLocked, isShrinkToFit, isIgnoreTextFormatting, rotation, sheetInfo, direction);
        JRTextAlignment align;
        if (!isIgnoreTextFormatting) {
            if (element != null && element.getModeValue() == ModeEnum.OPAQUE) {
                this.backcolor = JRColorUtil.getColorHexa(element.getBackcolor());
            } else if (gridCell != null && gridCell.getBackcolor() != null) {
                this.backcolor = JRColorUtil.getColorHexa(gridCell.getBackcolor());
            }
        }
        JRTextAlignment jRTextAlignment = align = element != null && element instanceof JRTextAlignment ? (JRTextAlignment)((Object)element) : null;
        if (align != null) {
            this.horizontalAlign = this.getHorizontalAlignment(align.getHorizontalTextAlign(), align.getVerticalTextAlign(), rotation);
            this.verticalAlign = this.getVerticalAlignment(align.getHorizontalTextAlign(), align.getVerticalTextAlign(), rotation);
        }
    }

    protected String getHorizontalAlignment(HorizontalTextAlignEnum hAlign, VerticalTextAlignEnum vAlign, int rotation) {
        block0 : switch (rotation) {
            case 90: {
                switch (vAlign) {
                    case JUSTIFIED: {
                        hAlign = HorizontalTextAlignEnum.JUSTIFIED;
                        break block0;
                    }
                    case BOTTOM: {
                        hAlign = HorizontalTextAlignEnum.RIGHT;
                        break block0;
                    }
                    case MIDDLE: {
                        hAlign = HorizontalTextAlignEnum.CENTER;
                        break block0;
                    }
                }
                hAlign = HorizontalTextAlignEnum.LEFT;
                break;
            }
            case 180: {
                switch (vAlign) {
                    case JUSTIFIED: {
                        hAlign = HorizontalTextAlignEnum.JUSTIFIED;
                        break block0;
                    }
                    case BOTTOM: {
                        hAlign = HorizontalTextAlignEnum.LEFT;
                        break block0;
                    }
                    case MIDDLE: {
                        hAlign = HorizontalTextAlignEnum.CENTER;
                        break block0;
                    }
                }
                hAlign = HorizontalTextAlignEnum.RIGHT;
                break;
            }
        }
        return XlsxParagraphHelper.getHorizontalAlignment(hAlign);
    }

    protected String getVerticalAlignment(HorizontalTextAlignEnum hAlign, VerticalTextAlignEnum vAlign, int rotation) {
        block0 : switch (rotation) {
            case 90: {
                switch (hAlign) {
                    case JUSTIFIED: {
                        vAlign = VerticalTextAlignEnum.JUSTIFIED;
                        break block0;
                    }
                    case RIGHT: {
                        vAlign = VerticalTextAlignEnum.TOP;
                        break block0;
                    }
                    case CENTER: {
                        vAlign = VerticalTextAlignEnum.MIDDLE;
                        break block0;
                    }
                }
                vAlign = VerticalTextAlignEnum.BOTTOM;
                break;
            }
            case 180: {
                switch (hAlign) {
                    case JUSTIFIED: {
                        vAlign = VerticalTextAlignEnum.JUSTIFIED;
                        break block0;
                    }
                    case RIGHT: {
                        vAlign = VerticalTextAlignEnum.BOTTOM;
                        break block0;
                    }
                    case CENTER: {
                        vAlign = VerticalTextAlignEnum.MIDDLE;
                        break block0;
                    }
                }
                vAlign = VerticalTextAlignEnum.TOP;
                break;
            }
        }
        return XlsxParagraphHelper.getVerticalAlignment(vAlign);
    }

    public int hashCode() {
        int hash = 47 + this.formatIndex;
        hash = 29 * hash + this.fontIndex;
        hash = 29 * hash + this.borderIndex;
        hash = 29 * hash + ObjectUtils.hashCode(this.backcolor);
        hash = 29 * hash + ObjectUtils.hashCode(this.horizontalAlign);
        hash = 29 * hash + ObjectUtils.hashCode(this.verticalAlign);
        hash = 29 * hash + Boolean.hashCode(this.isWrapText);
        hash = 29 * hash + Boolean.hashCode(this.isHidden);
        hash = 29 * hash + Boolean.hashCode(this.isLocked);
        hash = 29 * hash + Boolean.hashCode(this.isShrinkToFit);
        hash = 29 * hash + this.rotation;
        hash = 29 * hash + Boolean.hashCode(this.whitePageBackground);
        hash = 29 * hash + Boolean.hashCode(this.ignoreCellBackground);
        hash = 29 * hash + Boolean.hashCode(this.ignoreCellBorder);
        hash = 29 * hash + ObjectUtils.hashCode(this.direction);
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XlsxStyleInfo)) {
            return false;
        }
        XlsxStyleInfo info = (XlsxStyleInfo)obj;
        return this.formatIndex == info.formatIndex && this.fontIndex == info.fontIndex && this.borderIndex == info.borderIndex && ObjectUtils.equals(this.backcolor, info.backcolor) && ObjectUtils.equals(this.horizontalAlign, info.horizontalAlign) && ObjectUtils.equals(this.verticalAlign, info.verticalAlign) && this.isWrapText == info.isWrapText && this.isHidden == info.isHidden && this.isLocked == info.isLocked && this.isShrinkToFit == info.isShrinkToFit && this.rotation == info.rotation && this.whitePageBackground == info.whitePageBackground && this.ignoreCellBackground == info.ignoreCellBackground && this.ignoreCellBorder == info.ignoreCellBorder && this.direction == info.direction;
    }
}

