/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth.plugin;

import de.his.security.auth.AuthenticationManagerConfig;
import de.his.security.auth.plugin.AuthenticationPlugin;
import de.his.tools.PropUtil;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import net.sf.jpam.Pam;
import net.sf.jpam.PamReturnValue;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class PAMAuth
implements AuthenticationPlugin {
    private static Logger logger = Logger.getLogger(PAMAuth.class);

    @Override
    public boolean init(AuthenticationManagerConfig authConfig, Element confElement) {
        logger.debug((Object)("AuthPlugin: " + this.getClass()));
        return true;
    }

    @Override
    public Properties authTest(Element confElement, Properties authProp, HttpServletRequest request, Properties userProp) {
        Pam pam;
        PamReturnValue returnValue;
        String username = authProp.getProperty("username", "");
        String password = authProp.getProperty("password", "");
        if (username.trim().equals("") || password.trim().equals("")) {
            return userProp;
        }
        String service = confElement.getChildText("service-name");
        if (service == null || service.trim().equals("")) {
            service = "qis";
        }
        if ((returnValue = (pam = new Pam(service)).authenticate(username, password)) == PamReturnValue.PAM_SUCCESS) {
            userProp.putAll((Map<?, ?>)PropUtil.xmlToProperties(confElement.getChild("user-prop")));
            userProp.put("authenticated", "y");
        } else {
            logger.warn((Object)returnValue.toString());
        }
        return userProp;
    }
}

