/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth.plugin;

import de.his.net.IPRange;
import de.his.security.auth.AuthenticationManagerConfig;
import de.his.security.auth.plugin.AuthenticationPlugin;
import de.his.tools.PropUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class IPBasedAuth
implements AuthenticationPlugin {
    private static Logger logger = Logger.getLogger(IPBasedAuth.class);

    @Override
    public boolean init(AuthenticationManagerConfig authConfig, Element confElement) {
        logger.debug((Object)("AuthPlugin: " + this.getClass()));
        return true;
    }

    @Override
    public Properties authTest(Element confElement, Properties authProp, HttpServletRequest request, Properties userProp) {
        if (request == null) {
            logger.debug((Object)"IPBasedAuth uebersprungen, weil request==null");
            return userProp;
        }
        Element ips = confElement.getChild("ips");
        if (ips == null) {
            logger.error((Object)"Erwarte ips-Kindelement im IPBasedAuth-Abschnitt der LoginConf.xml");
            return userProp;
        }
        String remoteAddr = request.getRemoteAddr();
        boolean res = this.checkIP(ips, remoteAddr);
        if (!res) {
            String xff = request.getHeader("X-Forwarded-For");
            res = this.checkXForwaredFor(confElement, xff, ips, remoteAddr);
        }
        if (res) {
            userProp.putAll((Map<?, ?>)PropUtil.xmlToProperties(confElement.getChild("user-prop")));
        }
        return userProp;
    }

    boolean checkXForwaredFor(Element confElement, String xff, Element ips, String remoteAddr) {
        boolean res = false;
        String trustedXFFServer = confElement.getAttributeValue("trust-xff", "").trim();
        if (!trustedXFFServer.trim().equals("") && this.checkIP(trustedXFFServer, remoteAddr)) {
            StringTokenizer st = new StringTokenizer(xff, ", ");
            while (st.hasMoreTokens()) {
                String xffIP = st.nextToken();
                res = this.checkIP(ips, xffIP);
                if (res) {
                    logger.debug((Object)("IP-Adresse " + xffIP + " aus X-Forwarded-For-Header von " + remoteAddr + " akzeptiert"));
                    continue;
                }
                logger.debug((Object)("IP-Adresse " + xffIP + " aus X-Forwarded-For-Header von " + remoteAddr + " nicht akzeptiert"));
                break;
            }
        }
        return res;
    }

    boolean checkIP(String ips, String remoteAddr) {
        List<IPRange> ipranges = IPRange.parseIPRanges(ips);
        try {
            if (IPRange.ipAddressInRanges(InetAddress.getByName(remoteAddr), ipranges)) {
                return true;
            }
        }
        catch (UnknownHostException e) {
            logger.warn((Object)e, (Throwable)e);
        }
        return false;
    }

    boolean checkIP(Element ips, String remoteAddr) {
        for (Element ip : ips.getChildren()) {
            if (!this.checkIP(ip.getText(), remoteAddr)) continue;
            return true;
        }
        return false;
    }
}

