/*
 * Decompiled with CFR 0.152.
 */
package de.his.otherlicence.shacrypt;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public final class Sha256Crypt {
    private static final String sha256_salt_prefix = "$5$";
    private static final String sha256_rounds_prefix = "rounds=";
    private static final int SALT_LEN_MAX = 16;
    private static final int ROUNDS_DEFAULT = 5000;
    private static final int ROUNDS_MIN = 1000;
    private static final int ROUNDS_MAX = 999999999;
    private static final String SALTCHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    private static final String itoa64 = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    private static MessageDigest getSHA256() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final String Sha256_crypt(String keyStr, String saltStr, int roundsCount) {
        int cnt;
        MessageDigest ctx = Sha256Crypt.getSHA256();
        MessageDigest alt_ctx = Sha256Crypt.getSHA256();
        byte[] p_bytes = null;
        byte[] s_bytes = null;
        int rounds = 5000;
        if (saltStr != null) {
            if (saltStr.startsWith(sha256_salt_prefix)) {
                saltStr = saltStr.substring(sha256_salt_prefix.length());
            }
            if (saltStr.startsWith(sha256_rounds_prefix)) {
                String num = saltStr.substring(sha256_rounds_prefix.length(), saltStr.indexOf(36));
                int srounds = Integer.valueOf(num);
                saltStr = saltStr.substring(saltStr.indexOf(36) + 1);
                rounds = Math.max(1000, Math.min(srounds, 999999999));
            }
            if (saltStr.length() > 16) {
                saltStr = saltStr.substring(0, 16);
            }
        } else {
            Random randgen = new Random();
            StringBuffer saltBuf = new StringBuffer();
            while (saltBuf.length() < 16) {
                int index = (int)(randgen.nextFloat() * (float)SALTCHARS.length());
                saltBuf.append(SALTCHARS.substring(index, index + 1));
            }
            saltStr = saltBuf.toString();
        }
        if (roundsCount != 0) {
            rounds = Math.max(1000, Math.min(roundsCount, 999999999));
        }
        byte[] key = keyStr.getBytes();
        byte[] salt = saltStr.getBytes();
        ctx.reset();
        ctx.update(key, 0, key.length);
        ctx.update(salt, 0, salt.length);
        alt_ctx.reset();
        alt_ctx.update(key, 0, key.length);
        alt_ctx.update(salt, 0, salt.length);
        alt_ctx.update(key, 0, key.length);
        byte[] alt_result = alt_ctx.digest();
        for (cnt = key.length; cnt > 32; cnt -= 32) {
            ctx.update(alt_result, 0, 32);
        }
        ctx.update(alt_result, 0, cnt);
        for (cnt = key.length; cnt > 0; cnt >>= 1) {
            if ((cnt & 1) != 0) {
                ctx.update(alt_result, 0, 32);
                continue;
            }
            ctx.update(key, 0, key.length);
        }
        alt_result = ctx.digest();
        alt_ctx.reset();
        for (cnt = 0; cnt < key.length; ++cnt) {
            alt_ctx.update(key, 0, key.length);
        }
        byte[] temp_result = alt_ctx.digest();
        p_bytes = new byte[key.length];
        int cnt2 = 0;
        for (cnt = p_bytes.length; cnt >= 32; cnt -= 32) {
            System.arraycopy(temp_result, 0, p_bytes, cnt2, 32);
            cnt2 += 32;
        }
        System.arraycopy(temp_result, 0, p_bytes, cnt2, cnt);
        alt_ctx.reset();
        for (cnt = 0; cnt < 16 + (alt_result[0] & 0xFF); ++cnt) {
            alt_ctx.update(salt, 0, salt.length);
        }
        temp_result = alt_ctx.digest();
        s_bytes = new byte[salt.length];
        cnt2 = 0;
        for (cnt = s_bytes.length; cnt >= 32; cnt -= 32) {
            System.arraycopy(temp_result, 0, s_bytes, cnt2, 32);
            cnt2 += 32;
        }
        System.arraycopy(temp_result, 0, s_bytes, cnt2, cnt);
        for (cnt = 0; cnt < rounds; ++cnt) {
            ctx.reset();
            if ((cnt & 1) != 0) {
                ctx.update(p_bytes, 0, key.length);
            } else {
                ctx.update(alt_result, 0, 32);
            }
            if (cnt % 3 != 0) {
                ctx.update(s_bytes, 0, salt.length);
            }
            if (cnt % 7 != 0) {
                ctx.update(p_bytes, 0, key.length);
            }
            if ((cnt & 1) != 0) {
                ctx.update(alt_result, 0, 32);
            } else {
                ctx.update(p_bytes, 0, key.length);
            }
            alt_result = ctx.digest();
        }
        StringBuffer buffer = new StringBuffer(sha256_salt_prefix);
        if (rounds != 5000) {
            buffer.append(sha256_rounds_prefix);
            buffer.append(rounds);
            buffer.append("$");
        }
        buffer.append(saltStr);
        buffer.append("$");
        buffer.append(Sha256Crypt.b64_from_24bit(alt_result[0], alt_result[10], alt_result[20], 4));
        buffer.append(Sha256Crypt.b64_from_24bit(alt_result[21], alt_result[1], alt_result[11], 4));
        buffer.append(Sha256Crypt.b64_from_24bit(alt_result[12], alt_result[22], alt_result[2], 4));
        buffer.append(Sha256Crypt.b64_from_24bit(alt_result[3], alt_result[13], alt_result[23], 4));
        buffer.append(Sha256Crypt.b64_from_24bit(alt_result[24], alt_result[4], alt_result[14], 4));
        buffer.append(Sha256Crypt.b64_from_24bit(alt_result[15], alt_result[25], alt_result[5], 4));
        buffer.append(Sha256Crypt.b64_from_24bit(alt_result[6], alt_result[16], alt_result[26], 4));
        buffer.append(Sha256Crypt.b64_from_24bit(alt_result[27], alt_result[7], alt_result[17], 4));
        buffer.append(Sha256Crypt.b64_from_24bit(alt_result[18], alt_result[28], alt_result[8], 4));
        buffer.append(Sha256Crypt.b64_from_24bit(alt_result[9], alt_result[19], alt_result[29], 4));
        buffer.append(Sha256Crypt.b64_from_24bit((byte)0, alt_result[31], alt_result[30], 3));
        ctx.reset();
        return buffer.toString();
    }

    private static final String b64_from_24bit(byte B2, byte B1, byte B0, int size) {
        int v = (B2 & 0xFF) << 16 | (B1 & 0xFF) << 8 | B0 & 0xFF;
        StringBuffer result = new StringBuffer();
        while (--size >= 0) {
            result.append(itoa64.charAt(v & 0x3F));
            v >>>= 6;
        }
        return result.toString();
    }

    public static final boolean verifyPassword(String plaintextPass, String sha256CryptText) {
        if (sha256CryptText.startsWith(sha256_salt_prefix)) {
            String saltWithPrefix = sha256CryptText.substring(0, sha256CryptText.lastIndexOf("$"));
            return sha256CryptText.equals(Sha256Crypt.Sha256_crypt(plaintextPass, saltWithPrefix, 0));
        }
        throw new RuntimeException("Bad sha256CryptText");
    }

    public static final boolean verifyHashTextFormat(String sha256CryptText) {
        if (!sha256CryptText.startsWith(sha256_salt_prefix)) {
            return false;
        }
        if ((sha256CryptText = sha256CryptText.substring(sha256_salt_prefix.length())).startsWith(sha256_rounds_prefix)) {
            String num = sha256CryptText.substring(sha256_rounds_prefix.length(), sha256CryptText.indexOf(36));
            try {
                Integer.valueOf(num).intValue();
            }
            catch (NumberFormatException ex) {
                return false;
            }
            sha256CryptText = sha256CryptText.substring(sha256CryptText.indexOf(36) + 1);
        }
        if (sha256CryptText.indexOf(36) > 17) {
            return false;
        }
        sha256CryptText = sha256CryptText.substring(sha256CryptText.indexOf(36) + 1);
        for (int i = 0; i < sha256CryptText.length(); ++i) {
            if (itoa64.indexOf(sha256CryptText.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    private static void selfTest() {
        System.out.println("Verify Password Test: " + Sha256Crypt.verifyPassword("Hello world!", "$5$saltstring$5B8vYYiY.CVt1RlTTf8KbXBH3hsxY/GNooZaBBGWEc5"));
        String[] msgs = new String[]{"$5$saltstring", "Hello world!", "$5$saltstring$5B8vYYiY.CVt1RlTTf8KbXBH3hsxY/GNooZaBBGWEc5", "$5$rounds=10000$saltstringsaltstring", "Hello world!", "$5$rounds=10000$saltstringsaltst$3xv.VbSHBb41AL9AvLeujZkZRBAwqFMz2.opqey6IcA", "$5$rounds=5000$toolongsaltstring", "This is just a test", "$5$rounds=5000$toolongsaltstrin$Un/5jzAHMgOGZ5.mWJpuVolil07guHPvOW8mGRcvxa5", "$5$rounds=1400$anotherlongsaltstring", "a very much longer text to encrypt.  This one even stretches over morethan one line.", "$5$rounds=1400$anotherlongsalts$Rx.j8H.h8HjEDGomFU8bDkXm3XIUnzyxf12oP84Bnq1", "$5$rounds=77777$short", "we have a short salt string but not a short password", "$5$rounds=77777$short$JiO1O3ZpDAxGJeaDIuqCoEFysAe1mZNJRs3pw0KQRd/", "$5$rounds=123456$asaltof16chars..", "a short string", "$5$rounds=123456$asaltof16chars..$gP3VQ/6X7UUEW3HkBn2w1/Ptq2jxPyzV/cZKmF/wJvD", "$5$rounds=10$roundstoolow", "the minimum number is still observed", "$5$rounds=1000$roundstoolow$yfvwcWrQ8l/K0DAWyuPMDNHpIVlTQebY9l/gL972bIC"};
        System.out.println("Starting Sha256Crypt tests now...");
        String salt = "$5$saltstring";
        String msg = "Hello world!";
        String res = "$5$saltstring$5B8vYYiY.CVt1RlTTf8KbXBH3hsxY/GNooZaBBGWEc5";
        String result = Sha256Crypt.Sha256_crypt(msg, salt, 0);
        System.out.println("result is:" + result);
        System.out.println("should be:" + res);
        if (result.equals(res)) {
            System.out.println("Passed well");
        } else {
            System.out.println("Failed Badly");
        }
        for (int t = 0; t < 7; ++t) {
            result = Sha256Crypt.Sha256_crypt(msgs[t * 3 + 1], msgs[t * 3], 0);
            System.out.println("test " + t + " result is:" + result);
            System.out.println("test " + t + " should be:" + msgs[t * 3 + 2]);
            if (result.equals(msgs[t * 3 + 2])) {
                System.out.println("Passed well");
                continue;
            }
            System.out.println("Failed Badly");
        }
    }

    public static void main(String[] arg) {
        Sha256Crypt.selfTest();
    }
}

